/*
 * Decompiled with CFR 0.152.
 */
package com.infobright.etl.model;

import com.infobright.etl.model.BrighthouseRecord;
import com.infobright.etl.model.NullIndicator;
import com.infobright.etl.model.ValueConverter;
import com.infobright.etl.model.ValueConverterException;
import com.infobright.etl.model.datatype.AbstractColumnType;
import com.infobright.logging.EtlLogger;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TeradataBinaryRecord
extends BrighthouseRecord {
    private static final int BUFFER_SIZE = 100000;
    private final ByteBuffer byteBuffer;
    private final NullIndicator nullind;
    private final EtlLogger logger;

    TeradataBinaryRecord(List<AbstractColumnType> columns, Charset charset) {
        this(columns, charset, null);
    }

    TeradataBinaryRecord(List<AbstractColumnType> columns, Charset charset, EtlLogger logger) {
        super(columns, charset);
        this.logger = logger;
        this.nullind = new NullIndicator(columns.size());
        this.byteBuffer = ByteBuffer.allocate(100000);
        this.byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
    }

    @Override
    public int size() {
        return this.columns.size();
    }

    @Override
    public void writeTo(OutputStream os) throws IOException {
        this.byteBuffer.rewind();
        short len = 0;
        this.byteBuffer.putShort(len);
        int startingPosition = this.byteBuffer.position();
        this.nullind.reset();
        int colidx = -1;
        for (AbstractColumnType col : this.columns) {
            ++colidx;
            if (!col.getIsNull()) continue;
            this.nullind.setToNull(colidx);
        }
        this.byteBuffer.put(this.nullind.getBytes());
        for (AbstractColumnType col : this.columns) {
            col.getData(this.byteBuffer);
        }
        int currentPosition = this.byteBuffer.position();
        len = (short)(currentPosition - startingPosition);
        this.byteBuffer.rewind();
        this.byteBuffer.putShort(len);
        this.byteBuffer.position(currentPosition);
        byte[] data = this.byteBuffer.array();
        os.write(data, 0, len + 2);
    }

    @Override
    public void setData(int colidx, Object value, ValueConverter meta) throws ValueConverterException {
        AbstractColumnType col = (AbstractColumnType)this.columns.get(colidx);
        if (value == null) {
            col.setIsNull(true);
        } else {
            col.setIsNull(false);
            col.setData(value, meta);
        }
    }
}

