/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metaverse.analyzer.kettle.step.textfileoutput;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.vfs2.FileObject;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleFileException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.steps.textfileoutput.TextFileOutput;
import org.pentaho.di.trans.steps.textfileoutput.TextFileOutputData;
import org.pentaho.di.trans.steps.textfileoutput.TextFileOutputMeta;
import org.pentaho.metaverse.api.IAnalysisContext;
import org.pentaho.metaverse.api.analyzer.kettle.step.BaseStepExternalResourceConsumer;
import org.pentaho.metaverse.api.model.ExternalResourceInfoFactory;
import org.pentaho.metaverse.api.model.IExternalResourceInfo;

public class TextFileOutputExternalResourceConsumer
extends BaseStepExternalResourceConsumer<TextFileOutput, TextFileOutputMeta> {
    public boolean isDataDriven(TextFileOutputMeta meta) {
        return meta.isFileNameInField();
    }

    public Collection<IExternalResourceInfo> getResourcesFromMeta(TextFileOutputMeta meta, IAnalysisContext context) {
        String[] paths;
        TransMeta parentTransMeta;
        StepMeta parentStepMeta;
        List<IExternalResourceInfo> resources = Collections.emptyList();
        if (!this.isDataDriven(meta) && (parentStepMeta = meta.getParentStepMeta()) != null && (parentTransMeta = parentStepMeta.getParentTransMeta()) != null && (paths = meta.getFiles((VariableSpace)parentTransMeta)) != null) {
            resources = new ArrayList<IExternalResourceInfo>(paths.length);
            for (String path : paths) {
                if (Const.isEmpty((String)path)) continue;
                try {
                    IExternalResourceInfo resource = ExternalResourceInfoFactory.createFileResource((FileObject)KettleVFS.getFileObject((String)path), (boolean)false);
                    if (resource == null) {
                        throw new KettleFileException("Error getting file resource!");
                    }
                    resources.add(resource);
                }
                catch (KettleFileException kettleFileException) {
                    // empty catch block
                }
            }
        }
        return resources;
    }

    public Collection<IExternalResourceInfo> getResourcesFromRow(TextFileOutput textFileOutput, RowMetaInterface rowMeta, Object[] row) {
        LinkedList<IExternalResourceInfo> resources = new LinkedList<IExternalResourceInfo>();
        TextFileOutputMeta meta = (TextFileOutputMeta)textFileOutput.getStepMeta().getStepMetaInterface();
        try {
            TextFileOutputData data = (TextFileOutputData)textFileOutput.getStepDataInterface();
            String filename = rowMeta.getString(row, meta.getFileNameField(), meta.getFileName());
            if (null != data) {
                filename = textFileOutput.buildFilename(Const.isEmpty((String)data.fileName) ? filename : data.fileName, true);
            }
            if (!Const.isEmpty((String)filename)) {
                FileObject fileObject = KettleVFS.getFileObject((String)filename);
                resources.add(ExternalResourceInfoFactory.createFileResource((FileObject)fileObject, (boolean)false));
            }
        }
        catch (KettleException kettleException) {
            // empty catch block
        }
        return resources;
    }

    public Class<TextFileOutputMeta> getMetaClass() {
        return TextFileOutputMeta.class;
    }
}

