/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metaverse.analyzer.kettle.extensionpoints.trans;

import com.tinkerpop.blueprints.Graph;
import com.tinkerpop.blueprints.impls.tg.TinkerGraph;
import java.net.URLConnection;
import org.pentaho.di.core.KettleClientEnvironment;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.metaverse.api.IDocument;
import org.pentaho.metaverse.api.IMetaverseNode;
import org.pentaho.metaverse.api.IMetaverseObjectFactory;
import org.pentaho.metaverse.api.INamespace;
import org.pentaho.metaverse.api.MetaverseException;
import org.pentaho.metaverse.api.Namespace;
import org.pentaho.metaverse.api.analyzer.kettle.KettleAnalyzerUtil;
import org.pentaho.metaverse.impl.MetaverseBuilder;
import org.pentaho.metaverse.messages.Messages;
import org.pentaho.metaverse.util.MetaverseUtil;

public class TransExtensionPointUtil {
    public static void addLineageGraph(TransMeta transMeta) throws MetaverseException {
        if (transMeta == null) {
            throw new MetaverseException(Messages.getString("ERROR.Document.IsNull"));
        }
        String filename = TransExtensionPointUtil.getFilename(transMeta);
        TinkerGraph graph = new TinkerGraph();
        MetaverseBuilder metaverseBuilder = new MetaverseBuilder((Graph)graph);
        IMetaverseObjectFactory objFactory = MetaverseUtil.getDocumentController().getMetaverseObjectFactory();
        String clientName = KettleClientEnvironment.getInstance().getClient().toString();
        Namespace namespace = new Namespace(clientName);
        IMetaverseNode designNode = objFactory.createNodeObject(clientName, clientName, "Locator");
        metaverseBuilder.addNode(designNode);
        IDocument document = MetaverseUtil.createDocument((INamespace)namespace, transMeta, filename, transMeta.getName(), transMeta.getDefaultExtension(), URLConnection.getFileNameMap().getContentTypeFor("trans.ktr"));
        MetaverseUtil.addLineageGraph(document, (Graph)graph);
    }

    public static String getFilename(TransMeta transMeta) {
        return KettleAnalyzerUtil.getFilename((TransMeta)transMeta);
    }
}

