/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.util.commtrace;

import java.util.Vector;

class IPAddressConversion {
    private String IPaddr;
    private int type = UNDEF;
    public static int UNDEF = -1;
    public static int IPv4 = 0;
    public static int IPv4Hex = 1;
    public static int IPv6 = 2;
    public static int IPvMixed = 3;
    public static int IPvMixedHex = 4;

    public IPAddressConversion(String string) {
        this.IPaddr = string;
        this.settype();
    }

    public IPAddressConversion(String string, int n) {
        this.IPaddr = string;
        this.type = n;
    }

    public int type() {
        return this.type;
    }

    private String toDec(String string) {
        return new Integer(Integer.parseInt(string, 16)).toString();
    }

    public String[] split(String string, String string2) {
        Vector<String> vector = new Vector<String>(12);
        int n = 0;
        int n2 = 0;
        while ((n2 = string.indexOf(string2, n)) != -1) {
            vector.add(string.substring(n, n2));
            n = n2 + 1;
        }
        vector.add(string.substring(n));
        String[] stringArray = new String[vector.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = (String)vector.remove(0);
        }
        return stringArray;
    }

    public String ntop() {
        if (this.type == IPv4 || this.type == IPv4Hex) {
            String[] stringArray = this.split(this.IPaddr, ".");
            return this.ntopIPv4(stringArray);
        }
        if (this.type == IPv6) {
            String[] stringArray = this.split(this.IPaddr, ":");
            stringArray = this.trim(stringArray);
            return this.ntopIPv6(stringArray);
        }
        if (this.type == IPvMixed) {
            String[] stringArray = this.split(this.IPaddr, ":");
            String[] stringArray2 = this.split(stringArray[7], ".");
            stringArray[7] = "";
            stringArray = this.trim(stringArray);
            stringArray2 = this.trim(stringArray2);
            return this.ntopIPv6(stringArray) + ":" + this.ntopIPv4(stringArray2);
        }
        return "";
    }

    private String ntopIPv4(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer(32);
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = this.type == IPv4Hex || this.type == IPvMixedHex ? this.toDec(stringArray[i]) : new Integer(Integer.parseInt(stringArray[i])).toString();
            stringBuffer.append(stringArray[i] + ".");
        }
        return stringBuffer.substring(0, stringBuffer.length() - 1).toString();
    }

    private String ntopIPv6(String[] stringArray) {
        int n;
        boolean bl = false;
        boolean bl2 = false;
        int n2 = 0;
        int n3 = 0;
        StringBuffer stringBuffer = new StringBuffer(64);
        for (n = 0; n < stringArray.length; ++n) {
            if (stringArray[n].charAt(0) == '0' && !bl) {
                if (n == 0) {
                    stringBuffer.append(":");
                }
                bl = true;
                n2 = n;
            }
            if (!bl || n3 != 0 || n + 1 >= stringArray.length || stringArray[n + 1].charAt(0) == '0') continue;
            n3 = n;
        }
        for (n = 0; n < stringArray.length; ++n) {
            if (!bl) {
                stringBuffer.append(stringArray[n] + ":");
                continue;
            }
            if (!bl2) {
                if (stringArray[n].charAt(0) != '0') {
                    stringBuffer.append(stringArray[n] + ":");
                    continue;
                }
                if (n2 == n3) continue;
                stringBuffer.append(":");
                n = n3;
                bl2 = true;
                continue;
            }
            stringBuffer.append(stringArray[n] + ":");
        }
        return stringBuffer.substring(0, stringBuffer.length() - 1).toString();
    }

    private String[] trim(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer(64);
        for (int i = 0; i < stringArray.length; ++i) {
            boolean bl = true;
            char[] cArray = stringArray[i].toCharArray();
            for (int j = 0; j < cArray.length; ++j) {
                if (cArray[j] == '0' && bl) {
                    if (this.type == IPv4 || this.type == IPv4Hex) {
                        if (j <= 1) continue;
                        stringBuffer.append("0");
                        continue;
                    }
                    if (this.type == IPv6) {
                        if (j <= 2) continue;
                        stringBuffer.append("0");
                        continue;
                    }
                    if (this.type != IPvMixed && this.type != IPvMixedHex || j <= 2) continue;
                    stringBuffer.append("0");
                    continue;
                }
                if (bl) {
                    bl = false;
                }
                stringBuffer.append(cArray[j]);
            }
            if (this.type == IPv4 || this.type == IPv4Hex) {
                stringBuffer.append(".");
                continue;
            }
            if (this.type == IPv6) {
                stringBuffer.append(":");
                continue;
            }
            if (this.type != IPvMixed && this.type != IPvMixedHex) continue;
            stringBuffer.append(":");
        }
        if (this.type == IPv4 || this.type == IPv4Hex) {
            return this.split(stringBuffer.substring(0, stringBuffer.length() - 1), ".");
        }
        if (this.type == IPv6) {
            return this.split(stringBuffer.substring(0, stringBuffer.length() - 1), ":");
        }
        if (this.type == IPvMixed || this.type == IPvMixedHex) {
            return this.split(stringBuffer.substring(0, stringBuffer.length() - 1), ":");
        }
        return this.split(stringBuffer.toString(), ".");
    }

    public String pton() {
        if (this.type == IPv4 || this.type == IPv4Hex) {
            String[] stringArray = this.split(this.IPaddr, ".");
            return this.ptonIPv4(stringArray);
        }
        if (this.type == IPv6) {
            String[] stringArray = this.split(this.IPaddr, ":");
            return this.ptonIPv6(stringArray);
        }
        if (this.type == IPvMixed || this.type == IPvMixedHex) {
            String[] stringArray = this.split(this.IPaddr, ":");
            String[] stringArray2 = null;
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].indexOf(46) == -1) continue;
                stringArray2 = this.split(stringArray[i], ".");
                stringArray[i] = "";
                int n = i;
            }
            return this.ptonIPv6(stringArray) + ":" + this.ptonIPv4(stringArray2);
        }
        return "Unknown Type of IP Address";
    }

    private String ptonIPv4(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer(32);
        for (int i = 0; i < stringArray.length; ++i) {
            int n = stringArray[i].length();
            if (n == 3) {
                stringBuffer.append(stringArray[i] + ".");
                continue;
            }
            if (n == 2) {
                stringBuffer.append("0".concat(stringArray[i]) + ".");
                continue;
            }
            if (n != 1) continue;
            stringBuffer.append("00".concat(stringArray[i]) + ".");
        }
        return stringBuffer.substring(0, stringBuffer.length() - 1).toString();
    }

    private String ptonIPv6(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer(64);
        if (stringArray.length < 8) {
            int n;
            stringArray = new String[8];
            String[] stringArray2 = this.split(this.IPaddr, "::");
            String[] stringArray3 = this.split(stringArray2[0], ":");
            String[] stringArray4 = this.split(stringArray2[1], ":");
            int n2 = 0;
            n2 = stringArray2[0].equals("") ? 9 - stringArray3.length - stringArray4.length : 8 - stringArray3.length - stringArray4.length;
            int n3 = 0;
            for (n = 0; n < stringArray3.length; ++n) {
                stringArray[n3] = stringArray3[n];
                if (stringArray2[0].equals("")) continue;
                ++n3;
            }
            for (n = 0; n < n2; ++n) {
                stringArray[n3] = "0";
                ++n3;
            }
            for (n = 0; n < stringArray4.length; ++n) {
                stringArray[n3] = stringArray4[n];
                ++n3;
            }
        }
        for (int i = 0; i < stringArray.length; ++i) {
            int n = stringArray[i].length();
            if (n == 4) {
                stringBuffer.append(stringArray[i] + ":");
                continue;
            }
            if (n == 3) {
                stringBuffer.append("0".concat(stringArray[i]) + ":");
                continue;
            }
            if (n == 2) {
                stringBuffer.append("00".concat(stringArray[i]) + ":");
                continue;
            }
            if (n != 1) continue;
            stringBuffer.append("000".concat(stringArray[i]) + ":");
        }
        return stringBuffer.substring(0, stringBuffer.length() - 1).toString();
    }

    private void settype() {
        int n = this.IPaddr.length();
        for (int i = 0; i < n; ++i) {
            if (this.IPaddr.charAt(i) == ':') {
                if (this.type != UNDEF) continue;
                this.type = IPv6;
                continue;
            }
            if (this.IPaddr.charAt(i) != '.') continue;
            if (this.type == UNDEF) {
                this.type = IPv4;
                break;
            }
            this.type = IPvMixed;
            break;
        }
    }
}

