/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.security.auth;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.Trace;
import java.beans.PropertyVetoException;

class AuthenticationSystem {
    private static final String copyright = "Copyright (C) 1997-2003 International Business Machines Corporation and others.";
    private static AS400 system_ = null;
    private static boolean onAS400_ = false;

    private AuthenticationSystem() {
    }

    static void handleUnexpectedException(Throwable throwable) {
        Trace.log(2, "Unexpected Exception:", throwable);
        throw new InternalErrorException(10);
    }

    static boolean isLocal(AS400 aS400) {
        return aS400.isLocal() && aS400.getUserId().trim().equalsIgnoreCase(new AS400().getUserId());
    }

    static AS400 localHost() {
        return system_;
    }

    static void resetLocalHost() {
        if (!onAS400_) {
            return;
        }
        try {
            system_.resetAllServices();
            system_.setUserId("");
            system_.setPassword("");
            system_.getServicePort(7);
        }
        catch (PropertyVetoException propertyVetoException) {
            AuthenticationSystem.handleUnexpectedException(propertyVetoException);
        }
    }

    static {
        try {
            system_ = new AS400();
            system_.setGuiAvailable(false);
        }
        catch (PropertyVetoException propertyVetoException) {
            AuthenticationSystem.handleUnexpectedException(propertyVetoException);
        }
        try {
            String string = System.getProperty("os.name");
            Trace.log(1, "Detected os.name: " + string);
            if (string != null && string.equalsIgnoreCase("OS/400")) {
                onAS400_ = true;
            }
        }
        catch (SecurityException securityException) {
            Trace.log(4, "Error retrieving os.name:", (Throwable)securityException);
        }
    }
}

