/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.data;

import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.Trace;
import com.ibm.as400.data.ParseException;
import com.ibm.as400.data.PcmlAttribute;
import com.ibm.as400.data.PcmlAttributeList;
import com.ibm.as400.data.PcmlData;
import com.ibm.as400.data.PcmlDimensions;
import com.ibm.as400.data.PcmlDocNode;
import com.ibm.as400.data.PcmlDocument;
import com.ibm.as400.data.PcmlNode;
import com.ibm.as400.data.PcmlProgram;
import com.ibm.as400.data.PcmlSpecificationException;
import com.ibm.as400.data.PcmlStruct;
import com.ibm.as400.data.SystemResourceFinder;
import com.ibm.as400.data.XMLErrorHandler;
import com.ibm.as400.data.XPCMLHelper;
import com.ibm.as400.data.XmlException;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.SequenceInputStream;
import java.util.Enumeration;
import java.util.MissingResourceException;
import java.util.Stack;
import java.util.Vector;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

class PcmlSAXParser
extends DefaultHandler {
    private static final String copyright = "Copyright (C) 1997-2003 International Business Machines Corporation and others.";
    private transient PcmlDocument m_rootNode;
    private transient PcmlDocNode m_currentNode;
    private transient String m_docName;
    Vector curAttrs;
    Vector curQName;
    int curDim;
    String lastQName;
    int[] dimArray;
    PcmlDimensions dimensions;
    private String initValue;
    private boolean isXPCML;
    private String xsdStreamName;
    private boolean firstInstance;
    ByteArrayOutputStream xmlOut;
    ByteArrayInputStream stream;
    private InputStream xsdFileStream;
    private static final String NAMESPACES_FEATURE_ID = "http://xml.org/sax/features/namespaces";
    private static final String NAMESPACE_PREFIXES_FEATURE_ID = "http://xml.org/sax/features/namespace-prefixes";
    private static final String VALIDATION_FEATURE_ID = "http://xml.org/sax/features/validation";
    private static final String SCHEMA_VALIDATION_FEATURE_ID = "http://apache.org/xml/features/validation/schema";
    private static final String SCHEMA_FULL_CHECKING_FEATURE_ID = "http://apache.org/xml/features/validation/schema-full-checking";
    private static final String DYNAMIC_VALIDATION_FEATURE_ID = "http://apache.org/xml/features/validation/dynamic";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PcmlSAXParser(String string, ClassLoader classLoader, InputStream inputStream) throws MissingResourceException, IOException, ParseException, PcmlSpecificationException, FactoryConfigurationError, ParserConfigurationException, SAXException {
        Exception exception3;
        BufferedInputStream bufferedInputStream;
        SequenceInputStream sequenceInputStream;
        InputStream inputStream2;
        block39: {
            this.curAttrs = new Vector();
            this.curQName = new Vector();
            this.curDim = -1;
            this.lastQName = "";
            this.dimArray = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
            this.dimensions = new PcmlDimensions(this.dimArray);
            this.initValue = "";
            this.isXPCML = false;
            this.firstInstance = true;
            this.xmlOut = new ByteArrayOutputStream();
            this.m_rootNode = null;
            this.m_currentNode = null;
            this.xsdFileStream = inputStream;
            this.xsdStreamName = "";
            this.curAttrs.add(0, new AttributesImpl());
            this.curQName.add(0, new String(""));
            String string2 = string.endsWith(".pcml") || string.endsWith(".pcmlsrc") || string.endsWith(".xpcml") || string.endsWith(".xpcmlsrc") ? string.substring(0, string.lastIndexOf(46)) : string;
            this.m_docName = string2.substring(string2.lastIndexOf(46) + 1);
            this.isXPCML = SystemResourceFinder.isXPCML(string, classLoader);
            InputStream inputStream3 = null;
            inputStream2 = null;
            sequenceInputStream = null;
            bufferedInputStream = null;
            try {
                Object object;
                if (this.isXPCML && this.xsdFileStream != null) {
                    try {
                        XPCMLHelper.doSimplifyXSDTransform(this.xsdFileStream, this.xmlOut);
                    }
                    catch (IOException iOException) {
                        throw iOException;
                    }
                    catch (SAXException sAXException) {
                        throw sAXException;
                    }
                    this.stream = new ByteArrayInputStream(this.xmlOut.toByteArray());
                    if (this.stream == null) {
                        throw new MissingResourceException(SystemResourceFinder.format("PCML_DTD_NOT_FOUND", new Object[]{"xmlOut"}), "xmlOut", "");
                    }
                }
                if (!this.isXPCML) {
                    inputStream3 = SystemResourceFinder.getPCMLHeader();
                    inputStream2 = SystemResourceFinder.getPCMLDocument(string, classLoader);
                    sequenceInputStream = new SequenceInputStream(inputStream3, inputStream2);
                } else {
                    inputStream2 = SystemResourceFinder.getPCMLDocument(string, classLoader);
                    bufferedInputStream = new BufferedInputStream(inputStream2);
                }
                XMLErrorHandler xMLErrorHandler = new XMLErrorHandler(this.m_docName, SystemResourceFinder.getHeaderLineCount());
                SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
                sAXParserFactory.setValidating(true);
                sAXParserFactory.setNamespaceAware(false);
                if (this.isXPCML) {
                    PcmlSAXParser.setFeatures(sAXParserFactory);
                }
                SAXParser sAXParser = sAXParserFactory.newSAXParser();
                try {
                    object = sAXParser.getXMLReader();
                    object.setErrorHandler(xMLErrorHandler);
                    if (!this.isXPCML) {
                        sAXParser.parse(new InputSource(sequenceInputStream), (DefaultHandler)this);
                        sequenceInputStream.close();
                        sequenceInputStream = null;
                    } else {
                        sAXParser.parse(new InputSource(bufferedInputStream), (DefaultHandler)this);
                        bufferedInputStream.close();
                        bufferedInputStream = null;
                    }
                }
                catch (SAXException sAXException) {
                    ParseException parseException = new ParseException(SystemResourceFinder.format("FAILED_TO_PARSE", new Object[]{this.m_docName}));
                    parseException.addMessage(sAXException.getMessage());
                    throw parseException;
                }
                if (inputStream2 != null) {
                    inputStream2.close();
                    inputStream2 = null;
                }
                if ((object = xMLErrorHandler.getException()) != null) {
                    ((ParseException)object).reportErrors();
                    throw object;
                }
                this.augmentTree(this.m_rootNode, new Stack());
                this.checkAttributes(this.m_rootNode);
                try {
                    if (this.isXPCML) {
                        this.m_rootNode.copyValues(this.m_rootNode, this.m_rootNode);
                    }
                }
                catch (XmlException xmlException) {
                    Trace.log(2, "All data values may not have been copied to struct parm refs...");
                    throw new SAXException(xmlException);
                }
                if (this.m_rootNode != null && this.m_rootNode.getPcmlSpecificationException() != null) {
                    PcmlSpecificationException pcmlSpecificationException = this.m_rootNode.getPcmlSpecificationException();
                    pcmlSpecificationException.printStackTrace();
                    throw this.m_rootNode.getPcmlSpecificationException();
                }
                Object var15_19 = null;
                if (inputStream3 == null) break block39;
            }
            catch (Throwable throwable) {
                Exception exception22;
                Object var15_20 = null;
                if (inputStream3 != null) {
                    try {
                        inputStream3.close();
                    }
                    catch (Exception exception22) {
                        // empty catch block
                    }
                }
                if (inputStream2 != null) {
                    try {
                        inputStream2.close();
                    }
                    catch (Exception exception22) {
                        // empty catch block
                    }
                }
                if (sequenceInputStream != null) {
                    try {
                        sequenceInputStream.close();
                    }
                    catch (Exception exception22) {
                        // empty catch block
                    }
                }
                if (bufferedInputStream != null) {
                    try {
                        bufferedInputStream.close();
                    }
                    catch (Exception exception22) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
            try {
                inputStream3.close();
            }
            catch (Exception exception3) {
                // empty catch block
            }
        }
        if (inputStream2 != null) {
            try {
                inputStream2.close();
            }
            catch (Exception exception3) {
                // empty catch block
            }
        }
        if (sequenceInputStream != null) {
            try {
                sequenceInputStream.close();
            }
            catch (Exception exception3) {
                // empty catch block
            }
        }
        if (bufferedInputStream != null) {
            try {
                bufferedInputStream.close();
            }
            catch (Exception exception3) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PcmlSAXParser(String string, InputStream inputStream, ClassLoader classLoader, InputStream inputStream2, boolean bl) throws MissingResourceException, IOException, ParseException, PcmlSpecificationException, FactoryConfigurationError, ParserConfigurationException, SAXException {
        Exception exception3;
        BufferedInputStream bufferedInputStream;
        SequenceInputStream sequenceInputStream;
        InputStream inputStream3;
        block39: {
            this.curAttrs = new Vector();
            this.curQName = new Vector();
            this.curDim = -1;
            this.lastQName = "";
            this.dimArray = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
            this.dimensions = new PcmlDimensions(this.dimArray);
            this.initValue = "";
            this.isXPCML = false;
            this.firstInstance = true;
            this.xmlOut = new ByteArrayOutputStream();
            this.m_rootNode = null;
            this.m_currentNode = null;
            this.xsdFileStream = inputStream2;
            this.xsdStreamName = "";
            this.isXPCML = bl;
            this.curAttrs.add(0, new AttributesImpl());
            this.curQName.add(0, new String(""));
            String string2 = string.endsWith(".pcml") || string.endsWith(".pcmlsrc") || string.endsWith(".xpcml") || string.endsWith(".xpcmlsrc") ? string.substring(0, string.lastIndexOf(46)) : string;
            this.m_docName = string2.substring(string2.lastIndexOf(46) + 1);
            InputStream inputStream4 = null;
            inputStream3 = null;
            sequenceInputStream = null;
            bufferedInputStream = null;
            try {
                Object object;
                if (bl && this.xsdFileStream != null) {
                    try {
                        XPCMLHelper.doSimplifyXSDTransform(this.xsdFileStream, this.xmlOut);
                    }
                    catch (IOException iOException) {
                        throw iOException;
                    }
                    catch (SAXException sAXException) {
                        throw sAXException;
                    }
                    this.stream = new ByteArrayInputStream(this.xmlOut.toByteArray());
                    if (this.stream == null) {
                        throw new MissingResourceException(SystemResourceFinder.format("PCML_DTD_NOT_FOUND", new Object[]{"xmlOut"}), "xmlOut", "");
                    }
                }
                if (!bl) {
                    inputStream4 = SystemResourceFinder.getPCMLHeader();
                    sequenceInputStream = new SequenceInputStream(inputStream4, inputStream);
                } else {
                    bufferedInputStream = new BufferedInputStream(inputStream);
                }
                XMLErrorHandler xMLErrorHandler = new XMLErrorHandler(this.m_docName, SystemResourceFinder.getHeaderLineCount());
                SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
                sAXParserFactory.setValidating(true);
                sAXParserFactory.setNamespaceAware(false);
                if (bl) {
                    PcmlSAXParser.setFeatures(sAXParserFactory);
                }
                SAXParser sAXParser = sAXParserFactory.newSAXParser();
                try {
                    object = sAXParser.getXMLReader();
                    object.setErrorHandler(xMLErrorHandler);
                    if (!bl) {
                        sAXParser.parse(new InputSource(sequenceInputStream), (DefaultHandler)this);
                        sequenceInputStream.close();
                        sequenceInputStream = null;
                    } else {
                        sAXParser.parse(new InputSource(bufferedInputStream), (DefaultHandler)this);
                        bufferedInputStream.close();
                        bufferedInputStream = null;
                    }
                }
                catch (SAXException sAXException) {
                    ParseException parseException = new ParseException(SystemResourceFinder.format("FAILED_TO_PARSE", new Object[]{this.m_docName}));
                    parseException.addMessage(sAXException.getMessage());
                    throw parseException;
                }
                if (inputStream3 != null) {
                    inputStream3.close();
                    inputStream3 = null;
                }
                if ((object = xMLErrorHandler.getException()) != null) {
                    ((ParseException)object).reportErrors();
                    throw object;
                }
                this.augmentTree(this.m_rootNode, new Stack());
                this.checkAttributes(this.m_rootNode);
                try {
                    if (bl) {
                        this.m_rootNode.copyValues(this.m_rootNode, this.m_rootNode);
                    }
                }
                catch (XmlException xmlException) {
                    Trace.log(2, "All data values may not have been copied to struct parm refs...");
                    throw new SAXException(xmlException);
                }
                if (this.m_rootNode != null && this.m_rootNode.getPcmlSpecificationException() != null) {
                    PcmlSpecificationException pcmlSpecificationException = this.m_rootNode.getPcmlSpecificationException();
                    pcmlSpecificationException.printStackTrace();
                    throw this.m_rootNode.getPcmlSpecificationException();
                }
                Object var17_21 = null;
                if (inputStream4 == null) break block39;
            }
            catch (Throwable throwable) {
                Exception exception22;
                Object var17_22 = null;
                if (inputStream4 != null) {
                    try {
                        inputStream4.close();
                    }
                    catch (Exception exception22) {
                        // empty catch block
                    }
                }
                if (inputStream3 != null) {
                    try {
                        inputStream3.close();
                    }
                    catch (Exception exception22) {
                        // empty catch block
                    }
                }
                if (sequenceInputStream != null) {
                    try {
                        sequenceInputStream.close();
                    }
                    catch (Exception exception22) {
                        // empty catch block
                    }
                }
                if (bufferedInputStream != null) {
                    try {
                        bufferedInputStream.close();
                    }
                    catch (Exception exception22) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
            try {
                inputStream4.close();
            }
            catch (Exception exception3) {
                // empty catch block
            }
        }
        if (inputStream3 != null) {
            try {
                inputStream3.close();
            }
            catch (Exception exception3) {
                // empty catch block
            }
        }
        if (sequenceInputStream != null) {
            try {
                sequenceInputStream.close();
            }
            catch (Exception exception3) {
                // empty catch block
            }
        }
        if (bufferedInputStream != null) {
            try {
                bufferedInputStream.close();
            }
            catch (Exception exception3) {}
        }
    }

    static void setFeatures(SAXParserFactory sAXParserFactory) throws SAXException, SAXNotRecognizedException, SAXNotSupportedException, ParserConfigurationException {
        sAXParserFactory.setFeature(NAMESPACES_FEATURE_ID, true);
        sAXParserFactory.setFeature(NAMESPACE_PREFIXES_FEATURE_ID, true);
        sAXParserFactory.setFeature(VALIDATION_FEATURE_ID, true);
        sAXParserFactory.setFeature(SCHEMA_VALIDATION_FEATURE_ID, true);
        sAXParserFactory.setFeature(SCHEMA_FULL_CHECKING_FEATURE_ID, true);
        sAXParserFactory.setFeature(DYNAMIC_VALIDATION_FEATURE_ID, false);
    }

    PcmlDocument getPcmlDocument() {
        return this.m_rootNode;
    }

    private void augmentTree(PcmlDocNode pcmlDocNode, Stack stack) {
        Enumeration enumeration = pcmlDocNode.getChildren();
        if (enumeration == null) {
            return;
        }
        while (enumeration.hasMoreElements()) {
            String string;
            PcmlData pcmlData;
            PcmlDocNode pcmlDocNode2 = (PcmlDocNode)enumeration.nextElement();
            if (pcmlDocNode2 instanceof PcmlData && (pcmlData = (PcmlData)pcmlDocNode2).getDataType() == 7 && pcmlData.getNbrChildren() == 0 && (string = pcmlData.getStruct()) != null) {
                PcmlDocNode pcmlDocNode3 = (PcmlDocNode)this.m_rootNode.getElement(string);
                if (pcmlDocNode3 instanceof PcmlStruct) {
                    if (stack.search(pcmlDocNode3) != -1) {
                        this.m_rootNode.addPcmlSpecificationError("CIRCULAR_REFERENCE", new Object[]{string, pcmlData.getBracketedTagName(), pcmlData.getNameForException()});
                    } else {
                        Enumeration enumeration2 = pcmlDocNode3.getChildren();
                        while (enumeration2.hasMoreElements()) {
                            PcmlDocNode pcmlDocNode4 = (PcmlDocNode)enumeration2.nextElement();
                            PcmlDocNode pcmlDocNode5 = (PcmlDocNode)pcmlDocNode4.clone();
                            pcmlData.addChild(pcmlDocNode5);
                            this.m_rootNode.addToHashtable(pcmlDocNode5);
                        }
                    }
                } else if (pcmlDocNode3 == null) {
                    this.m_rootNode.addPcmlSpecificationError("REF_NOT_FOUND", new Object[]{string, "<struct>", pcmlData.getBracketedTagName(), pcmlData.getNameForException()});
                } else {
                    this.m_rootNode.addPcmlSpecificationError("REF_WRONG_TYPE", new Object[]{string, "<struct>", pcmlData.getBracketedTagName(), pcmlData.getNameForException()});
                }
            }
            stack.push(pcmlDocNode2);
            this.augmentTree(pcmlDocNode2, stack);
            stack.pop();
        }
    }

    private void checkAttributes(PcmlDocNode pcmlDocNode) {
        Enumeration enumeration = pcmlDocNode.getChildren();
        if (enumeration == null) {
            return;
        }
        while (enumeration.hasMoreElements()) {
            PcmlDocNode pcmlDocNode2 = (PcmlDocNode)enumeration.nextElement();
            pcmlDocNode2.checkAttributes();
            this.checkAttributes(pcmlDocNode2);
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) {
        Object object;
        String string4 = string3;
        PcmlDocNode pcmlDocNode = null;
        String string5 = "";
        String string6 = string3;
        AttributesImpl attributesImpl = new AttributesImpl();
        boolean bl = false;
        boolean bl2 = false;
        this.initValue = "";
        if (!this.isXPCML) {
            object = new PcmlAttributeList(attributes.getLength());
            for (int i = 0; i < attributes.getLength(); ++i) {
                ((PcmlAttributeList)object).addAttribute(new PcmlAttribute(attributes.getQName(i), attributes.getValue(i), true));
            }
            pcmlDocNode = string4.equals("pcml") ? new PcmlDocument((PcmlAttributeList)object, this.m_docName) : (string4.equals("program") ? new PcmlProgram((PcmlAttributeList)object) : (string4.equals("struct") ? new PcmlStruct((PcmlAttributeList)object) : (string4.equals("data") ? new PcmlData((PcmlAttributeList)object) : null)));
            if (pcmlDocNode != null) {
                if (this.m_rootNode == null) {
                    this.m_rootNode = pcmlDocNode;
                    this.m_currentNode = pcmlDocNode;
                } else {
                    this.m_currentNode.addChild(pcmlDocNode);
                    this.m_currentNode = pcmlDocNode;
                }
            }
        }
        if (this.isXPCML) {
            int n;
            boolean bl3;
            String string7;
            Object object2;
            int n2;
            if (!(this.xsdFileStream == null || string3.equals("xpcml") || string3.equals("program") || string3.equals("parameterList") || string3.equals("struct") || string3.equals("stringParm") || string3.equals("intParm") || string3.equals("shortParm") || string3.equals("longParm") || string3.equals("zonedDecimalParm") || string3.equals("floatParm") || string3.equals("packedDecimalParm") || string3.equals("doubleParm") || string3.equals("structParm") || string3.equals("hexBinaryParm") || string3.equals("unsignedIntParm") || string3.equals("unsignedShortParm") || string3.equals("arrayOfStringParm") || string3.equals("arrayOfIntParm") || string3.equals("arrayOfShortParm") || string3.equals("arrayOfLongParm") || string3.equals("arrayOfZonedDecimalParm") || string3.equals("arrayOfFloatParm") || string3.equals("arrayOfPackedDecimalParm") || string3.equals("arrayOfDoubleParm") || string3.equals("arrayOfStructParm") || string3.equals("arrayOfHexBinaryParm") || string3.equals("arrayOfUnsignedIntParm") || string3.equals("arrayOfUnsignedShortParm") || string3.equals("arrayOfStruct"))) {
                bl = true;
                object = new ByteArrayInputStream(this.xmlOut.toByteArray());
                if (object == null) {
                    throw new MissingResourceException(SystemResourceFinder.format("PCML_DTD_NOT_FOUND", new Object[]{"xmlOut"}), "xmlOut", "");
                }
                LineNumberReader lineNumberReader = new LineNumberReader(new InputStreamReader((InputStream)object));
                try {
                    String string8 = lineNumberReader.readLine();
                    n2 = 0;
                    while (string8 != null && n2 == 0) {
                        if (string8.indexOf("name=\"" + string3 + "\"") != -1 && string8.indexOf("parm type=") != -1) {
                            if (string8.indexOf("parm type=string") != -1) {
                                string6 = "stringParm";
                                n2 = 1;
                            } else if (string8.indexOf("parm type=int") != -1) {
                                string6 = "intParm";
                                n2 = 1;
                            } else if (string8.indexOf("parm type=uint") != -1) {
                                string6 = "unsignedIntParm";
                                n2 = 1;
                            } else if (string8.indexOf("parm type=hexBinary") != -1) {
                                string6 = "hexBinaryParm";
                                n2 = 1;
                            } else if (string8.indexOf("parm type=short") != -1) {
                                string6 = "shortParm";
                                n2 = 1;
                            } else if (string8.indexOf("parm type=ushort") != -1) {
                                string6 = "unsignedShortParm";
                                n2 = 1;
                            } else if (string8.indexOf("parm type=long") != -1) {
                                string6 = "longParm";
                                n2 = 1;
                            } else if (string8.indexOf("parm type=float") != -1) {
                                string6 = "floatParm";
                                n2 = 1;
                            } else if (string8.indexOf("parm type=double") != -1) {
                                string6 = "doubleParm";
                                n2 = 1;
                            } else if (string8.indexOf("parm type=packed") != -1) {
                                string6 = "packedDecimalParm";
                                n2 = 1;
                            } else if (string8.indexOf("parm type=zoned") != -1) {
                                string6 = "zonedDecimalParm";
                                n2 = 1;
                            } else if (string8.indexOf("parm type=structParm") != -1) {
                                string6 = "structParm";
                                n2 = 1;
                            } else if (string8.indexOf("parm type=arrayOfString") != -1) {
                                string6 = "arrayOfStringParm";
                                n2 = 1;
                            } else if (string8.indexOf("parm type=arrayOfInt") != -1) {
                                string6 = "arrayOfIntParm";
                                n2 = 1;
                            } else if (string8.indexOf("parm type=arrayOfUInt") != -1) {
                                string6 = "arrayOfUnsignedIntParm";
                                n2 = 1;
                            } else if (string8.indexOf("parm type=arrayOfHexBinary") != -1) {
                                string6 = "arrayOfHexBinaryParm";
                                n2 = 1;
                            } else if (string8.indexOf("parm type=arrayOfShort") != -1) {
                                string6 = "arrayOfShortParm";
                                n2 = 1;
                            } else if (string8.indexOf("parm type=arrayOfUShort") != -1) {
                                string6 = "arrayOfUnsignedShortParm";
                                n2 = 1;
                            } else if (string8.indexOf("parm type=arrayOfLong") != -1) {
                                string6 = "arrayOfLongParm";
                                n2 = 1;
                            } else if (string8.indexOf("parm type=arrayOfFloat") != -1) {
                                string6 = "arrayOfFloatParm";
                                n2 = 1;
                            } else if (string8.indexOf("parm type=arrayOfDouble") != -1) {
                                string6 = "arrayOfDoubleParm";
                                n2 = 1;
                            } else if (string8.indexOf("parm type=arrayOfPacked") != -1) {
                                string6 = "arrayOfPackedDecimalParm";
                                n2 = 1;
                            } else if (string8.indexOf("parm type=arrayOfZoned") != -1) {
                                string6 = "arrayOfZonedDecimalParm";
                                n2 = 1;
                            } else if (string8.indexOf("parm type=arrayOfStructParm") != -1) {
                                string6 = "arrayOfStructParm";
                                n2 = 1;
                            } else if (string8.indexOf("parm type=structArray") != -1) {
                                string6 = "arrayOfStruct";
                                n2 = 1;
                            } else {
                                Trace.log(4, "User defined type passed in not found in xsd stream");
                            }
                            if (n2 == 1) {
                                string8 = lineNumberReader.readLine();
                                while (string8 != null && string8.indexOf("parm type=") == -1) {
                                    object2 = "";
                                    String string9 = "";
                                    if (string8.indexOf("attributeName=") != -1) {
                                        object2 = string8.substring(string8.indexOf("attributeName=") + 14, string8.indexOf("attributeValue=")).trim();
                                    }
                                    if (string8.indexOf("attributeValue=") != -1) {
                                        string9 = string8.substring(string8.indexOf("attributeValue=") + 15).trim();
                                    }
                                    attributesImpl.addAttribute("", "", (String)object2, "", string9);
                                    string8 = lineNumberReader.readLine();
                                }
                            }
                        }
                        if (n2 != 0) continue;
                        string8 = lineNumberReader.readLine();
                    }
                }
                catch (IOException iOException) {
                    Trace.log(7, "Error reading xsd stream in startElement");
                }
            }
            if (string6.equals("arrayOfStringParm") || string6.equals("arrayOfStructParm") || string6.equals("arrayOfIntParm") || string6.equals("arrayOfShortParm") || string6.equals("arrayOfUnsignedIntParm") || string6.equals("arrayOfUnsignedShortParm") || string6.equals("arrayOfLongParm") || string6.equals("arrayOfFloatParm") || string6.equals("arrayOfDoubleParm") || string6.equals("arrayOfZonedDecimalParm") || string6.equals("arrayOfPackedDecimalParm") || string6.equals("arrayOfHexBinaryParm") || string6.equals("arrayOfStruct")) {
                ++this.curDim;
                if (bl) {
                    if (this.curAttrs.size() > this.curDim) {
                        this.curAttrs.set(this.curDim, attributesImpl);
                    } else {
                        this.curAttrs.add(this.curDim, attributesImpl);
                    }
                } else if (this.curAttrs.size() > this.curDim) {
                    this.curAttrs.set(this.curDim, new AttributesImpl(attributes));
                } else {
                    this.curAttrs.add(this.curDim, new AttributesImpl(attributes));
                }
                if (this.curQName.size() > this.curDim) {
                    this.curQName.set(this.curDim, string6);
                } else {
                    this.curQName.add(this.curDim, string6);
                }
                this.lastQName = string6;
            }
            if (string6.equals("i") || string6.equals("struct_i")) {
                if (this.lastQName.indexOf("arrayOf") == -1) {
                    this.dimensions.set(this.curDim, this.dimensions.at(this.curDim) + 1);
                }
                object = new AttributesImpl((AttributesImpl)this.curAttrs.elementAt(this.curDim));
                string7 = new String((String)this.curQName.elementAt(this.curDim));
            } else {
                if (bl) {
                    object = attributesImpl;
                    for (int i = 0; i < attributes.getLength(); ++i) {
                        if (((AttributesImpl)object).getIndex(attributes.getQName(i)) != -1) continue;
                        bl2 = true;
                        ((AttributesImpl)object).addAttribute(attributes.getURI(i), attributes.getLocalName(i), attributes.getQName(i), attributes.getType(i), attributes.getValue(i));
                    }
                } else {
                    object = new AttributesImpl(attributes);
                }
                string7 = string6;
            }
            this.firstInstance = true;
            if (this.m_currentNode != null && this.m_currentNode.getNodeType() == 3 && !string6.equals("struct_i") && !string6.equals("struct") && !string6.equals("xpcml") && (bl3 = this.inTree(string6, (AttributesImpl)object))) {
                this.firstInstance = false;
            }
            for (n = 0; n <= this.curDim; ++n) {
                if (this.dimensions.at(n) <= 0) continue;
                this.firstInstance = false;
            }
            if (string6.equals("i") || string6.equals("struct_i")) {
                for (n = 0; n < attributes.getLength(); ++n) {
                    if (!attributes.getQName(n).equals("index")) continue;
                    Integer n3 = new Integer(attributes.getValue(n));
                    this.dimensions.set(this.curDim, n3);
                }
            }
            this.lastQName = string6;
            if (this.firstInstance && !string6.equals("i") && !string6.equals("struct_i")) {
                PcmlAttributeList pcmlAttributeList = new PcmlAttributeList(((AttributesImpl)object).getLength() + 2);
                for (n2 = 0; n2 < ((AttributesImpl)object).getLength(); ++n2) {
                    if (((AttributesImpl)object).getQName(n2).equals("name")) {
                        string5 = ((AttributesImpl)object).getValue(n2);
                    }
                    if (((AttributesImpl)object).getQName(n2).equals("passDirection")) {
                        if (((AttributesImpl)object).getValue(n2).equals("in")) {
                            pcmlAttributeList.addAttribute(new PcmlAttribute("usage", "input", true));
                            continue;
                        }
                        if (((AttributesImpl)object).getValue(n2).equals("inout")) {
                            pcmlAttributeList.addAttribute(new PcmlAttribute("usage", "inputoutput", true));
                            continue;
                        }
                        if (((AttributesImpl)object).getValue(n2).equals("out")) {
                            pcmlAttributeList.addAttribute(new PcmlAttribute("usage", "output", true));
                            continue;
                        }
                        if (!((AttributesImpl)object).getValue(n2).equals("inherit")) continue;
                        pcmlAttributeList.addAttribute(new PcmlAttribute("usage", "inherit", true));
                        continue;
                    }
                    if (((AttributesImpl)object).getQName(n2).equals("passMode")) {
                        pcmlAttributeList.addAttribute(new PcmlAttribute("passby", ((AttributesImpl)object).getValue(n2), true));
                        continue;
                    }
                    if (((AttributesImpl)object).getQName(n2).equals("bytesPerChar")) {
                        pcmlAttributeList.addAttribute(new PcmlAttribute("chartype", ((AttributesImpl)object).getValue(n2), true));
                        continue;
                    }
                    if (((AttributesImpl)object).getQName(n2).equals("totalBytes")) {
                        pcmlAttributeList.addAttribute(new PcmlAttribute("length", ((AttributesImpl)object).getValue(n2), true));
                        continue;
                    }
                    if (((AttributesImpl)object).getQName(n2).equals("outputSize")) {
                        pcmlAttributeList.addAttribute(new PcmlAttribute("outputsize", ((AttributesImpl)object).getValue(n2), true));
                        continue;
                    }
                    if (((AttributesImpl)object).getQName(n2).equals("entryPoint")) {
                        pcmlAttributeList.addAttribute(new PcmlAttribute("entrypoint", ((AttributesImpl)object).getValue(n2), true));
                        continue;
                    }
                    if (((AttributesImpl)object).getQName(n2).equals("returnValue")) {
                        pcmlAttributeList.addAttribute(new PcmlAttribute("returnvalue", ((AttributesImpl)object).getValue(n2), true));
                        continue;
                    }
                    if (((AttributesImpl)object).getQName(n2).equals("threadSafe")) {
                        pcmlAttributeList.addAttribute(new PcmlAttribute("threadsafe", ((AttributesImpl)object).getValue(n2), true));
                        continue;
                    }
                    if (((AttributesImpl)object).getQName(n2).equals("offsetFrom")) {
                        pcmlAttributeList.addAttribute(new PcmlAttribute("offsetfrom", ((AttributesImpl)object).getValue(n2), true));
                        continue;
                    }
                    if (((AttributesImpl)object).getQName(n2).equals("totalDigits")) {
                        pcmlAttributeList.addAttribute(new PcmlAttribute("length", ((AttributesImpl)object).getValue(n2), true));
                        continue;
                    }
                    if (((AttributesImpl)object).getQName(n2).equals("fractionDigits")) {
                        pcmlAttributeList.addAttribute(new PcmlAttribute("precision", ((AttributesImpl)object).getValue(n2), true));
                        continue;
                    }
                    if (((AttributesImpl)object).getQName(n2).equals("parseOrder")) {
                        pcmlAttributeList.addAttribute(new PcmlAttribute("parseorder", ((AttributesImpl)object).getValue(n2), true));
                        continue;
                    }
                    if (((AttributesImpl)object).getQName(n2).equals("bidiStringType")) {
                        pcmlAttributeList.addAttribute(new PcmlAttribute("bidistringtype", ((AttributesImpl)object).getValue(n2), true));
                        continue;
                    }
                    if (((AttributesImpl)object).getQName(n2).equals("isEmptyString")) {
                        pcmlAttributeList.addAttribute(new PcmlAttribute("init", "", true));
                        continue;
                    }
                    if (string3.equals("xpcml") && (!string3.equals("xpcml") || !((AttributesImpl)object).getQName(n2).equals("version"))) continue;
                    pcmlAttributeList.addAttribute(new PcmlAttribute(((AttributesImpl)object).getQName(n2), ((AttributesImpl)object).getValue(n2), true));
                }
                if (string4.equals("program")) {
                    pcmlDocNode = new PcmlProgram(pcmlAttributeList);
                    for (n2 = 0; n2 < this.dimensions.size(); ++n2) {
                        this.dimensions.set(n2, 0);
                    }
                } else if (string4.equals("struct")) {
                    pcmlDocNode = new PcmlStruct(pcmlAttributeList);
                } else if (string4.equals("arrayOfStruct")) {
                    pcmlDocNode = new PcmlStruct(pcmlAttributeList);
                    if (bl) {
                        pcmlDocNode.setCondensedName(string3);
                    }
                } else if (string6.equals("arrayOfStructParm")) {
                    pcmlAttributeList.addAttribute(new PcmlAttribute("type", "struct", true));
                    pcmlDocNode = new PcmlData(pcmlAttributeList);
                    if (bl) {
                        pcmlDocNode.setCondensedName(string3);
                    }
                } else if (string4.equals("xpcml")) {
                    pcmlDocNode = new PcmlDocument(pcmlAttributeList, this.m_docName);
                } else if (string6.equals("stringParm") || string6.equals("arrayOfStringParm")) {
                    pcmlAttributeList.addAttribute(new PcmlAttribute("type", "char", true));
                    pcmlDocNode = new PcmlData(pcmlAttributeList);
                    if (bl) {
                        pcmlDocNode.setCondensedName(string3);
                    }
                } else if (string6.equals("hexBinaryParm") || string6.equals("arrayOfHexBinaryParm")) {
                    pcmlAttributeList.addAttribute(new PcmlAttribute("type", "byte", true));
                    pcmlDocNode = new PcmlData(pcmlAttributeList);
                    if (bl) {
                        pcmlDocNode.setCondensedName(string3);
                    }
                } else if (string6.equals("intParm") || string6.equals("arrayOfIntParm")) {
                    pcmlAttributeList.addAttribute(new PcmlAttribute("type", "int", true));
                    pcmlAttributeList.addAttribute(new PcmlAttribute("length", "4", true));
                    pcmlDocNode = new PcmlData(pcmlAttributeList);
                    if (bl) {
                        pcmlDocNode.setCondensedName(string3);
                    }
                } else if (string6.equals("unsignedIntParm") || string6.equals("arrayOfUnsignedIntParm")) {
                    pcmlAttributeList.addAttribute(new PcmlAttribute("type", "int", true));
                    pcmlAttributeList.addAttribute(new PcmlAttribute("length", "4", true));
                    pcmlAttributeList.addAttribute(new PcmlAttribute("precision", "32", true));
                    pcmlDocNode = new PcmlData(pcmlAttributeList);
                    if (bl) {
                        pcmlDocNode.setCondensedName(string3);
                    }
                } else if (string6.equals("shortParm") || string6.equals("arrayOfShortParm")) {
                    pcmlAttributeList.addAttribute(new PcmlAttribute("type", "int", true));
                    pcmlAttributeList.addAttribute(new PcmlAttribute("length", "2", true));
                    pcmlDocNode = new PcmlData(pcmlAttributeList);
                    if (bl) {
                        pcmlDocNode.setCondensedName(string3);
                    }
                } else if (string6.equals("unsignedShortParm") || string6.equals("arrayOfUnsignedShortParm")) {
                    pcmlAttributeList.addAttribute(new PcmlAttribute("type", "int", true));
                    pcmlAttributeList.addAttribute(new PcmlAttribute("length", "2", true));
                    pcmlAttributeList.addAttribute(new PcmlAttribute("precision", "16", true));
                    pcmlDocNode = new PcmlData(pcmlAttributeList);
                    if (bl) {
                        pcmlDocNode.setCondensedName(string3);
                    }
                } else if (string6.equals("longParm") || string6.equals("arrayOfLongParm")) {
                    pcmlAttributeList.addAttribute(new PcmlAttribute("type", "int", true));
                    pcmlAttributeList.addAttribute(new PcmlAttribute("length", "8", true));
                    pcmlDocNode = new PcmlData(pcmlAttributeList);
                    if (bl) {
                        pcmlDocNode.setCondensedName(string3);
                    }
                } else if (string6.equals("floatParm") || string6.equals("arrayOfFloatParm")) {
                    pcmlAttributeList.addAttribute(new PcmlAttribute("type", "float", true));
                    pcmlAttributeList.addAttribute(new PcmlAttribute("length", "4", true));
                    pcmlDocNode = new PcmlData(pcmlAttributeList);
                    if (bl) {
                        pcmlDocNode.setCondensedName(string3);
                    }
                } else if (string6.equals("doubleParm") || string6.equals("arrayOfDoubleParm")) {
                    pcmlAttributeList.addAttribute(new PcmlAttribute("type", "float", true));
                    pcmlAttributeList.addAttribute(new PcmlAttribute("length", "8", true));
                    pcmlDocNode = new PcmlData(pcmlAttributeList);
                    if (bl) {
                        pcmlDocNode.setCondensedName(string3);
                    }
                } else if (string6.equals("zonedDecimalParm") || string6.equals("arrayOfZonedDecimalParm")) {
                    pcmlAttributeList.addAttribute(new PcmlAttribute("type", "zoned", true));
                    pcmlDocNode = new PcmlData(pcmlAttributeList);
                    if (bl) {
                        pcmlDocNode.setCondensedName(string3);
                    }
                } else if (string6.equals("packedDecimalParm") || string6.equals("arrayOfPackedDecimalParm")) {
                    pcmlAttributeList.addAttribute(new PcmlAttribute("type", "packed", true));
                    pcmlDocNode = new PcmlData(pcmlAttributeList);
                    if (bl) {
                        pcmlDocNode.setCondensedName(string3);
                    }
                } else if (string6.equals("structParm")) {
                    pcmlAttributeList.addAttribute(new PcmlAttribute("type", "struct", true));
                    pcmlDocNode = new PcmlData(pcmlAttributeList);
                    if (bl) {
                        pcmlDocNode.setCondensedName(string3);
                    }
                } else {
                    pcmlDocNode = null;
                }
                if (pcmlDocNode != null) {
                    if (bl2) {
                        pcmlDocNode.setIsExtendedType(true);
                    }
                    if (this.m_rootNode == null) {
                        this.m_rootNode = (PcmlDocument)pcmlDocNode;
                        this.m_currentNode = pcmlDocNode;
                    } else {
                        if (this.m_currentNode != null) {
                            this.m_currentNode.addChild(pcmlDocNode);
                        }
                        this.m_currentNode = pcmlDocNode;
                    }
                }
            } else if (this.m_currentNode.getNodeType() == 3 && !string6.equals("struct_i") || this.m_currentNode.getNodeType() == 4 && this.m_currentNode.getAttributeValue("type").equals("struct") && !string6.equals("struct_i")) {
                String string10 = "";
                for (n2 = 0; n2 < ((AttributesImpl)object).getLength(); ++n2) {
                    if (!((AttributesImpl)object).getQName(n2).equals("name")) continue;
                    string10 = ((AttributesImpl)object).getValue(n2);
                }
                object2 = null;
                Enumeration enumeration = this.m_currentNode.getChildren();
                if (enumeration == null) {
                    return;
                }
                boolean bl4 = false;
                while (enumeration.hasMoreElements() && !bl4) {
                    object2 = (PcmlNode)enumeration.nextElement();
                    if (!((PcmlNode)object2).getName().equals(string10)) continue;
                    bl4 = true;
                }
                this.m_currentNode = (PcmlDocNode)object2;
            }
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.m_currentNode.getNodeType() == 4 && !this.m_currentNode.getAttributeValue("type").equals("struct")) {
            String string = new String(cArray, n, n2);
            if (!(this.lastQName.equals("arrayOfStringParm") || this.lastQName.equals("arrayOfIntParm") || this.lastQName.equals("arrayOfShortParm") || this.lastQName.equals("arrayOfLongParm") || this.lastQName.equals("arrayOfZonedDecimalParm") || this.lastQName.equals("arrayOfFloatParm") || this.lastQName.equals("arrayOfPackedDecimalParm") || this.lastQName.equals("arrayOfDoubleParm") || this.lastQName.equals("arrayOfStructParm") || this.lastQName.equals("arrayOfHexBinaryParm") || this.lastQName.equals("arrayOfUnsignedIntParm") || this.lastQName.equals("arrayOfUnsignedShortParm") || this.lastQName.equals("arrayOfStruct"))) {
                this.initValue = this.lastQName.equals("i") ? (string.indexOf(10) != -1 ? this.initValue + string.substring(0, string.indexOf(10)) : this.initValue + string) : this.initValue + string;
                try {
                    if (this.m_currentNode.getAttributeValue("type").equals("byte")) {
                        byte[] byArray = new byte[this.initValue.length() / 2];
                        byArray = BinaryConverter.stringToBytes(this.initValue);
                        ((PcmlData)this.m_currentNode).setValue(byArray, this.dimensions);
                    } else if (this.m_currentNode.getAttributeValue("type").equals("char") && this.m_currentNode.getAttributeValue("isEmptyString") != null && this.m_currentNode.getAttributeValue("isEmptyString").equals("true")) {
                        Trace.log(7, "Setting an empty string");
                        ((PcmlData)this.m_currentNode).setValue("", new PcmlDimensions(this.dimensions));
                    } else if (this.initValue.trim().length() > 0 || this.m_currentNode.getAttributeValue("type").equals("char")) {
                        ((PcmlData)this.m_currentNode).setInit(this.initValue);
                        ((PcmlData)this.m_currentNode).setValue(this.initValue, this.dimensions);
                    }
                    if (!this.firstInstance || this.lastQName.equals("i") || this.lastQName.equals("struct_i")) {
                        ((PcmlData)this.m_currentNode).setInit(null);
                    }
                }
                catch (Exception exception) {
                    Trace.log(7, "Exception when doing setValue");
                    Trace.log(7, "current node=" + this.m_currentNode.getQualifiedName());
                    Trace.log(7, "initial value=" + this.initValue + "..");
                    try {
                        int n3 = ((PcmlData)this.m_currentNode).getLength(this.dimensions);
                    }
                    catch (Exception exception2) {
                        Trace.log(7, "Exception due to length not being set when doing setValue");
                        Trace.log(7, "setValue not done but init attribute set");
                        return;
                    }
                    throw new SAXException(exception);
                }
            }
        }
    }

    public void endElement(String string, String string2, String string3) {
        String string4 = string3;
        boolean bl = false;
        if (!this.isXPCML) {
            this.m_currentNode = (PcmlDocNode)this.m_currentNode.getParent();
        }
        if (this.isXPCML) {
            if (!(this.xsdFileStream == null || string3.equals("program") || string3.equals("parameterList") || string3.equals("struct") || string3.equals("stringParm") || string3.equals("intParm") || string3.equals("shortParm") || string3.equals("longParm") || string3.equals("zonedDecimalParm") || string3.equals("floatParm") || string3.equals("packedDecimalParm") || string3.equals("doubleParm") || string3.equals("structParm") || string3.equals("hexBinaryParm") || string3.equals("unsignedIntParm") || string3.equals("unsignedShortParm") || string3.equals("arrayOfStringParm") || string3.equals("arrayOfIntParm") || string3.equals("arrayOfShortParm") || string3.equals("arrayOfLongParm") || string3.equals("arrayOfZonedDecimalParm") || string3.equals("arrayOfFloatParm") || string3.equals("arrayOfPackedDecimalParm") || string3.equals("arrayOfDoubleParm") || string3.equals("arrayOfStructParm") || string3.equals("arrayOfHexBinaryParm") || string3.equals("arrayOfUnsignedIntParm") || string3.equals("arrayOfUnsignedShortParm") || string3.equals("arrayOfStruct"))) {
                bl = true;
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.xmlOut.toByteArray());
                if (byteArrayInputStream == null) {
                    throw new MissingResourceException(SystemResourceFinder.format("PCML_DTD_NOT_FOUND", new Object[]{"xmlOut"}), "xmlOut", "");
                }
                LineNumberReader lineNumberReader = new LineNumberReader(new InputStreamReader(byteArrayInputStream));
                try {
                    String string5 = lineNumberReader.readLine();
                    boolean bl2 = false;
                    while (string5 != null && !bl2) {
                        if (string5.indexOf("name=\"" + string3 + "\"") != -1 && string5.indexOf("parm type=") != -1) {
                            if (string5.indexOf("parm type=string") != -1) {
                                string4 = "stringParm";
                                bl2 = true;
                            } else if (string5.indexOf("parm type=int") != -1) {
                                string4 = "intParm";
                                bl2 = true;
                            } else if (string5.indexOf("parm type=uint") != -1) {
                                string4 = "unsignedIntParm";
                                bl2 = true;
                            } else if (string5.indexOf("parm type=hexBinary") != -1) {
                                string4 = "hexBinaryParm";
                                bl2 = true;
                            } else if (string5.indexOf("parm type=short") != -1) {
                                string4 = "shortParm";
                                bl2 = true;
                            } else if (string5.indexOf("parm type=ushort") != -1) {
                                string4 = "unsignedShortParm";
                                bl2 = true;
                            } else if (string5.indexOf("parm type=long") != -1) {
                                string4 = "longParm";
                                bl2 = true;
                            } else if (string5.indexOf("parm type=float") != -1) {
                                string4 = "floatParm";
                                bl2 = true;
                            } else if (string5.indexOf("parm type=double") != -1) {
                                string4 = "doubleParm";
                                bl2 = true;
                            } else if (string5.indexOf("parm type=packed") != -1) {
                                string4 = "packedDecimalParm";
                                bl2 = true;
                            } else if (string5.indexOf("parm type=zoned") != -1) {
                                string4 = "zonedDecimalParm";
                                bl2 = true;
                            } else if (string5.indexOf("parm type=structParm") != -1) {
                                string4 = "structParm";
                                bl2 = true;
                            } else if (string5.indexOf("parm type=arrayOfString") != -1) {
                                string4 = "arrayOfStringParm";
                                bl2 = true;
                            } else if (string5.indexOf("parm type=arrayOfInt") != -1) {
                                string4 = "arrayOfIntParm";
                                bl2 = true;
                            } else if (string5.indexOf("parm type=arrayOfUInt") != -1) {
                                string4 = "arrayOfUnsignedIntParm";
                                bl2 = true;
                            } else if (string5.indexOf("parm type=arrayOfHexBinary") != -1) {
                                string4 = "arrayOfHexBinaryParm";
                                bl2 = true;
                            } else if (string5.indexOf("parm type=arrayOfShort") != -1) {
                                string4 = "arrayOfShortParm";
                                bl2 = true;
                            } else if (string5.indexOf("parm type=arrayOfUShort") != -1) {
                                string4 = "arrayOfUnsignedShortParm";
                                bl2 = true;
                            } else if (string5.indexOf("parm type=arrayOfLong") != -1) {
                                string4 = "arrayOfLongParm";
                                bl2 = true;
                            } else if (string5.indexOf("parm type=arrayOfFloat") != -1) {
                                string4 = "arrayOfFloatParm";
                                bl2 = true;
                            } else if (string5.indexOf("parm type=arrayOfDouble") != -1) {
                                string4 = "arrayOfDoubleParm";
                                bl2 = true;
                            } else if (string5.indexOf("parm type=arrayOfPacked") != -1) {
                                string4 = "arrayOfPackedDecimalParm";
                                bl2 = true;
                            } else if (string5.indexOf("parm type=arrayOfZoned") != -1) {
                                string4 = "arrayOfZonedDecimalParm";
                                bl2 = true;
                            } else if (string5.indexOf("parm type=arrayOfStructParm") != -1) {
                                string4 = "arrayOfStructParm";
                                bl2 = true;
                            } else if (string5.indexOf("parm type=structArray") != -1) {
                                string4 = "arrayOfStruct";
                                bl2 = true;
                            }
                        }
                        string5 = lineNumberReader.readLine();
                    }
                }
                catch (IOException iOException) {
                    Trace.log(7, "Error reading xsd stream in endElement");
                }
            }
            if (!(string4.equals("parameterList") || string4.equals("i") || string4.equals("struct_i"))) {
                this.m_currentNode = (PcmlDocNode)this.m_currentNode.getParent();
            }
            if (string4.equals("arrayOfStructParm") || string4.equals("arrayOfStringParm") || string4.equals("arrayOfIntParm") || string4.equals("arrayOfUnsignedIntParm") | string4.equals("arrayOfShortParm") || string4.equals("arrayOfUnsignedShortParm") || string4.equals("arrayOfLongParm") || string4.equals("arrayOfFloatParm") || string4.equals("arrayOfDoubleParm") || string4.equals("arrayOfHexBinaryParm") || string4.equals("arrayOfZonedDecimalParm") || string4.equals("arrayOfPackedDecimalParm") || string4.equals("arrayOfStruct")) {
                this.dimensions.set(this.curDim, 0);
                --this.curDim;
            }
        }
    }

    boolean inTree(String string, AttributesImpl attributesImpl) {
        boolean bl = false;
        String string2 = "";
        for (int i = 0; i < attributesImpl.getLength(); ++i) {
            if (!attributesImpl.getQName(i).equals("name")) continue;
            string2 = attributesImpl.getValue(i);
        }
        PcmlNode pcmlNode = null;
        Enumeration enumeration = this.m_currentNode.getChildren();
        if (enumeration != null) {
            while (enumeration.hasMoreElements() && !bl) {
                pcmlNode = (PcmlNode)enumeration.nextElement();
                if (!pcmlNode.getName().equals(string2) || string2 == "") continue;
                bl = true;
            }
        }
        return bl;
    }

    public void warning(SAXParseException sAXParseException) throws SAXException {
        Trace.log(7, "[Warning]: " + sAXParseException.getMessage());
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        Trace.log(7, "[Error]: " + sAXParseException.getMessage());
    }
}

