/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.Trace;

public class PanelGroupHelpIdentifier {
    private static final String copyright = "Copyright (C) 1997-2002 International Business Machines Corporation and others.";
    public static final int STATUS_NAME_NOT_CORRECT = 0;
    public static final int STATUS_FOUND = 1;
    public static final int STATUS_OBJECT_ACCESS_FAILURE = 2;
    public static final int STATUS_UNKNOWN = -1;
    private String helpID_;
    private String path_;
    private String found_;
    private String anchor_;

    PanelGroupHelpIdentifier(String string, String string2, String string3, String string4, String string5, String string6) {
        this.helpID_ = string;
        if (!string4.equalsIgnoreCase("PNLGRP")) {
            if (Trace.isTraceOn()) {
                Trace.log(2, "Panel group help identifier constructed with wrong object type: '" + string4 + "'");
            }
            throw new ExtendedIllegalArgumentException("type(" + string4 + ")", 2);
        }
        if (string2.length() == 0 || string3.length() == 0) {
            this.path_ = "";
            if (Trace.isTraceOn()) {
                Trace.log(4, "Panel group help identifier not fully specified: object = '" + string2 + "' and library = '" + string3 + "'");
            }
        } else {
            this.path_ = QSYSObjectPathName.toPath(string3, string2, string4);
        }
        this.found_ = string5;
        this.anchor_ = string6;
    }

    public String getName() {
        return this.helpID_;
    }

    public String getPath() {
        return this.path_;
    }

    public int getStatus() {
        if (this.found_.equals("0")) {
            return 0;
        }
        if (this.found_.equals("1")) {
            return 1;
        }
        if (this.found_.equals("2")) {
            return 2;
        }
        return -1;
    }

    public String getAnchor() {
        return this.anchor_;
    }

    public String toString() {
        return super.toString() + "[" + this.getStatus() + "," + this.getName() + "]";
    }
}

