/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.AS400Text;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.PTF;
import com.ibm.as400.access.ProgramParameter;
import com.ibm.as400.access.ServiceProgramCall;
import com.ibm.as400.access.UserSpace;
import java.beans.PropertyVetoException;
import java.io.IOException;

public class PTFGroup {
    private static final String copyright = "Copyright (C) 1997-2003 International Business Machines Corporation and others.";
    static final String USER_SPACE_NAME = "JT4PTF    QTEMP     ";
    static final String USER_SPACE_PATH = "/QSYS.LIB/QTEMP.LIB/JT4PTF.USRSPC";
    private AS400 system_;
    private String PTFGroupName_;
    private boolean includeRelatedPTFGroups_ = false;
    private String relatedPTFGroupName_;
    private String PTFgroupDescription_;
    private int PTFGroupLevel_;
    private int PTFGroupStatus_;
    public static final int PTF_GROUP_STATUS_UNKNOWN = 0;
    public static final int PTF_GROUP_STATUS_NOT_APPLICABLE = 1;
    public static final int PTF_GROUP_STATUS_SUPPORTED_ONLY = 2;
    public static final int PTF_GROUP_STATUS_NOT_INSTALLED = 3;
    public static final int PTF_GROUP_STATUS_INSTALLED = 4;
    public static final int PTF_GROUP_STATUS_ERROR = 5;
    public static final int PTF_GROUP_STATUS_NOT_FOUND = 6;

    PTFGroup(AS400 aS400, String string) {
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        if (string == null) {
            throw new NullPointerException("ptfGroupName");
        }
        this.system_ = aS400;
        this.PTFGroupName_ = string.trim();
    }

    PTFGroup(AS400 aS400, String string, String string2, int n, int n2) {
        this(aS400, string);
        this.PTFGroupLevel_ = n;
        this.PTFgroupDescription_ = string2;
        this.PTFGroupStatus_ = n2;
    }

    public AS400 getSystem() {
        return this.system_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PTFGroup[] getRelatedPTFGroups() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        int n = 164;
        int n2 = this.system_.getCcsid();
        ConvTable convTable = ConvTable.getTable(n2, null);
        ProgramParameter[] programParameterArray = new ProgramParameter[5];
        programParameterArray[0] = new ProgramParameter(convTable.stringToByteArray(USER_SPACE_NAME));
        try {
            programParameterArray[0].setParameterType(2);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        byte[] byArray = new byte[69];
        AS400Text aS400Text = new AS400Text(60, n2, this.system_);
        AS400Text aS400Text2 = new AS400Text(1, n2, this.system_);
        BinaryConverter.intToByteArray(69, byArray, 0);
        aS400Text.toBytes(this.PTFGroupName_, byArray, 4);
        BinaryConverter.intToByteArray(n2, byArray, 64);
        byArray[68] = this.includeRelatedPTFGroups_ ? -15 : -16;
        programParameterArray[1] = new ProgramParameter(byArray);
        try {
            programParameterArray[1].setParameterType(2);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        programParameterArray[2] = new ProgramParameter(convTable.stringToByteArray("GRPR0500"));
        try {
            programParameterArray[2].setParameterType(2);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        programParameterArray[3] = new ProgramParameter(BinaryConverter.intToByteArray(n2));
        try {
            programParameterArray[3].setParameterType(2);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        programParameterArray[4] = new ProgramParameter(new byte[4]);
        try {
            programParameterArray[4].setParameterType(2);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        ServiceProgramCall serviceProgramCall = new ServiceProgramCall(this.system_, "/QSYS.LIB/QPZGROUP.SRVPGM", "QpzListPtfGroupDetails", 0, programParameterArray);
        byte[] byArray2 = null;
        String string = USER_SPACE_NAME;
        synchronized (USER_SPACE_NAME) {
            int n3;
            UserSpace userSpace = new UserSpace(this.system_, USER_SPACE_PATH);
            userSpace.setMustUseProgramCall(true);
            userSpace.setMustUseSockets(true);
            userSpace.create(262144, true, "", (byte)0, "User space for PTF Group", "*EXCLUDE");
            try {
                if (!serviceProgramCall.run()) {
                    throw new AS400Exception(serviceProgramCall.getMessageList());
                }
                n3 = userSpace.getLength();
                byArray2 = new byte[n3];
                userSpace.read(byArray2, 0);
            }
            finally {
                userSpace.close();
            }
            // ** MonitorExit[var10_15] (shouldn't be in output)
            int n4 = BinaryConverter.byteArrayToInt(byArray2, 124);
            int n5 = BinaryConverter.byteArrayToInt(byArray2, 132);
            n3 = BinaryConverter.byteArrayToInt(byArray2, 136);
            int n6 = BinaryConverter.byteArrayToInt(byArray2, 140);
            convTable = ConvTable.getTable(n6, null);
            PTFGroup[] pTFGroupArray = new PTFGroup[n5];
            int n7 = 0;
            for (int i = 0; i < n5; ++i) {
                n7 = n4 + i * n3;
                this.relatedPTFGroupName_ = convTable.byteArrayToString(byArray2, n7, 60);
                this.PTFgroupDescription_ = convTable.byteArrayToString(byArray2, n7 += 60, 100);
                this.PTFGroupLevel_ = BinaryConverter.byteArrayToInt(byArray2, n7 += 100);
                this.PTFGroupStatus_ = BinaryConverter.byteArrayToInt(byArray2, n7 += 4);
                n7 += 4;
                pTFGroupArray[i] = new PTFGroup(this.system_, this.relatedPTFGroupName_, this.PTFgroupDescription_, this.PTFGroupLevel_, this.PTFGroupStatus_);
            }
            return pTFGroupArray;
        }
    }

    public String getPTFGroupDescription() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return this.PTFgroupDescription_;
    }

    public String getPTFGroupName() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return this.PTFGroupName_;
    }

    public int getPTFGroupLevel() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return this.PTFGroupLevel_;
    }

    public int getPTFGroupStatus() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        return this.PTFGroupStatus_;
    }

    public void includeRelatedPTFGroups(boolean bl) {
        this.includeRelatedPTFGroups_ = bl;
    }

    public boolean areRelatedPTFGroupsIncluded() {
        return this.includeRelatedPTFGroups_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PTF[] getPTFs() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        int n = 73;
        int n2 = this.system_.getCcsid();
        ConvTable convTable = ConvTable.getTable(n2, null);
        ProgramParameter[] programParameterArray = new ProgramParameter[5];
        programParameterArray[0] = new ProgramParameter(convTable.stringToByteArray(USER_SPACE_NAME));
        try {
            programParameterArray[0].setParameterType(2);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        byte[] byArray = new byte[69];
        AS400Text aS400Text = new AS400Text(60, n2, this.system_);
        AS400Text aS400Text2 = new AS400Text(1, n2, this.system_);
        BinaryConverter.intToByteArray(69, byArray, 0);
        aS400Text.toBytes(this.PTFGroupName_, byArray, 4);
        BinaryConverter.intToByteArray(n2, byArray, 64);
        byArray[68] = this.includeRelatedPTFGroups_ ? -15 : -16;
        programParameterArray[1] = new ProgramParameter(byArray);
        try {
            programParameterArray[1].setParameterType(2);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        programParameterArray[2] = new ProgramParameter(convTable.stringToByteArray("GRPR0300"));
        try {
            programParameterArray[2].setParameterType(2);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        programParameterArray[3] = new ProgramParameter(BinaryConverter.intToByteArray(n2));
        try {
            programParameterArray[3].setParameterType(2);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        programParameterArray[4] = new ProgramParameter(new byte[4]);
        try {
            programParameterArray[4].setParameterType(2);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        ServiceProgramCall serviceProgramCall = new ServiceProgramCall(this.system_, "/QSYS.LIB/QPZGROUP.SRVPGM", "QpzListPtfGroupDetails", 0, programParameterArray);
        byte[] byArray2 = null;
        String string = USER_SPACE_NAME;
        synchronized (USER_SPACE_NAME) {
            int n3;
            UserSpace userSpace = new UserSpace(this.system_, USER_SPACE_PATH);
            userSpace.setMustUseProgramCall(true);
            userSpace.setMustUseSockets(true);
            userSpace.create(262144, true, "", (byte)0, "User space for PTF Group", "*EXCLUDE");
            try {
                if (!serviceProgramCall.run()) {
                    throw new AS400Exception(serviceProgramCall.getMessageList());
                }
                n3 = userSpace.getLength();
                byArray2 = new byte[n3];
                userSpace.read(byArray2, 0);
            }
            finally {
                userSpace.close();
            }
            // ** MonitorExit[var10_15] (shouldn't be in output)
            int n4 = BinaryConverter.byteArrayToInt(byArray2, 124);
            int n5 = BinaryConverter.byteArrayToInt(byArray2, 132);
            n3 = BinaryConverter.byteArrayToInt(byArray2, 136);
            int n6 = BinaryConverter.byteArrayToInt(byArray2, 140);
            convTable = ConvTable.getTable(n6, null);
            PTF[] pTFArray = new PTF[n5];
            int n7 = 0;
            for (int i = 0; i < n5; ++i) {
                n7 = n4 + i * n3;
                String string2 = convTable.byteArrayToString(byArray2, n7, 7);
                String string3 = convTable.byteArrayToString(byArray2, n7 += 7, 7);
                String string4 = convTable.byteArrayToString(byArray2, n7 += 7, 6);
                String string5 = convTable.byteArrayToString(byArray2, n7 += 6, 4);
                String string6 = convTable.byteArrayToString(byArray2, n7 += 4, 4);
                String string7 = convTable.byteArrayToString(byArray2, n7 += 4, 2);
                String string8 = convTable.byteArrayToString(byArray2, n7 += 2, 2);
                n7 += 2;
                String string9 = convTable.byteArrayToString(byArray2, n7++, 1);
                int n8 = byArray2[n7++] & 0xF;
                String string10 = convTable.byteArrayToString(byArray2, n7++, 1);
                String string11 = convTable.byteArrayToString(byArray2, n7++, 1);
                String string12 = convTable.byteArrayToString(byArray2, n7++, 1);
                String string13 = convTable.byteArrayToString(byArray2, n7++, 1);
                String string14 = convTable.byteArrayToString(byArray2, n7++, 1);
                String string15 = convTable.byteArrayToString(byArray2, n7, 10);
                String string16 = convTable.byteArrayToString(byArray2, n7 += 10, 10);
                String string17 = convTable.byteArrayToString(byArray2, n7 += 10, 7);
                String string18 = convTable.byteArrayToString(byArray2, n7 += 7, 7);
                n7 += 7;
                String string19 = convTable.byteArrayToString(byArray2, n7++, 1);
                pTFArray[i] = new PTF(this.system_, string2, string3, string4, string5, string6, string7, string8, string9, n8, string10, string11, string12, string13, string14, string15, string16, string17, string18, string19);
            }
            return pTFArray;
        }
    }
}

