/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.AS400Text;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.DirectoryEntry;
import com.ibm.as400.access.ErrorCompletingRequestException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.ObjectDoesNotExistException;
import com.ibm.as400.access.ProgramCall;
import com.ibm.as400.access.ProgramParameter;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;

public class DirectoryEntryList {
    private static final String copyright = "Copyright (C) 1997-2003 International Business Machines Corporation and others.";
    private static final ProgramParameter errorCode_ = new ProgramParameter(new byte[4]);
    private AS400 system_;
    private String keyValue_ = null;
    private final Hashtable selectionValues_ = new Hashtable();
    public static final String ADDRESS1 = "ADDR1";
    public static final String ADDRESS2 = "ADDR2";
    public static final String ADDRESS3 = "ADDR3";
    public static final String ADDRESS4 = "ADDR4";
    public static final String BUILDING = "BLDG";
    public static final String COMPANY = "CMPNY";
    public static final String DEPARTMENT = "DEPT";
    public static final String FAX = "FAXTELNBR";
    public static final String FIRST_NAME = "FSTNAM";
    public static final String FIRST_OR_PREFERRED_NAME = "FSTPREFNAM";
    public static final String FULL_NAME = "FULNAM";
    public static final String JOB_TITLE = "TITLE";
    public static final String LAST_NAME = "LSTNAM";
    public static final String LOCATION = "LOC";
    public static final String MIDDLE_NAME = "MIDNAM";
    public static final String NETWORK_USER_ID = "NETUSRID";
    public static final String OFFICE = "OFC";
    public static final String PREFERRED_NAME = "PREFNAM";
    public static final String SYSTEM_GROUP = "SYSGRP";
    public static final String SYSTEM_NAME = "SYSNAME";
    public static final String TELEPHONE1 = "TELNBR1";
    public static final String TELEPHONE2 = "TELNBR2";
    public static final String TEXT = "TEXT";
    public static final String USER_ADDRESS = "USRADDR";
    public static final String USER_DESCRIPTION = "USRD";
    public static final String USER_ID = "USRID";
    public static final String USER_PROFILE = "USER";

    public DirectoryEntryList(AS400 aS400) {
        if (aS400 == null) {
            throw new NullPointerException("system");
        }
        this.system_ = aS400;
    }

    public void addSelection(String string, String string2) {
        if (string == null) {
            throw new NullPointerException("selectionID");
        }
        if (string2 == null) {
            throw new NullPointerException("value");
        }
        if (this.selectionValues_.isEmpty()) {
            this.keyValue_ = string;
        }
        this.selectionValues_.put(string, string2);
    }

    public void clearSelection() {
        this.selectionValues_.clear();
        this.keyValue_ = null;
    }

    public DirectoryEntry[] getEntries() throws AS400Exception, AS400SecurityException, ErrorCompletingRequestException, InterruptedException, IOException, ObjectDoesNotExistException {
        AS400Text aS400Text;
        int n;
        Object object;
        Object object2;
        Object object3;
        if (this.system_ == null) {
            throw new ExtendedIllegalStateException("system", 4);
        }
        if (this.selectionValues_.isEmpty()) {
            this.addSelection(USER_PROFILE, "*");
        }
        ProgramParameter[] programParameterArray = new ProgramParameter[9];
        int n2 = 12753;
        int n3 = this.system_.getCcsid();
        ConvTable convTable = ConvTable.getTable(n3, null);
        AS400Text aS400Text2 = new AS400Text(10, n3);
        programParameterArray[0] = new ProgramParameter(n2);
        programParameterArray[1] = new ProgramParameter(BinaryConverter.intToByteArray(n2));
        programParameterArray[2] = new ProgramParameter(convTable.stringToByteArray("SRCV0100"));
        programParameterArray[3] = new ProgramParameter(aS400Text2.toBytes("*SEARCH"));
        programParameterArray[4] = new ProgramParameter(new byte[]{-16});
        int n4 = this.selectionValues_.size();
        Enumeration enumeration = this.selectionValues_.keys();
        int n5 = 0;
        while (enumeration.hasMoreElements()) {
            object3 = (String)enumeration.nextElement();
            String string = (String)this.selectionValues_.get(object3);
            n5 += string.length();
        }
        object3 = new byte[130 + n4 * 28 + n5];
        convTable.stringToByteArray("*   ", (byte[])object3, 12, 4);
        object3[16] = -15;
        object3[17] = -16;
        object3[18] = -15;
        object3[19] = -16;
        convTable.stringToByteArray("                ", (byte[])object3, 20, 16);
        convTable.stringToByteArray("SREQ0101", (byte[])object3, 36, 8);
        BinaryConverter.intToByteArray(130, (byte[])object3, 44);
        BinaryConverter.intToByteArray(n4, (byte[])object3, 48);
        convTable.stringToByteArray("SREQ0103", (byte[])object3, 52, 8);
        BinaryConverter.intToByteArray(100, (byte[])object3, 60);
        BinaryConverter.intToByteArray(3, (byte[])object3, 64);
        convTable.stringToByteArray("SRCV0101", (byte[])object3, 68, 8);
        BinaryConverter.intToByteArray(65535, (byte[])object3, 76);
        convTable.stringToByteArray("SRCV0112", (byte[])object3, 80, 8);
        convTable.stringToByteArray("        ", (byte[])object3, 88, 8);
        object3[96] = -16;
        convTable.stringToByteArray("   ", (byte[])object3, 97, 3);
        aS400Text2.toBytes("*SYSDIR", (byte[])object3, 100);
        aS400Text2.toBytes("*SMTP", (byte[])object3, 110);
        aS400Text2.toBytes("*ORNAME", (byte[])object3, 120);
        int n6 = 130;
        if (this.keyValue_ != null) {
            object2 = this.keyValue_;
            object = (String)this.selectionValues_.remove(object2);
            n = ((String)object).length();
            BinaryConverter.intToByteArray(28 + n, (byte[])object3, n6);
            object3[n6 + 4] = -15;
            aS400Text2.toBytes(object2, (byte[])object3, n6 + 5);
            convTable.stringToByteArray("*IBM   ", (byte[])object3, n6 + 15, 7);
            object3[n6 + 22] = 64;
            object3[n6 + 23] = 64;
            BinaryConverter.intToByteArray(n, (byte[])object3, n6 + 24);
            aS400Text = new AS400Text(n, n3);
            aS400Text.toBytes(object, (byte[])object3, n6 + 28);
            n6 += 28 + n;
        }
        enumeration = this.selectionValues_.keys();
        while (enumeration.hasMoreElements()) {
            object2 = (String)enumeration.nextElement();
            object = (String)this.selectionValues_.get(object2);
            n = ((String)object).length();
            BinaryConverter.intToByteArray(28 + n, (byte[])object3, n6);
            object3[n6 + 4] = -15;
            aS400Text2.toBytes(object2, (byte[])object3, n6 + 5);
            convTable.stringToByteArray("*IBM   ", (byte[])object3, n6 + 15, 7);
            object3[n6 + 22] = 64;
            object3[n6 + 23] = 64;
            BinaryConverter.intToByteArray(n, (byte[])object3, n6 + 24);
            aS400Text = new AS400Text(n, n3);
            aS400Text.toBytes(object, (byte[])object3, n6 + 28);
            n6 += 28 + n;
        }
        programParameterArray[5] = new ProgramParameter((byte[])object3);
        programParameterArray[6] = new ProgramParameter(BinaryConverter.intToByteArray(((Object)object3).length));
        programParameterArray[7] = new ProgramParameter(convTable.stringToByteArray("SREQ0100"));
        programParameterArray[8] = errorCode_;
        object2 = new ProgramCall(this.system_, "/QSYS.LIB/QOKSCHD.PGM", programParameterArray);
        if (!((ProgramCall)object2).run()) {
            throw new AS400Exception(((ProgramCall)object2).getMessageList());
        }
        object = programParameterArray[0].getOutputData();
        n = BinaryConverter.byteArrayToInt((byte[])object, 0);
        while (n2 - n <= 636) {
            n2 *= 2;
            try {
                programParameterArray[0].setOutputDataLength(n2);
                programParameterArray[1].setInputData(BinaryConverter.intToByteArray(n2));
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
            if (!((ProgramCall)object2).run()) {
                throw new AS400Exception(((ProgramCall)object2).getMessageList());
            }
            object = programParameterArray[0].getOutputData();
            n = BinaryConverter.byteArrayToInt((byte[])object, 0);
        }
        int n7 = BinaryConverter.byteArrayToInt((byte[])object, 4);
        int n8 = BinaryConverter.byteArrayToInt((byte[])object, 8);
        int n9 = BinaryConverter.byteArrayToInt((byte[])object, 12);
        Object object4 = object[16];
        String string = convTable.byteArrayToString((byte[])object, 17, 16);
        DirectoryEntry[] directoryEntryArray = new DirectoryEntry[n9];
        n6 = n8;
        for (int i = 0; i < n9; ++i) {
            int n10 = BinaryConverter.byteArrayToInt((byte[])object, n6);
            int n11 = BinaryConverter.byteArrayToInt((byte[])object, n6 + 4);
            n6 += 8;
            String[] stringArray = new String[n11];
            for (int j = 0; j < n11; ++j) {
                int n12 = BinaryConverter.byteArrayToInt((byte[])object, n6);
                int n13 = BinaryConverter.byteArrayToInt((byte[])object, n6 + 4);
                int n14 = BinaryConverter.byteArrayToInt((byte[])object, n6 + 8);
                stringArray[j] = convTable.byteArrayToString((byte[])object, n6 + 12, n14);
                n6 += 12 + n14;
            }
            directoryEntryArray[i] = new DirectoryEntry(this.system_, stringArray);
        }
        return directoryEntryArray;
    }

    public String getKey() {
        return this.keyValue_;
    }

    public AS400 getSystem() {
        return this.system_;
    }

    public void setKey(String string) {
        this.keyValue_ = string;
    }

    public void setSystem(AS400 aS400) {
        this.system_ = aS400;
    }
}

