/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cdf.dd.cdf;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import pt.webdetails.cdf.dd.CdeEngine;
import pt.webdetails.cdf.dd.Messages;
import pt.webdetails.cdf.dd.structure.DashboardStructureException;
import pt.webdetails.cdf.dd.util.CdeEnvironment;
import pt.webdetails.cdf.dd.util.GenericBasicFileFilter;
import pt.webdetails.cdf.dd.util.JsonUtils;
import pt.webdetails.cdf.dd.util.Utils;
import pt.webdetails.cpf.repository.api.IBasicFile;
import pt.webdetails.cpf.repository.api.IBasicFileFilter;
import pt.webdetails.cpf.repository.api.IRWAccess;
import pt.webdetails.cpf.repository.api.IReadAccess;
import pt.webdetails.cpf.utils.CharsetHelper;

public class CdfTemplates {
    private static String SYSTEM_CDF_DD_TEMPLATES = "/resources/templates";
    protected String resourceUrl;
    private static String REPOSITORY_CDF_DD_TEMPLATES_CUSTOM = "templates";
    private final String DEFAULT_RENDERER_TYPE = "bootstrap";
    private static Log logger = LogFactory.getLog(CdfTemplates.class);

    public CdfTemplates(String getResourceEndpoint) {
        this.resourceUrl = this.getResourceUrl(getResourceEndpoint);
    }

    public void save(String file, String structure) throws DashboardStructureException, IOException {
        this.save(file, structure, "bootstrap");
    }

    public void save(String file, String structure, String rendererType) throws DashboardStructureException, IOException {
        if (StringUtils.isEmpty((String)rendererType)) {
            rendererType = "bootstrap";
        }
        logger.info((Object)("Saving File:" + file));
        IRWAccess access = CdeEnvironment.getPluginRepositoryWriter();
        String templatesFolder = Utils.joinPath((String[])new String[]{REPOSITORY_CDF_DD_TEMPLATES_CUSTOM, rendererType});
        if (!access.fileExists(templatesFolder)) {
            access.createFolder(templatesFolder, false);
        }
        byte[] fileData = structure.getBytes(CharsetHelper.getEncoding());
        if (!access.saveFile(Utils.joinPath((String[])new String[]{templatesFolder, file}), (InputStream)new ByteArrayInputStream(fileData))) {
            throw new DashboardStructureException(Messages.getString((String)"DashboardStructure.ERROR_006_SAVE_FILE_ADD_FAIL_EXCEPTION"));
        }
    }

    public Object load() {
        return this.load("bootstrap");
    }

    public Object load(String rendererType) {
        if (StringUtils.isEmpty((String)rendererType)) {
            rendererType = "bootstrap";
        }
        Object result = new JSONArray();
        try {
            GenericBasicFileFilter jsonFilter = new GenericBasicFileFilter(null, ".cdfde");
            List defaultTemplatesList = CdeEnvironment.getPluginSystemReader((String)Utils.joinPath((String[])new String[]{SYSTEM_CDF_DD_TEMPLATES, rendererType})).listFiles(null, (IBasicFileFilter)jsonFilter, -1);
            if (defaultTemplatesList != null) {
                this.loadFiles(defaultTemplatesList.toArray(new IBasicFile[0]), (JSONArray)result, "default", rendererType);
            } else {
                result = Messages.getString((String)"CdfTemplates.ERROR_002_LOADING_TEMPLATES_EXCEPTION");
            }
            List customTemplatesList = CdeEnvironment.getPluginRepositoryReader((String)Utils.joinPath((String[])new String[]{REPOSITORY_CDF_DD_TEMPLATES_CUSTOM, rendererType})).listFiles(null, (IBasicFileFilter)jsonFilter, -1);
            if (customTemplatesList != null) {
                this.loadFiles(customTemplatesList.toArray(new IBasicFile[0]), (JSONArray)result, "custom", rendererType);
            }
        }
        catch (IOException e) {
            logger.error((Object)e);
            result = Messages.getString((String)"CdfTemplates.ERROR_002_LOADING_EXCEPTION");
        }
        catch (JSONException e) {
            logger.error((Object)e);
            result = Messages.getString((String)"CdfTemplates.ERROR_002_LOADING_EXCEPTION");
        }
        return result;
    }

    private void loadFiles(IBasicFile[] jsonFiles, JSONArray result, String type, String rendererType) throws IOException, JSONException {
        Arrays.sort(jsonFiles, new Comparator<IBasicFile>(){

            @Override
            public int compare(IBasicFile file1, IBasicFile file2) {
                if (file1 == null && file2 == null) {
                    return 0;
                }
                return file1.getFullPath().toLowerCase().compareTo(file2.getFullPath().toLowerCase());
            }
        });
        IReadAccess access = CdeEnvironment.getPluginSystemReader((String)Utils.joinPath((String[])new String[]{SYSTEM_CDF_DD_TEMPLATES, rendererType}));
        for (int i = 0; i < jsonFiles.length; ++i) {
            JSONObject template = new JSONObject();
            String imgResourcePath = this.resourceUrl + "unknown.png";
            if (access.fileExists(jsonFiles[i].getName().replace(".cdfde", ".png"))) {
                imgResourcePath = this.resourceUrl + Utils.joinPath((String[])new String[]{rendererType, jsonFiles[i].getName().replace(".cdfde", ".png")});
            }
            template.put("img", (Object)imgResourcePath);
            template.put("type", (Object)type);
            template.put("structure", (Object)this.getStructure(jsonFiles[i]));
            result.put((Object)template);
        }
    }

    protected String getResourceUrl(String resourceEndpoint) {
        return CdeEngine.getInstance().getEnvironment().getApplicationBaseContentUrl() + resourceEndpoint + SYSTEM_CDF_DD_TEMPLATES + "/";
    }

    protected JSONObject getStructure(IBasicFile file) throws IOException, JSONException {
        return JsonUtils.readJsonFromInputStream((InputStream)file.getContents());
    }
}

