/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cdf.dd.api;

import com.fasterxml.jackson.core.util.DefaultIndenter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import org.pentaho.platform.util.StringUtil;
import org.pentaho.platform.web.http.api.resources.utils.EscapeUtils;
import pt.webdetails.cdf.dd.CdeConstants;
import pt.webdetails.cdf.dd.CdeEngine;
import pt.webdetails.cdf.dd.util.CorsUtil;
import pt.webdetails.cpf.resources.IResourceLoader;

public class XSSHelper {
    private static XSSHelper instance = new XSSHelper();
    private static DefaultPrettyPrinter prettyPrinter;

    public static XSSHelper getInstance() {
        return instance;
    }

    public String escape(String userInput) {
        boolean isInputEmpty = StringUtil.isEmpty((String)userInput);
        boolean isXssEscapeDisabled = "false".equals(this.getXssEscapingPluginSetting());
        if (isInputEmpty || isXssEscapeDisabled) {
            return userInput;
        }
        return EscapeUtils.escapeJsonOrRaw((String)userInput, (DefaultPrettyPrinter)this.getPrettyPrinter());
    }

    private DefaultPrettyPrinter getPrettyPrinter() {
        if (prettyPrinter != null) {
            return prettyPrinter;
        }
        DefaultPrettyPrinter printer = new DefaultPrettyPrinter();
        DefaultIndenter indent = new DefaultIndenter("  ", CdeConstants.Writer.NEWLINE);
        prettyPrinter = printer.withObjectIndenter((DefaultPrettyPrinter.Indenter)indent).withArrayIndenter((DefaultPrettyPrinter.Indenter)indent);
        return prettyPrinter;
    }

    static void setInstance(XSSHelper newInstance) {
        instance = newInstance;
    }

    String getXssEscapingPluginSetting() {
        IResourceLoader cdeResourceLoader = CdeEngine.getInstance().getEnvironment().getResourceLoader();
        return cdeResourceLoader.getPluginSetting(CorsUtil.class, "settings/parameter-xss-escaping");
    }
}

