/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cdf.dd.api;

import java.util.Map;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONException;
import org.pentaho.platform.api.engine.ILogger;
import org.pentaho.platform.api.engine.IParameterProvider;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.engine.core.solution.SimpleParameterProvider;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.util.logging.SimpleLogger;
import pt.webdetails.cdf.dd.CdeEngine;
import pt.webdetails.cdf.dd.DashboardManager;
import pt.webdetails.cdf.dd.ICdeEnvironment;
import pt.webdetails.cdf.dd.InterPluginBroker;
import pt.webdetails.cdf.dd.Messages;
import pt.webdetails.cdf.dd.MetaModelManager;
import pt.webdetails.cdf.dd.api.XSSHelper;
import pt.webdetails.cdf.dd.editor.DashboardEditor;
import pt.webdetails.cdf.dd.model.core.writer.ThingWriteException;
import pt.webdetails.cdf.dd.model.inst.writer.cdfrunjs.dashboard.CdfRunJsDashboardWriteOptions;
import pt.webdetails.cdf.dd.model.inst.writer.cdfrunjs.dashboard.CdfRunJsDashboardWriteResult;
import pt.webdetails.cdf.dd.structure.DashboardWcdfDescriptor;
import pt.webdetails.cdf.dd.util.CdeEnvironment;
import pt.webdetails.cdf.dd.util.CorsUtil;
import pt.webdetails.cdf.dd.util.JsonUtils;
import pt.webdetails.cdf.dd.util.Utils;
import pt.webdetails.cpf.Util;
import pt.webdetails.cpf.audit.CpfAuditHelper;
import pt.webdetails.cpf.localization.MessageBundlesHelper;
import pt.webdetails.cpf.repository.api.IReadAccess;
import pt.webdetails.cpf.utils.CharsetHelper;

@Path(value="pentaho-cdf-dd/api/renderer")
public class RenderApi {
    private static final Log logger = LogFactory.getLog(RenderApi.class);
    protected ICdeEnvironment privateEnviroment;
    private DashboardManager dashboardManager;

    @GET
    @Path(value="/getComponentDefinitions")
    @Produces(value={"text/javascript"})
    public String getComponentDefinitions(@QueryParam(value="supports") @DefaultValue(value="legacy") String supports, @Context HttpServletResponse response) {
        if (!StringUtils.isEmpty((String)supports) && supports.equals("amd")) {
            return MetaModelManager.getInstance().getAmdJsDefinition();
        }
        return MetaModelManager.getInstance().getJsDefinition();
    }

    @GET
    @Path(value="/getContent")
    @Produces(value={"text/javascript"})
    public String getContent(@QueryParam(value="solution") @DefaultValue(value="") String solution, @QueryParam(value="path") @DefaultValue(value="") String path, @QueryParam(value="file") @DefaultValue(value="") String file, @QueryParam(value="inferScheme") @DefaultValue(value="false") boolean inferScheme, @QueryParam(value="root") @DefaultValue(value="") String root, @QueryParam(value="absolute") @DefaultValue(value="false") boolean absolute, @QueryParam(value="bypassCache") @DefaultValue(value="false") boolean bypassCache, @QueryParam(value="debug") @DefaultValue(value="false") boolean debug, @QueryParam(value="scheme") @DefaultValue(value="") String scheme, @Context HttpServletRequest request, @Context HttpServletResponse response) throws ThingWriteException {
        solution = this.decodeAndEscape(solution);
        path = this.decodeAndEscape(path);
        file = this.decodeAndEscape(file);
        scheme = this.decodeAndEscape(scheme);
        String schemeToUse = "";
        if (!inferScheme) {
            schemeToUse = StringUtils.isEmpty((String)scheme) ? request.getScheme() : scheme;
        }
        String filePath = this.getWcdfRelativePath(solution, path, file);
        CdfRunJsDashboardWriteResult dashboardWrite = this.loadDashboard(filePath, schemeToUse, root, absolute, bypassCache, debug, null);
        return dashboardWrite.getContent();
    }

    @GET
    @Path(value="/getHeaders")
    @Produces(value={"text/plain"})
    public String getHeaders(@QueryParam(value="solution") @DefaultValue(value="") String solution, @QueryParam(value="path") @DefaultValue(value="") String path, @QueryParam(value="file") @DefaultValue(value="") String file, @QueryParam(value="inferScheme") @DefaultValue(value="false") boolean inferScheme, @QueryParam(value="root") @DefaultValue(value="") String root, @QueryParam(value="absolute") @DefaultValue(value="true") boolean absolute, @QueryParam(value="bypassCache") @DefaultValue(value="false") boolean bypassCache, @QueryParam(value="debug") @DefaultValue(value="false") boolean debug, @QueryParam(value="scheme") @DefaultValue(value="") String scheme, @Context HttpServletRequest request, @Context HttpServletResponse response) throws ThingWriteException {
        solution = this.decodeAndEscape(solution);
        path = this.decodeAndEscape(path);
        file = this.decodeAndEscape(file);
        scheme = this.decodeAndEscape(scheme);
        String schemeToUse = "";
        if (!inferScheme) {
            schemeToUse = StringUtils.isEmpty((String)scheme) ? request.getScheme() : scheme;
        }
        String filePath = this.getWcdfRelativePath(solution, path, file);
        CdfRunJsDashboardWriteResult dashboardWrite = this.loadDashboard(filePath, schemeToUse, root, absolute, bypassCache, debug, null);
        return dashboardWrite.getHeader();
    }

    @GET
    @Path(value="/render")
    @Produces(value={"text/html"})
    public String render(@QueryParam(value="solution") @DefaultValue(value="") String solution, @QueryParam(value="path") @DefaultValue(value="") String path, @QueryParam(value="file") @DefaultValue(value="") String file, @QueryParam(value="inferScheme") @DefaultValue(value="false") boolean inferScheme, @QueryParam(value="root") @DefaultValue(value="") String root, @QueryParam(value="absolute") @DefaultValue(value="true") boolean absolute, @QueryParam(value="bypassCache") @DefaultValue(value="false") boolean bypassCache, @QueryParam(value="debug") @DefaultValue(value="false") boolean debug, @QueryParam(value="scheme") @DefaultValue(value="") String scheme, @QueryParam(value="view") @DefaultValue(value="") String view, @QueryParam(value="style") @DefaultValue(value="") String style, @Context HttpServletRequest request) {
        String filePath;
        solution = this.decodeAndEscape(solution);
        path = this.decodeAndEscape(path);
        file = this.decodeAndEscape(file);
        scheme = this.decodeAndEscape(scheme);
        view = this.decodeAndEscape(view);
        style = this.decodeAndEscape(style);
        String schemeToUse = "";
        if (!inferScheme) {
            String string = schemeToUse = StringUtils.isEmpty((String)scheme) ? request.getScheme() : scheme;
        }
        if (StringUtils.isEmpty((String)(filePath = this.getWcdfRelativePath(solution, path, file)))) {
            return "No path provided.";
        }
        IReadAccess readAccess = Utils.getSystemOrUserReadAccess((String)filePath);
        if (readAccess == null) {
            return Messages.getString((String)"XmlStructure.ERROR_011_READ_WRITE_ACCESS_EXCEPTION");
        }
        long start = System.currentTimeMillis();
        ILogger iLogger = this.getAuditLogger();
        IParameterProvider requestParams = this.getParameterProvider(request.getParameterMap());
        UUID uuid = CpfAuditHelper.startAudit((String)this.getPluginName(), (String)filePath, (String)this.getObjectName(), (IPentahoSession)this.getPentahoSession(), (ILogger)iLogger, (IParameterProvider)requestParams);
        try {
            logger.info((Object)"[Timing] CDE Starting Dashboard Rendering");
            CdfRunJsDashboardWriteResult dashboard = this.loadDashboard(filePath, schemeToUse, root, absolute, bypassCache, debug, style);
            DashboardWcdfDescriptor dashboardWcdf = DashboardWcdfDescriptor.load((String)filePath);
            String context = dashboardWcdf.isRequire() ? this.getCdfRequireContext(filePath, requestParams) : this.getCdfContext(filePath, "", view, requestParams);
            String result = dashboard.render(context, this.getCdfRequireConfig(filePath, requestParams));
            if (!StringUtils.isEmpty((String)result) && !dashboardWcdf.isRequire()) {
                String msgDir = FilenameUtils.getPath((String)FilenameUtils.separatorsToUnix((String)filePath));
                msgDir = msgDir.startsWith(Util.SEPARATOR) ? msgDir : Util.SEPARATOR + msgDir;
                result = new MessageBundlesHelper(msgDir, Utils.getAppropriateReadAccess((String)msgDir), CdeEnvironment.getPluginSystemWriter(), this.getEnv().getLocale(), this.getEnv().getExtApi().getPluginStaticBaseUrl()).replaceParameters(result, null);
            }
            logger.info((Object)("[Timing] CDE Finished Dashboard Rendering: " + Utils.ellapsedSeconds((long)start) + "s"));
            long end = System.currentTimeMillis();
            CpfAuditHelper.endAudit((String)this.getPluginName(), (String)filePath, (String)this.getObjectName(), (IPentahoSession)this.getPentahoSession(), (ILogger)iLogger, (long)start, (UUID)uuid, (long)end);
            return result;
        }
        catch (Exception ex) {
            String msg = "Could not load dashboard: " + ex.getMessage();
            logger.error((Object)msg, (Throwable)ex);
            long end = System.currentTimeMillis();
            CpfAuditHelper.endAudit((String)this.getPluginName(), (String)filePath, (String)this.getObjectName(), (IPentahoSession)this.getPentahoSession(), (ILogger)iLogger, (long)start, (UUID)uuid, (long)end);
            return msg;
        }
    }

    @GET
    @Path(value="/getDashboard")
    @Produces(value={"text/html"})
    public String getDashboard(@QueryParam(value="path") @DefaultValue(value="") String path, @QueryParam(value="inferScheme") @DefaultValue(value="false") boolean inferScheme, @QueryParam(value="root") @DefaultValue(value="") String root, @QueryParam(value="absolute") @DefaultValue(value="true") boolean absolute, @QueryParam(value="bypassCache") @DefaultValue(value="false") boolean bypassCache, @QueryParam(value="debug") @DefaultValue(value="false") boolean debug, @QueryParam(value="scheme") @DefaultValue(value="") String scheme, @QueryParam(value="view") @DefaultValue(value="") String view, @QueryParam(value="style") @DefaultValue(value="") String style, @QueryParam(value="alias") @DefaultValue(value="") String alias, @Context HttpServletRequest request) {
        path = this.decodeAndEscape(path);
        scheme = this.decodeAndEscape(scheme);
        style = this.decodeAndEscape(style);
        alias = this.decodeAndEscape(alias);
        String schemeToUse = !inferScheme ? (StringUtils.isEmpty((String)scheme) ? request.getScheme() : scheme) : "";
        if (StringUtils.isEmpty((String)path)) {
            logger.warn((Object)"No path provided.");
            return "No path provided.";
        }
        IReadAccess readAccess = Utils.getSystemOrUserReadAccess((String)path);
        if (readAccess == null) {
            logger.warn((Object)"Access Denied or File Not Found.");
            return "Access Denied or File Not Found.";
        }
        long start = System.currentTimeMillis();
        ILogger iLogger = this.getAuditLogger();
        IParameterProvider requestParams = this.getParameterProvider(request.getParameterMap());
        UUID uuid = CpfAuditHelper.startAudit((String)this.getPluginName(), (String)path, (String)this.getObjectName(), (IPentahoSession)this.getPentahoSession(), (ILogger)iLogger, (IParameterProvider)requestParams);
        try {
            logger.info((Object)"[Timing] CDE Starting To Generate Dashboard AMD Module");
            String config = this.getCdfRequireConfig(path, requestParams);
            CdfRunJsDashboardWriteResult dashboard = this.getDashboardModule(path, schemeToUse, root, absolute, bypassCache, debug, style, alias);
            logger.info((Object)("[Timing] CDE Finished Generating Dashboard AMD Module: " + Utils.ellapsedSeconds((long)start) + "s"));
            long end = System.currentTimeMillis();
            CpfAuditHelper.endAudit((String)this.getPluginName(), (String)path, (String)this.getObjectName(), (IPentahoSession)this.getPentahoSession(), (ILogger)iLogger, (long)start, (UUID)uuid, (long)end);
            return dashboard.getContent(config);
        }
        catch (Exception ex) {
            String msg = "Could not load dashboard: " + ex.getMessage();
            logger.error((Object)msg, (Throwable)ex);
            long end = System.currentTimeMillis();
            CpfAuditHelper.endAudit((String)this.getPluginName(), (String)path, (String)this.getObjectName(), (IPentahoSession)this.getPentahoSession(), (ILogger)iLogger, (long)start, (UUID)uuid, (long)end);
            return msg;
        }
    }

    @GET
    @Path(value="/getDashboardParameters")
    @Produces(value={"application/json"})
    public String getDashboardParameters(@QueryParam(value="path") @DefaultValue(value="") String path, @QueryParam(value="bypassCache") @DefaultValue(value="false") boolean bypassCache, @QueryParam(value="all") @DefaultValue(value="false") boolean all, @Context HttpServletRequest servletRequest, @Context HttpServletResponse servletResponse) {
        path = this.decodeAndEscape(path);
        servletResponse.setContentType("application/json");
        servletResponse.setCharacterEncoding(CharsetHelper.getEncoding());
        this.setCorsHeaders(servletRequest, servletResponse);
        if (StringUtils.isEmpty((String)path)) {
            logger.warn((Object)"No path provided.");
            return "No path provided.";
        }
        if (!this.hasSystemOrUserReadAccess(path)) {
            logger.warn((Object)"Access Denied or File Not Found.");
            return "Access Denied or File Not Found.";
        }
        try {
            return this.getDashboardManager().getDashboardParameters(path, bypassCache, all);
        }
        catch (Exception ex) {
            String msg = "Could not load dashboard parameters: " + ex.getMessage();
            logger.error((Object)msg, (Throwable)ex);
            return msg;
        }
    }

    @GET
    @Path(value="/getDashboardDatasources")
    @Produces(value={"application/json"})
    public String getDashboardDatasources(@QueryParam(value="path") @DefaultValue(value="") String path, @QueryParam(value="bypassCache") @DefaultValue(value="false") boolean bypassCache, @Context HttpServletRequest servletRequest, @Context HttpServletResponse servletResponse) throws JSONException {
        path = this.decodeAndEscape(path);
        servletResponse.setContentType("application/json");
        servletResponse.setCharacterEncoding(CharsetHelper.getEncoding());
        this.setCorsHeaders(servletRequest, servletResponse);
        if (StringUtils.isEmpty((String)path)) {
            logger.warn((Object)"No path provided.");
            return JsonUtils.getJsonResult((boolean)false, (Object)"No path provided");
        }
        if (!this.hasSystemOrUserReadAccess(path)) {
            logger.warn((Object)"Access Denied or File Not Found.");
            return JsonUtils.getJsonResult((boolean)false, (Object)"Access Denied or File Not Found.");
        }
        try {
            return this.getDashboardManager().getDashboardDataSources(path, bypassCache);
        }
        catch (Exception ex) {
            String msg = "Could not load dashboard datasources: " + ex.getMessage();
            logger.error((Object)msg, (Throwable)ex);
            return JsonUtils.getJsonResult((boolean)false, (Object)msg);
        }
    }

    @GET
    @Path(value="/edit")
    @Produces(value={"text/html"})
    public String edit(@QueryParam(value="solution") @DefaultValue(value="") String solution, @QueryParam(value="path") @DefaultValue(value="") String path, @QueryParam(value="file") @DefaultValue(value="") String file, @QueryParam(value="debug") @DefaultValue(value="false") boolean debug, @QueryParam(value="isDefault") @DefaultValue(value="false") boolean isDefault, @Context HttpServletRequest request, @Context HttpServletResponse response) throws Exception {
        solution = this.decodeAndEscape(solution);
        path = this.decodeAndEscape(path);
        file = this.decodeAndEscape(file);
        String wcdfPath = this.getWcdfRelativePath(solution, path, file);
        if (!CdeEnvironment.canCreateContent()) {
            return "This functionality is limited to users with permission 'Create Content'";
        }
        if (Utils.getSystemOrUserRWAccess((String)wcdfPath) == null) {
            return "Access Denied or file not found - " + wcdfPath;
        }
        DashboardWcdfDescriptor descriptor = DashboardWcdfDescriptor.load((String)wcdfPath);
        return this.getEditor(wcdfPath, debug, request.getScheme(), isDefault, response, descriptor.isRequire());
    }

    @GET
    @Path(value="/new")
    @Produces(value={"text/html"})
    public String newDashboard(@QueryParam(value="path") @DefaultValue(value="") String path, @QueryParam(value="debug") @DefaultValue(value="false") boolean debug, @QueryParam(value="isDefault") @DefaultValue(value="false") boolean isDefault, @Context HttpServletRequest request, @Context HttpServletResponse response) throws Exception {
        path = this.decodeAndEscape(path);
        if (!CdeEnvironment.canCreateContent()) {
            return "This functionality is limited to users with permission 'Create Content'";
        }
        return this.getEditor(path, debug, request.getScheme(), isDefault, response, true);
    }

    @GET
    @Path(value="/listRenderers")
    @Produces(value={"application/json"})
    public String listRenderers() {
        return "{\"result\": [\"" + DashboardWcdfDescriptor.DashboardRendererType.BLUEPRINT.getType() + "\",\"" + DashboardWcdfDescriptor.DashboardRendererType.MOBILE.getType() + "\",\"" + DashboardWcdfDescriptor.DashboardRendererType.BOOTSTRAP.getType() + "\"]}";
    }

    @GET
    @Path(value="/refresh")
    @Produces(value={"text/plain"})
    public String refresh(@Context HttpServletResponse servletResponse) throws Exception {
        String msg = "Refreshed CDE Successfully";
        try {
            this.getDashboardManager().refreshAll();
        }
        catch (Exception re) {
            msg = "Method refresh failed while trying to execute.";
            logger.error((Object)msg, (Throwable)re);
            servletResponse.sendError(500, msg);
        }
        return msg;
    }

    @GET
    @Path(value="/cde-embed.js")
    @Produces(value={"text/javascript"})
    public String getCdeEmbeddedContext(@Context HttpServletRequest servletRequest, @Context HttpServletResponse servletResponse) throws Exception {
        return InterPluginBroker.getCdfEmbed(servletRequest.getProtocol(), servletRequest.getServerName(), servletRequest.getServerPort(), servletRequest.getSession().getMaxInactiveInterval(), servletRequest.getParameter("locale"), servletRequest.isSecure(), this.getParameterProvider(servletRequest.getParameterMap()));
    }

    private CdfRunJsDashboardWriteResult loadDashboard(String filePath, String scheme, String root, boolean absolute, boolean bypassCache, boolean debug, String style) throws ThingWriteException {
        CdfRunJsDashboardWriteOptions options = new CdfRunJsDashboardWriteOptions("", false, absolute, debug, root, scheme);
        return this.getDashboardManager().getDashboardCdfRunJs(filePath, options, bypassCache, style);
    }

    private CdfRunJsDashboardWriteResult getDashboardModule(String path, String scheme, String root, boolean absolute, boolean bypassCache, boolean debug, String style, String alias) throws ThingWriteException {
        String dashboardAlias = StringUtils.isEmpty((String)alias) ? FilenameUtils.removeExtension((String)FilenameUtils.getName((String)path)) + "_" + "@ALIAS@" : FilenameUtils.removeExtension((String)FilenameUtils.getName((String)path)) + "_" + alias;
        CdfRunJsDashboardWriteOptions options = new CdfRunJsDashboardWriteOptions(dashboardAlias, true, absolute, debug, root, scheme);
        return this.getDashboardManager().getDashboardCdfRunJs(path, options, bypassCache, style);
    }

    public DashboardManager getDashboardManager() {
        return this.dashboardManager;
    }

    public void setDashboardManager(DashboardManager dashboardManager) {
        this.dashboardManager = dashboardManager;
    }

    private String getWcdfRelativePath(String solution, String path, String file) {
        return Util.joinPath((String[])new String[]{solution, path, file});
    }

    private IPentahoSession getPentahoSession() {
        return PentahoSessionHolder.getSession();
    }

    private String getObjectName() {
        return RenderApi.class.getName();
    }

    private String getPluginName() {
        return CdeEnvironment.getPluginId();
    }

    private ILogger getAuditLogger() {
        return new SimpleLogger(RenderApi.class.getName());
    }

    private IParameterProvider getParameterProvider(Map<String, String[]> params) {
        return new SimpleParameterProvider(params);
    }

    private String getEditor(String path, boolean debug, String scheme, boolean isDefault, HttpServletResponse response, boolean isRequire) throws Exception {
        response.setContentType("text/html");
        String result = DashboardEditor.getEditor((String)path, (boolean)debug, (String)scheme, (boolean)isDefault, (boolean)isRequire);
        if (!StringUtils.isEmpty((String)result)) {
            String msgDir = Util.SEPARATOR + "lang" + Util.SEPARATOR;
            result = new MessageBundlesHelper(msgDir, CdeEnvironment.getPluginSystemReader(null), CdeEnvironment.getPluginSystemWriter(), this.getEnv().getLocale(), this.getEnv().getExtApi().getPluginStaticBaseUrl()).replaceParameters(result, null);
        }
        return result;
    }

    private ICdeEnvironment getEnv() {
        if (this.privateEnviroment != null) {
            return this.privateEnviroment;
        }
        return CdeEngine.getEnv();
    }

    protected void setCorsHeaders(HttpServletRequest request, HttpServletResponse response) {
        CorsUtil.getInstance().setCorsHeaders(request, response);
    }

    protected boolean hasSystemOrUserReadAccess(String path) {
        return Utils.getSystemOrUserReadAccess((String)path) != null;
    }

    protected String getCdfRequireConfig(String filePath, IParameterProvider requestParams) throws Exception {
        return InterPluginBroker.getCdfRequireConfig(filePath, requestParams);
    }

    protected String getCdfRequireContext(String filePath, IParameterProvider requestParams) throws Exception {
        return InterPluginBroker.getCdfRequireContext(filePath, requestParams);
    }

    protected String getCdfContext(String filePath, String action, String view, IParameterProvider requestParams) throws Exception {
        return InterPluginBroker.getCdfContext(filePath, action, view, requestParams);
    }

    private String decodeAndEscape(String path) {
        XSSHelper helper = XSSHelper.getInstance();
        return helper.escape(Utils.getURLDecoded((String)path));
    }
}

