/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cdf.dd.api;

import java.util.List;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.apache.commons.lang.StringUtils;
import org.json.JSONException;
import pt.webdetails.cdf.dd.datasources.CdaDataSourceReader;
import pt.webdetails.cdf.dd.structure.DashboardWcdfDescriptor;

@Path(value="pentaho-cdf-dd/api/datasources")
public class DatasourcesApi {
    @GET
    @Path(value="/get")
    @Produces(value={"text/javascript"})
    public String listCdaSources(@QueryParam(value="dashboard") @DefaultValue(value="") String dashboard) throws JSONException {
        if (dashboard.isEmpty()) {
            return "[]";
        }
        dashboard = DashboardWcdfDescriptor.toStructurePath((String)dashboard);
        List<CdaDataSourceReader.CdaDataSource> dataSourcesList = this.getCdaDataSources(dashboard);
        Object[] dataSources = dataSourcesList.toArray(new CdaDataSourceReader.CdaDataSource[dataSourcesList.size()]);
        return "[" + StringUtils.join((Object[])dataSources, (String)",") + "]";
    }

    protected List<CdaDataSourceReader.CdaDataSource> getCdaDataSources(String dashboard) throws JSONException {
        return CdaDataSourceReader.getCdaDataSources((String)dashboard);
    }

    private class MethodParams {
        public static final String DASHBOARD = "dashboard";

        private MethodParams() {
        }
    }
}

