/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cdf.dd;

import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.engine.IAuthorizationPolicy;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.util.messages.LocaleHelper;
import pt.webdetails.cdf.dd.ICdeEnvironmentExtended;
import pt.webdetails.cdf.dd.IPluginResourceLocationManager;
import pt.webdetails.cdf.dd.InterPluginBroker;
import pt.webdetails.cdf.dd.datasources.DataSourceManager;
import pt.webdetails.cdf.dd.datasources.IDataSourceManager;
import pt.webdetails.cdf.dd.extapi.CdeApiPathProvider;
import pt.webdetails.cdf.dd.extapi.FileHandler;
import pt.webdetails.cdf.dd.extapi.ICdeApiPathProvider;
import pt.webdetails.cdf.dd.extapi.IFileHandler;
import pt.webdetails.cdf.dd.model.core.writer.IThingWriterFactory;
import pt.webdetails.cdf.dd.model.inst.Dashboard;
import pt.webdetails.cdf.dd.model.inst.writer.cdfrunjs.dashboard.CdfRunJsDashboardWriteContext;
import pt.webdetails.cdf.dd.model.inst.writer.cdfrunjs.dashboard.CdfRunJsDashboardWriteOptions;
import pt.webdetails.cdf.dd.model.inst.writer.cdfrunjs.dashboard.amd.PentahoCdfRunJsDashboardWriteContext;
import pt.webdetails.cdf.dd.util.Utils;
import pt.webdetails.cpf.PentahoPluginEnvironment;
import pt.webdetails.cpf.PentahoUrlProvider;
import pt.webdetails.cpf.PluginEnvironment;
import pt.webdetails.cpf.bean.IBeanFactory;
import pt.webdetails.cpf.context.api.IUrlProvider;
import pt.webdetails.cpf.repository.api.IBasicFile;
import pt.webdetails.cpf.resources.IResourceLoader;
import pt.webdetails.cpf.resources.PentahoPluginResourceLoader;
import pt.webdetails.cpf.session.IUserSession;
import pt.webdetails.cpf.session.PentahoSessionUtils;

public class PentahoCdeEnvironment
extends PentahoPluginEnvironment
implements ICdeEnvironmentExtended {
    private static final String PLUGIN_REPOSITORY_DIR = "/public/cde";
    private static final String SYSTEM_DIR = "system";
    private static final String PLUGIN = "plugin";
    private static final String CDE_XML = "cde.xml";
    private static final String API_REPOS = "api/repos/";
    protected static Log logger = LogFactory.getLog(PentahoCdeEnvironment.class);
    private IBeanFactory factory;
    private IResourceLoader resourceLoader;
    private IPluginResourceLocationManager pluginResourceLocationManager;
    private ICdeApiPathProvider apiPaths;
    private IFileHandler fileHandler;
    private IAuthorizationPolicy authorizationPolicy;

    public void init(IBeanFactory factory) {
        this.factory = factory;
        PentahoPluginEnvironment.init((PluginEnvironment)this);
    }

    public void refresh() {
        this.init(this.factory);
    }

    public String getApplicationBaseUrl() {
        return PentahoSystem.getApplicationContext().getBaseUrl();
    }

    public String getApplicationReposUrl() {
        return this.getApplicationBaseUrl() + API_REPOS;
    }

    public IDataSourceManager getDataSourceManager() {
        return DataSourceManager.getInstance();
    }

    public Locale getLocale() {
        return LocaleHelper.getLocale();
    }

    public IPluginResourceLocationManager getPluginResourceLocationManager() {
        return this.pluginResourceLocationManager;
    }

    public void setPluginResourceLocationManager(IPluginResourceLocationManager pluginResourceLocationManager) {
        this.pluginResourceLocationManager = pluginResourceLocationManager;
    }

    public IResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    public void setResourceLoader(PentahoPluginResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public void setAuthorizationPolicy(IAuthorizationPolicy authorizationPolicy) {
        this.authorizationPolicy = authorizationPolicy;
    }

    public String getPluginRepositoryDir() {
        return PLUGIN_REPOSITORY_DIR;
    }

    public String getPluginId() {
        return super.getPluginId();
    }

    public String getSystemDir() {
        return SYSTEM_DIR;
    }

    public String getApplicationBaseContentUrl() {
        return Utils.joinPath((String[])new String[]{this.getApplicationBaseUrl(), PLUGIN, this.getPluginId()}) + "/";
    }

    public String getRepositoryBaseContentUrl() {
        return Utils.joinPath((String[])new String[]{this.getApplicationBaseUrl(), PLUGIN, this.getPluginId()}) + "/res/";
    }

    public String getCdfIncludes(String dashboard, String type, boolean debug, boolean absolute, String absRoot, String scheme) throws Exception {
        return InterPluginBroker.getCdfIncludes(dashboard, type, debug, absolute, absRoot, scheme);
    }

    public PluginEnvironment getPluginEnv() {
        return PentahoPluginEnvironment.getInstance();
    }

    public ICdeApiPathProvider getExtApi() {
        if (this.apiPaths == null) {
            this.apiPaths = new CdeApiPathProvider(this.getPluginEnv().getUrlProvider());
        }
        return this.apiPaths;
    }

    public IFileHandler getFileHandler() {
        return this.fileHandler;
    }

    public void setFileHandler(FileHandler fileHandler) {
        this.fileHandler = fileHandler;
    }

    public CdfRunJsDashboardWriteContext getCdfRunJsDashboardWriteContext(IThingWriterFactory factory, String indent, boolean bypassCacheRead, Dashboard dash, CdfRunJsDashboardWriteOptions options) {
        if (dash.getWcdf().isRequire()) {
            return new PentahoCdfRunJsDashboardWriteContext(factory, indent, bypassCacheRead, dash, options);
        }
        return new pt.webdetails.cdf.dd.model.inst.writer.cdfrunjs.dashboard.legacy.PentahoCdfRunJsDashboardWriteContext(factory, indent, bypassCacheRead, dash, options);
    }

    public CdfRunJsDashboardWriteContext getCdfRunJsDashboardWriteContext(CdfRunJsDashboardWriteContext factory, String indent) {
        return new pt.webdetails.cdf.dd.model.inst.writer.cdfrunjs.dashboard.legacy.PentahoCdfRunJsDashboardWriteContext(factory, indent);
    }

    public IBasicFile getCdeXml() {
        if (this.getUserContentAccess("/").fileExists("/public/cde/cde.xml")) {
            return this.getUserContentAccess("/").fetchFile("/public/cde/cde.xml");
        }
        if (this.getPluginSystemReader(null).fileExists(CDE_XML)) {
            return this.getPluginSystemReader(null).fetchFile(CDE_XML);
        }
        return null;
    }

    public IUrlProvider getUrlProvider() {
        return new PentahoUrlProvider(this.getPluginId()){

            public String getResourcesBasePath() {
                return PentahoCdeEnvironment.this.getExtApi().getResourcesBasePath();
            }
        };
    }

    public IUserSession getUserSession() {
        return new PentahoSessionUtils().getCurrentSession();
    }

    public boolean canCreateContent() {
        if (this.authorizationPolicy == null) {
            this.authorizationPolicy = (IAuthorizationPolicy)PentahoSystem.get(IAuthorizationPolicy.class);
            if (this.authorizationPolicy == null) {
                logger.warn((Object)"Couldn't retrieve Authorization Policy");
                return this.getUserSession().isAdministrator();
            }
        }
        return this.authorizationPolicy.isAllowed("org.pentaho.repository.create");
    }
}

