/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.xul;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.widgets.Display;
import org.pentaho.di.core.SwtUniversalImageSvg;
import org.pentaho.di.core.svg.SvgImage;
import org.pentaho.di.core.svg.SvgSupport;
import org.pentaho.di.ui.xul.KettleDialog;
import org.pentaho.di.ui.xul.KettleWaitBox;
import org.pentaho.ui.xul.XulException;
import org.pentaho.ui.xul.swt.SwtXulLoader;

public class KettleXulLoader
extends SwtXulLoader {
    private int iconWidth = 16;
    private int iconHeight = 16;

    public KettleXulLoader() throws XulException {
        this.parser.handlers.remove("DIALOG");
        this.parser.registerHandler("DIALOG", KettleDialog.class.getName());
        this.parser.handlers.remove("ICONWAITBOX");
        this.parser.registerHandler("ICONWAITBOX", KettleWaitBox.class.getName());
    }

    public void setIconsSize(int width, int height) {
        this.iconWidth = width;
        this.iconHeight = height;
    }

    public InputStream getOriginalResourceAsStream(String resource) {
        return super.getResourceAsStream(resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public InputStream getResourceAsStream(String resource) {
        int height = this.iconHeight;
        int width = this.iconWidth;
        if (resource.contains(":")) {
            width = Integer.parseInt(resource.substring(resource.indexOf(":") + 1, resource.indexOf("#")));
            height = Integer.parseInt(resource.substring(resource.indexOf("#") + 1, resource.indexOf(".")));
            resource = resource.substring(0, resource.indexOf(":")) + resource.substring(resource.indexOf("."));
        }
        if (SvgSupport.isSvgEnabled() && (SvgSupport.isSvgName((String)resource) || SvgSupport.isPngName((String)resource))) {
            ByteArrayInputStream byteArrayInputStream;
            InputStream in = null;
            try {
                in = super.getResourceAsStream(SvgSupport.toSvgName((String)resource));
                SvgImage svg = SvgSupport.loadSvgImage((InputStream)in);
                SwtUniversalImageSvg image = new SwtUniversalImageSvg(svg);
                Display d = Display.getCurrent() != null ? Display.getCurrent() : Display.getDefault();
                Image result = image.getAsBitmapForSize((Device)d, width, height);
                ImageLoader loader = new ImageLoader();
                loader.data = new ImageData[]{result.getImageData()};
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                loader.save((OutputStream)out, 5);
                image.dispose();
                byteArrayInputStream = new ByteArrayInputStream(out.toByteArray());
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly((InputStream)in);
                catch (Throwable throwable2) {
                    IOUtils.closeQuietly(in);
                    throw throwable2;
                }
            }
            IOUtils.closeQuietly((InputStream)in);
            return byteArrayInputStream;
            resource = SvgSupport.toPngName((String)resource);
        }
        return super.getResourceAsStream(resource);
    }
}

