/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.trans.steps.regexeval;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.steps.regexeval.RegexEvalMeta;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.core.gui.WindowProperty;
import org.pentaho.di.ui.core.widget.StyledTextComp;
import org.pentaho.di.ui.trans.step.BaseStepDialog;

public class RegexEvalHelperDialog
extends Dialog {
    private static Class<?> PKG = RegexEvalMeta.class;
    private Button wOK;
    private Button wCancel;
    private Listener lsOK;
    private Listener lsCancel;
    private Shell shell;
    private PropsUI props;
    private String regexscript;
    private String regexoptions;
    private boolean canonicalEqualityFlagSet;
    private TransMeta transmeta;
    private CTabFolder wNoteFolder;
    private FormData fdNoteFolder;
    private CTabItem wNoteContentTab;
    private FormData fdNoteContentComp;
    private Label wlRegExScript;
    private StyledTextComp wRegExScript;
    private FormData fdlRegExScript;
    private FormData fdRegExScript;
    private Label wlValue1;
    private Text wValue1;
    private FormData fdlValue1;
    private FormData fdValue1;
    private Label wlValue2;
    private Text wValue2;
    private FormData fdlValue2;
    private FormData fdValue2;
    private Label wlValue3;
    private Text wValue3;
    private FormData fdlValue3;
    private FormData fdValue3;
    private Group wValuesGroup;
    private FormData fdValuesGroup;
    private Group wCaptureGroups;
    private FormData fdCaptureGroups;
    private Text wRegExScriptCompile;
    private FormData fdRegExScriptCompile;
    private List wGroups;
    private FormData fdGroups;
    private Label wlGroups;
    private FormData fdlGroups;
    private Label wlValueGroup;
    private Text wValueGroup;
    private FormData fdlValueGroup;
    private FormData fdValueGroup;
    GUIResource guiresource = GUIResource.getInstance();
    private boolean errorDisplayed;

    public RegexEvalHelperDialog(Shell parent, TransMeta transmeta, String RegexScript, String RegexOptions, boolean canonicalEqualityFlagSet) {
        super(parent, 0);
        this.props = PropsUI.getInstance();
        this.regexscript = RegexScript;
        this.regexoptions = RegexOptions;
        this.transmeta = transmeta;
        this.errorDisplayed = false;
        this.canonicalEqualityFlagSet = canonicalEqualityFlagSet;
    }

    private boolean isCanonicalEqualityFlagSet() {
        return this.canonicalEqualityFlagSet;
    }

    public String open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.shell.setImage(this.guiresource.getImageSpoon());
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"RegexEvalHelperDialog.Shell.Label", (String[])new String[0]));
        int margin = 4;
        int middle = 30;
        this.wNoteFolder = new CTabFolder((Composite)this.shell, 2048);
        this.props.setLook((Control)this.wNoteFolder, 5);
        this.wNoteContentTab = new CTabItem(this.wNoteFolder, 0);
        this.wNoteContentTab.setText(BaseMessages.getString(PKG, (String)"RegexEvalHelperDialog.RegExTab.Label", (String[])new String[0]));
        Composite wNoteContentComp = new Composite((Composite)this.wNoteFolder, 0);
        this.props.setLook((Control)wNoteContentComp);
        FormLayout fileLayout = new FormLayout();
        fileLayout.marginWidth = 3;
        fileLayout.marginHeight = 3;
        wNoteContentComp.setLayout((Layout)fileLayout);
        this.wlRegExScript = new Label(wNoteContentComp, 131072);
        this.wlRegExScript.setText(BaseMessages.getString(PKG, (String)"RegexEvalHelperDialog.Script.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlRegExScript);
        this.fdlRegExScript = new FormData();
        this.fdlRegExScript.left = new FormAttachment(0, 0);
        this.fdlRegExScript.top = new FormAttachment(0, 2 * margin);
        this.wlRegExScript.setLayoutData((Object)this.fdlRegExScript);
        this.wRegExScript = new StyledTextComp((VariableSpace)this.transmeta, wNoteContentComp, 19202, "");
        this.wRegExScript.setText("");
        this.props.setLook((Control)this.wRegExScript, 1);
        this.props.setLook((Control)this.wRegExScript);
        this.fdRegExScript = new FormData();
        this.fdRegExScript.left = new FormAttachment(0, 0);
        this.fdRegExScript.top = new FormAttachment((Control)this.wlRegExScript, 2 * margin);
        this.fdRegExScript.right = new FormAttachment(100, -2 * margin);
        this.fdRegExScript.bottom = new FormAttachment(40, -margin);
        this.wRegExScript.setLayoutData(this.fdRegExScript);
        this.wRegExScriptCompile = new Text(wNoteContentComp, 18946);
        this.wRegExScriptCompile.setText("");
        this.props.setLook((Control)this.wRegExScriptCompile, 1);
        this.fdRegExScriptCompile = new FormData();
        this.fdRegExScriptCompile.left = new FormAttachment(0, 0);
        this.fdRegExScriptCompile.top = new FormAttachment((Control)this.wRegExScript, margin);
        this.fdRegExScriptCompile.right = new FormAttachment(100, 0);
        this.wRegExScriptCompile.setLayoutData((Object)this.fdRegExScriptCompile);
        this.wRegExScriptCompile.setEditable(false);
        this.wRegExScriptCompile.setFont(this.guiresource.getFontNote());
        this.wValuesGroup = new Group(wNoteContentComp, 32);
        this.props.setLook((Control)this.wValuesGroup);
        this.wValuesGroup.setText(BaseMessages.getString(PKG, (String)"RegexEvalHelperDialog.TestValues.Label", (String[])new String[0]));
        FormLayout groupLayout = new FormLayout();
        groupLayout.marginWidth = 10;
        groupLayout.marginHeight = 10;
        this.wValuesGroup.setLayout((Layout)groupLayout);
        this.wlValue1 = new Label((Composite)this.wValuesGroup, 131072);
        this.wlValue1.setText(BaseMessages.getString(PKG, (String)"RegexEvalHelperDialog.Value1.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlValue1);
        this.fdlValue1 = new FormData();
        this.fdlValue1.left = new FormAttachment(0, 0);
        this.fdlValue1.top = new FormAttachment((Control)this.wRegExScriptCompile, margin);
        this.fdlValue1.right = new FormAttachment(middle, -margin);
        this.wlValue1.setLayoutData((Object)this.fdlValue1);
        this.wValue1 = new Text((Composite)this.wValuesGroup, 18436);
        this.props.setLook((Control)this.wValue1);
        this.fdValue1 = new FormData();
        this.fdValue1.left = new FormAttachment(middle, margin);
        this.fdValue1.top = new FormAttachment((Control)this.wRegExScriptCompile, margin);
        this.fdValue1.right = new FormAttachment(100, -margin);
        this.wValue1.setLayoutData((Object)this.fdValue1);
        this.wlValue2 = new Label((Composite)this.wValuesGroup, 131072);
        this.wlValue2.setText(BaseMessages.getString(PKG, (String)"RegexEvalHelperDialog.Value2.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlValue2);
        this.fdlValue2 = new FormData();
        this.fdlValue2.left = new FormAttachment(0, 0);
        this.fdlValue2.top = new FormAttachment((Control)this.wValue1, margin);
        this.fdlValue2.right = new FormAttachment(middle, -margin);
        this.wlValue2.setLayoutData((Object)this.fdlValue2);
        this.wValue2 = new Text((Composite)this.wValuesGroup, 18436);
        this.props.setLook((Control)this.wValue2);
        this.fdValue2 = new FormData();
        this.fdValue2.left = new FormAttachment(middle, margin);
        this.fdValue2.top = new FormAttachment((Control)this.wValue1, margin);
        this.fdValue2.right = new FormAttachment(100, -margin);
        this.wValue2.setLayoutData((Object)this.fdValue2);
        this.wlValue3 = new Label((Composite)this.wValuesGroup, 131072);
        this.wlValue3.setText(BaseMessages.getString(PKG, (String)"RegexEvalHelperDialog.Value3.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlValue3);
        this.fdlValue3 = new FormData();
        this.fdlValue3.left = new FormAttachment(0, 0);
        this.fdlValue3.top = new FormAttachment((Control)this.wValue2, margin);
        this.fdlValue3.right = new FormAttachment(middle, -margin);
        this.wlValue3.setLayoutData((Object)this.fdlValue3);
        this.wValue3 = new Text((Composite)this.wValuesGroup, 18436);
        this.props.setLook((Control)this.wValue3);
        this.fdValue3 = new FormData();
        this.fdValue3.left = new FormAttachment(middle, margin);
        this.fdValue3.top = new FormAttachment((Control)this.wValue2, margin);
        this.fdValue3.right = new FormAttachment(100, -margin);
        this.wValue3.setLayoutData((Object)this.fdValue3);
        this.fdValuesGroup = new FormData();
        this.fdValuesGroup.left = new FormAttachment(0, margin);
        this.fdValuesGroup.top = new FormAttachment((Control)this.wRegExScriptCompile, margin);
        this.fdValuesGroup.right = new FormAttachment(100, -margin);
        this.wValuesGroup.setLayoutData((Object)this.fdValuesGroup);
        this.wCaptureGroups = new Group(wNoteContentComp, 32);
        this.props.setLook((Control)this.wCaptureGroups);
        this.wCaptureGroups.setText("Capture");
        FormLayout captureLayout = new FormLayout();
        captureLayout.marginWidth = 10;
        captureLayout.marginHeight = 10;
        this.wCaptureGroups.setLayout((Layout)captureLayout);
        this.wlValueGroup = new Label((Composite)this.wCaptureGroups, 131072);
        this.wlValueGroup.setText(BaseMessages.getString(PKG, (String)"RegexEvalHelperDialog.ValueGroup.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlValueGroup);
        this.fdlValueGroup = new FormData();
        this.fdlValueGroup.left = new FormAttachment(0, 0);
        this.fdlValueGroup.top = new FormAttachment((Control)this.wValuesGroup, margin);
        this.fdlValueGroup.right = new FormAttachment(middle, -margin);
        this.wlValueGroup.setLayoutData((Object)this.fdlValueGroup);
        this.wValueGroup = new Text((Composite)this.wCaptureGroups, 18436);
        this.props.setLook((Control)this.wValueGroup);
        this.fdValueGroup = new FormData();
        this.fdValueGroup.left = new FormAttachment(middle, margin);
        this.fdValueGroup.top = new FormAttachment((Control)this.wValuesGroup, margin);
        this.fdValueGroup.right = new FormAttachment(100, -margin);
        this.wValueGroup.setLayoutData((Object)this.fdValueGroup);
        this.wlGroups = new Label((Composite)this.wCaptureGroups, 131072);
        this.wlGroups.setText(BaseMessages.getString(PKG, (String)"RegexEvalHelperDialog.GroupFields.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlGroups);
        this.fdlGroups = new FormData();
        this.fdlGroups.left = new FormAttachment(0, 0);
        this.fdlGroups.top = new FormAttachment((Control)this.wValueGroup, margin);
        this.fdlGroups.right = new FormAttachment(middle, -margin);
        this.wlGroups.setLayoutData((Object)this.fdlGroups);
        this.wGroups = new List((Composite)this.wCaptureGroups, 19204);
        this.props.setLook((Control)this.wValue3);
        this.fdGroups = new FormData();
        this.fdGroups.left = new FormAttachment(middle, margin);
        this.fdGroups.top = new FormAttachment((Control)this.wValueGroup, margin);
        this.fdGroups.right = new FormAttachment(100, -margin);
        this.fdGroups.bottom = new FormAttachment(100, -margin);
        this.wGroups.setLayoutData((Object)this.fdGroups);
        this.fdCaptureGroups = new FormData();
        this.fdCaptureGroups.left = new FormAttachment(0, margin);
        this.fdCaptureGroups.top = new FormAttachment((Control)this.wValuesGroup, margin);
        this.fdCaptureGroups.right = new FormAttachment(100, -margin);
        this.fdCaptureGroups.bottom = new FormAttachment(100, -margin);
        this.wCaptureGroups.setLayoutData((Object)this.fdCaptureGroups);
        this.fdNoteContentComp = new FormData();
        this.fdNoteContentComp.left = new FormAttachment(0, 0);
        this.fdNoteContentComp.top = new FormAttachment(0, 0);
        this.fdNoteContentComp.right = new FormAttachment(100, 0);
        this.fdNoteContentComp.bottom = new FormAttachment(100, 0);
        wNoteContentComp.setLayoutData((Object)this.fdNoteContentComp);
        wNoteContentComp.layout();
        this.wNoteContentTab.setControl((Control)wNoteContentComp);
        this.fdNoteFolder = new FormData();
        this.fdNoteFolder.left = new FormAttachment(0, 0);
        this.fdNoteFolder.top = new FormAttachment(0, margin);
        this.fdNoteFolder.right = new FormAttachment(100, 0);
        this.fdNoteFolder.bottom = new FormAttachment(100, -50);
        this.wNoteFolder.setLayoutData((Object)this.fdNoteFolder);
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        BaseStepDialog.positionBottomButtons((Composite)this.shell, new Button[]{this.wOK, this.wCancel}, margin, (Control)this.wNoteFolder);
        this.lsOK = new Listener(){

            public void handleEvent(Event e) {
                RegexEvalHelperDialog.this.ok();
            }
        };
        this.lsCancel = new Listener(){

            public void handleEvent(Event e) {
                RegexEvalHelperDialog.this.cancel();
            }
        };
        this.wOK.addListener(13, this.lsOK);
        this.wCancel.addListener(13, this.lsCancel);
        this.wValue1.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RegexEvalHelperDialog.this.testValue(1, true, null);
            }
        });
        this.wValue2.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RegexEvalHelperDialog.this.testValue(2, true, null);
            }
        });
        this.wValue3.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RegexEvalHelperDialog.this.testValue(3, true, null);
            }
        });
        this.wValueGroup.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RegexEvalHelperDialog.this.testValue(4, true, null);
            }
        });
        this.wRegExScript.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RegexEvalHelperDialog.this.errorDisplayed = false;
                RegexEvalHelperDialog.this.testValues();
            }
        });
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                RegexEvalHelperDialog.this.cancel();
            }
        });
        this.getData();
        BaseStepDialog.setSize(this.shell);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.regexscript;
    }

    private void testValues() {
        String realScript = this.transmeta.environmentSubstitute(this.wRegExScript.getText());
        for (int i = 1; i < 5; ++i) {
            this.testValue(i, false, realScript);
        }
    }

    private void testValue(int index, boolean testRegEx, String regExString) {
        block17: {
            String realScript = regExString;
            if (realScript == null) {
                realScript = this.transmeta.environmentSubstitute(this.wRegExScript.getText());
            }
            if (Utils.isEmpty((CharSequence)realScript)) {
                if (testRegEx) {
                    MessageBox mb = new MessageBox(this.shell, 33);
                    mb.setMessage(BaseMessages.getString(PKG, (String)"RegexEvalHelperDialog.EnterScript.Message", (String[])new String[0]));
                    mb.setText(BaseMessages.getString(PKG, (String)"RegexEvalHelperDialog.EnterScript.Title", (String[])new String[0]));
                    mb.open();
                }
                return;
            }
            String realValue = null;
            Text control = null;
            switch (index) {
                case 1: {
                    realValue = Const.NVL((String)this.transmeta.environmentSubstitute(this.wValue1.getText()), (String)"");
                    control = this.wValue1;
                    break;
                }
                case 2: {
                    realValue = Const.NVL((String)this.transmeta.environmentSubstitute(this.wValue2.getText()), (String)"");
                    control = this.wValue2;
                    break;
                }
                case 3: {
                    realValue = Const.NVL((String)this.transmeta.environmentSubstitute(this.wValue3.getText()), (String)"");
                    control = this.wValue3;
                    break;
                }
                case 4: {
                    realValue = Const.NVL((String)this.transmeta.environmentSubstitute(this.wValueGroup.getText()), (String)"");
                    control = this.wValueGroup;
                    break;
                }
            }
            try {
                Pattern p = this.isCanonicalEqualityFlagSet() ? Pattern.compile(this.regexoptions + realScript, 128) : Pattern.compile(this.regexoptions + realScript);
                Matcher m = p.matcher(realValue);
                boolean ismatch = m.matches();
                if (ismatch) {
                    control.setBackground(this.guiresource.getColorGreen());
                } else {
                    control.setBackground(this.guiresource.getColorRed());
                }
                if (index == 4) {
                    this.wGroups.removeAll();
                    int nrFields = m.groupCount();
                    int nr = 0;
                    for (int i = 1; i <= nrFields; ++i) {
                        if (m.group(i) == null) {
                            this.wGroups.add("");
                        } else {
                            this.wGroups.add(m.group(i));
                        }
                        ++nr;
                    }
                    this.wlGroups.setText(BaseMessages.getString(PKG, (String)"RegexEvalHelperDialog.FieldsGroup", (Object[])new Object[]{nr}));
                }
                this.wRegExScriptCompile.setForeground(this.guiresource.getColorBlue());
                this.wRegExScriptCompile.setText(BaseMessages.getString(PKG, (String)"RegexEvalHelperDialog.ScriptSuccessfullyCompiled", (String[])new String[0]));
                this.wRegExScriptCompile.setToolTipText("");
            }
            catch (Exception e) {
                if (this.errorDisplayed) break block17;
                this.wRegExScriptCompile.setForeground(this.guiresource.getColorRed());
                this.wRegExScriptCompile.setText(e.getMessage());
                this.wRegExScriptCompile.setToolTipText(BaseMessages.getString(PKG, (String)"RegexEvalHelperDialog.ErrorCompiling.Message", (String[])new String[0]) + Const.CR + e.toString());
                this.errorDisplayed = true;
            }
        }
    }

    public void dispose() {
        this.props.setScreen(new WindowProperty(this.shell));
        this.shell.dispose();
    }

    public void getData() {
        if (this.regexscript != null) {
            this.wRegExScript.setText(this.regexscript);
        }
    }

    private void cancel() {
        this.dispose();
    }

    private void ok() {
        if (this.wRegExScript.getText() != null) {
            this.regexscript = this.wRegExScript.getText();
        }
        this.dispose();
    }
}

