/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.trans.steps.normaliser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDialogInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.normaliser.NormaliserMeta;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.widget.ColumnInfo;
import org.pentaho.di.ui.core.widget.TableView;
import org.pentaho.di.ui.trans.step.BaseStepDialog;

public class NormaliserDialog
extends BaseStepDialog
implements StepDialogInterface {
    private static Class<?> PKG = NormaliserMeta.class;
    private static final int NAME_INDEX = 1;
    private static final int VALUE_INDEX = 2;
    private static final int NORM_INDEX = 3;
    private Label wlTypefield;
    private Text wTypefield;
    private FormData fdlTypefield;
    private FormData fdTypefield;
    private Label wlFields;
    private TableView wFields;
    private FormData fdlFields;
    private FormData fdFields;
    private NormaliserMeta input;
    private ColumnInfo[] colinf;
    private Map<String, Integer> inputFields;

    public NormaliserDialog(Shell parent, Object in, TransMeta transMeta, String sname) {
        super(parent, (BaseStepMeta)in, transMeta, sname);
        this.input = (NormaliserMeta)in;
        this.inputFields = new HashMap<String, Integer>();
    }

    public String open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, (StepMetaInterface)this.input);
        ModifyListener lsMod = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NormaliserDialog.this.input.setChanged();
            }
        };
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"NormaliserDialog.Shell.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = 4;
        this.wlStepname = new Label((Composite)this.shell, 131072);
        this.wlStepname.setText(BaseMessages.getString(PKG, (String)"NormaliserDialog.Stepname.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlStepname);
        this.fdlStepname = new FormData();
        this.fdlStepname.left = new FormAttachment(0, 0);
        this.fdlStepname.right = new FormAttachment(middle, -margin);
        this.fdlStepname.top = new FormAttachment(0, margin);
        this.wlStepname.setLayoutData((Object)this.fdlStepname);
        this.wStepname = new Text((Composite)this.shell, 18436);
        this.wStepname.setText(this.stepname);
        this.props.setLook((Control)this.wStepname);
        this.wStepname.addModifyListener(lsMod);
        this.fdStepname = new FormData();
        this.fdStepname.left = new FormAttachment(middle, 0);
        this.fdStepname.top = new FormAttachment(0, margin);
        this.fdStepname.right = new FormAttachment(100, 0);
        this.wStepname.setLayoutData((Object)this.fdStepname);
        this.wlTypefield = new Label((Composite)this.shell, 131072);
        this.wlTypefield.setText(BaseMessages.getString(PKG, (String)"NormaliserDialog.TypeField.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlTypefield);
        this.fdlTypefield = new FormData();
        this.fdlTypefield.left = new FormAttachment(0, 0);
        this.fdlTypefield.right = new FormAttachment(middle, -margin);
        this.fdlTypefield.top = new FormAttachment((Control)this.wStepname, margin);
        this.wlTypefield.setLayoutData((Object)this.fdlTypefield);
        this.wTypefield = new Text((Composite)this.shell, 18436);
        this.wTypefield.setText("");
        this.props.setLook((Control)this.wTypefield);
        this.wTypefield.addModifyListener(lsMod);
        this.fdTypefield = new FormData();
        this.fdTypefield.left = new FormAttachment(middle, 0);
        this.fdTypefield.top = new FormAttachment((Control)this.wStepname, margin);
        this.fdTypefield.right = new FormAttachment(100, 0);
        this.wTypefield.setLayoutData((Object)this.fdTypefield);
        this.wlFields = new Label((Composite)this.shell, 0);
        this.wlFields.setText(BaseMessages.getString(PKG, (String)"NormaliserDialog.Fields.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlFields);
        this.fdlFields = new FormData();
        this.fdlFields.left = new FormAttachment(0, 0);
        this.fdlFields.top = new FormAttachment((Control)this.wTypefield, margin);
        this.wlFields.setLayoutData((Object)this.fdlFields);
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wGet = new Button((Composite)this.shell, 8);
        this.wGet.setText(BaseMessages.getString(PKG, (String)"NormaliserDialog.GetFields.Button", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.setButtonPositions(new Button[]{this.wOK, this.wCancel, this.wGet}, margin, null);
        int fieldsCols = 3;
        int fieldsRows = this.input.getNormaliserFields().length;
        this.colinf = new ColumnInfo[3];
        this.colinf[0] = new ColumnInfo(BaseMessages.getString(PKG, (String)"NormaliserDialog.ColumnInfo.Fieldname", (String[])new String[0]), 2, new String[]{""}, false);
        this.colinf[1] = new ColumnInfo(BaseMessages.getString(PKG, (String)"NormaliserDialog.ColumnInfo.Type", (String[])new String[0]), 1, false);
        this.colinf[2] = new ColumnInfo(BaseMessages.getString(PKG, (String)"NormaliserDialog.ColumnInfo.NewField", (String[])new String[0]), 1, false);
        this.wFields = new TableView((VariableSpace)this.transMeta, (Composite)this.shell, 67586, this.colinf, fieldsRows, lsMod, this.props);
        this.fdFields = new FormData();
        this.fdFields.left = new FormAttachment(0, 0);
        this.fdFields.top = new FormAttachment((Control)this.wlFields, margin);
        this.fdFields.right = new FormAttachment(100, 0);
        this.fdFields.bottom = new FormAttachment((Control)this.wOK, -2 * margin);
        this.wFields.setLayoutData(this.fdFields);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                StepMeta stepMeta = NormaliserDialog.this.transMeta.findStep(NormaliserDialog.this.stepname);
                if (stepMeta != null) {
                    try {
                        RowMetaInterface row = NormaliserDialog.this.transMeta.getPrevStepFields(stepMeta);
                        for (int i = 0; i < row.size(); ++i) {
                            NormaliserDialog.this.inputFields.put(row.getValueMeta(i).getName(), i);
                        }
                        NormaliserDialog.this.setComboBoxes();
                    }
                    catch (KettleException e) {
                        NormaliserDialog.this.logError(BaseMessages.getString((Class)PKG, (String)"System.Dialog.GetFieldsFailed.Message", (String[])new String[0]));
                    }
                }
            }
        };
        new Thread(runnable).start();
        this.lsOK = new Listener(){

            public void handleEvent(Event e) {
                NormaliserDialog.this.ok();
            }
        };
        this.lsGet = new Listener(){

            public void handleEvent(Event e) {
                NormaliserDialog.this.get();
            }
        };
        this.lsCancel = new Listener(){

            public void handleEvent(Event e) {
                NormaliserDialog.this.cancel();
            }
        };
        this.wOK.addListener(13, this.lsOK);
        this.wGet.addListener(13, this.lsGet);
        this.wCancel.addListener(13, this.lsCancel);
        this.lsDef = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                NormaliserDialog.this.ok();
            }
        };
        this.wStepname.addSelectionListener((SelectionListener)this.lsDef);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                NormaliserDialog.this.cancel();
            }
        });
        this.setSize();
        this.getData();
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.stepname;
    }

    protected void setComboBoxes() {
        HashMap<String, Integer> fields = new HashMap<String, Integer>();
        fields.putAll(this.inputFields);
        Set keySet = fields.keySet();
        ArrayList entries = new ArrayList(keySet);
        String[] fieldNames = entries.toArray(new String[entries.size()]);
        Const.sortStrings((String[])fieldNames);
        this.colinf[0].setComboValues(fieldNames);
    }

    public void getData() {
        if (this.input.getTypeField() != null) {
            this.wTypefield.setText(this.input.getTypeField());
        }
        for (int i = 0; i < this.input.getNormaliserFields().length; ++i) {
            TableItem item = this.wFields.table.getItem(i);
            if (this.input.getNormaliserFields()[i].getName() != null) {
                item.setText(1, this.input.getNormaliserFields()[i].getName());
            }
            if (this.input.getNormaliserFields()[i].getValue() != null) {
                item.setText(2, this.input.getNormaliserFields()[i].getValue());
            }
            if (this.input.getNormaliserFields()[i].getNorm() == null) continue;
            item.setText(3, this.input.getNormaliserFields()[i].getNorm());
        }
        this.wFields.setRowNums();
        this.wFields.optWidth(true);
        this.wStepname.selectAll();
        this.wStepname.setFocus();
    }

    private void cancel() {
        this.stepname = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wStepname.getText())) {
            return;
        }
        this.stepname = this.wStepname.getText();
        this.input.setTypeField(this.wTypefield.getText());
        int nrfields = this.wFields.nrNonEmpty();
        this.input.allocate(nrfields);
        for (int i = 0; i < nrfields; ++i) {
            TableItem item = this.wFields.getNonEmpty(i);
            this.input.getNormaliserFields()[i].setName(item.getText(1));
            this.input.getNormaliserFields()[i].setValue(item.getText(2));
            this.input.getNormaliserFields()[i].setNorm(item.getText(3));
        }
        this.dispose();
    }

    private void get() {
        try {
            RowMetaInterface r = this.transMeta.getPrevStepFields(this.stepname);
            if (r != null && !r.isEmpty()) {
                BaseStepDialog.getFieldsFromPrevious(r, this.wFields, 1, new int[]{1, 2}, new int[0], -1, -1, null);
            }
        }
        catch (KettleException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"NormaliserDialog.FailedToGetFields.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"NormaliserDialog.FailedToGetFields.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
        }
    }
}

