/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.spoon.delegates;

import java.util.List;
import org.pentaho.di.core.EngineMetaInterface;
import org.pentaho.di.core.changed.ChangedFlagInterface;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryElementInterface;
import org.pentaho.di.shared.SharedObjectInterface;
import org.pentaho.di.ui.spoon.SharedObjectSyncUtil;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.di.ui.spoon.delegates.SpoonDelegate;

public abstract class SpoonSharedObjectDelegate
extends SpoonDelegate {
    protected static final Class<?> PKG = Spoon.class;
    protected SharedObjectSyncUtil sharedObjectSyncUtil;

    public SpoonSharedObjectDelegate(Spoon spoon) {
        super(spoon);
    }

    public void setSharedObjectSyncUtil(SharedObjectSyncUtil sharedObjectSyncUtil) {
        this.sharedObjectSyncUtil = sharedObjectSyncUtil;
    }

    protected static boolean isDuplicate(List<? extends SharedObjectInterface> objects, SharedObjectInterface object) {
        String newName = object.getName();
        for (SharedObjectInterface sharedObjectInterface : objects) {
            if (!sharedObjectInterface.getName().equalsIgnoreCase(newName)) continue;
            return true;
        }
        return false;
    }

    protected <T extends SharedObjectInterface & RepositoryElementInterface> void saveSharedObjectToRepository(T sharedObject, String versionComment) throws KettleException {
        Repository rep = this.spoon.getRepository();
        if (rep != null) {
            if (!rep.getSecurityProvider().isReadOnly()) {
                rep.save((RepositoryElementInterface)sharedObject, versionComment, null);
                ((ChangedFlagInterface)sharedObject).clearChanged();
            } else {
                throw new KettleException(BaseMessages.getString(PKG, (String)"Spoon.Dialog.Exception.ReadOnlyRepositoryUser", (String[])new String[0]));
            }
        }
    }

    protected void saveSharedObjects() {
        try {
            EngineMetaInterface meta = this.spoon.getActiveMeta();
            if (meta != null) {
                meta.saveSharedObjects();
            }
        }
        catch (KettleException e) {
            this.spoon.getLog().logError(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    protected static String getMessage(String key) {
        return BaseMessages.getString(PKG, (String)key, (String[])new String[0]);
    }

    protected static String getMessage(String key, Object ... params) {
        return BaseMessages.getString(PKG, (String)key, (Object[])params);
    }
}

