/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.spoon;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.pentaho.di.base.AbstractMeta;
import org.pentaho.di.cluster.ClusterSchema;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.EngineMetaInterface;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.partition.PartitionSchema;
import org.pentaho.di.repository.RepositoryElementInterface;
import org.pentaho.di.shared.SharedObjectInterface;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.di.ui.spoon.delegates.SpoonDelegates;

public class SharedObjectSyncUtil {
    private final ConnectionSynchronizationHandler connectionSynchronizationHandler = new ConnectionSynchronizationHandler();
    private final SlaveServerSynchronizationHandler slaveServerSynchronizationHandler = new SlaveServerSynchronizationHandler();
    private final ClusterSchemaSynchronizationHandler clusterSchemaSynchronizationHandler = new ClusterSchemaSynchronizationHandler();
    private final PartitionSchemaSynchronizationHandler partitionSchemaSynchronizationHandler = new PartitionSchemaSynchronizationHandler();
    private final StepMetaSynchronizationHandler stepMetaSynchronizationHandler = new StepMetaSynchronizationHandler();
    private final SpoonDelegates spoonDelegates;
    private final Spoon spoon;

    public SharedObjectSyncUtil(Spoon spoon) {
        this.spoonDelegates = spoon.delegates;
        this.spoon = spoon;
        this.spoonDelegates.db.setSharedObjectSyncUtil(this);
        this.spoonDelegates.slaves.setSharedObjectSyncUtil(this);
        this.spoonDelegates.clusters.setSharedObjectSyncUtil(this);
        this.spoonDelegates.partitions.setSharedObjectSyncUtil(this);
    }

    public synchronized void synchronizeConnections(DatabaseMeta database) {
        this.synchronizeConnections(database, database.getName());
    }

    public synchronized void synchronizeConnections(DatabaseMeta database, String originalName) {
        if (!database.isShared()) {
            return;
        }
        this.synchronizeJobs(database, this.connectionSynchronizationHandler, originalName);
        this.synchronizeTransformations(database, this.connectionSynchronizationHandler, originalName);
        this.saveSharedObjects();
    }

    private void saveSharedObjects() {
        try {
            this.spoon.getActiveMeta().saveSharedObjects();
        }
        catch (KettleException e) {
            this.spoon.getLog().logError(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public synchronized void synchronizeSlaveServers(SlaveServer slaveServer) {
        this.synchronizeSlaveServers(slaveServer, slaveServer.getName());
    }

    public synchronized void synchronizeSlaveServers(SlaveServer slaveServer, String originalName) {
        if (slaveServer.isShared()) {
            this.synchronizeJobs(slaveServer, this.slaveServerSynchronizationHandler, originalName);
            this.synchronizeTransformations(slaveServer, this.slaveServerSynchronizationHandler, originalName);
            this.saveSharedObjects();
        }
        if (slaveServer.getObjectId() != null) {
            this.updateRepositoryObjects(slaveServer, this.slaveServerSynchronizationHandler);
        }
    }

    public synchronized void deleteSlaveServer(SlaveServer removed) {
        this.synchronizeAll(true, meta -> meta.getSlaveServers().remove(removed));
    }

    public synchronized void deleteClusterSchema(ClusterSchema removed) {
        this.synchronizeTransformations(true, transMeta -> transMeta.getClusterSchemas().remove(removed));
    }

    public synchronized void deletePartitionSchema(PartitionSchema removed) {
        this.synchronizeTransformations(true, transMeta -> transMeta.getPartitionSchemas().remove(removed));
    }

    private <T extends SharedObjectInterface & RepositoryElementInterface> void updateRepositoryObjects(T updatedObject, SynchronizationHandler<T> handler) {
        this.synchronizeJobs(true, job -> SharedObjectSyncUtil.synchronizeByObjectId(updatedObject, handler.getObjectsForSyncFromJob((JobMeta)job), handler));
        this.synchronizeTransformations(true, trans -> SharedObjectSyncUtil.synchronizeByObjectId(updatedObject, handler.getObjectsForSyncFromTransformation((TransMeta)trans), handler));
    }

    public synchronized void reloadTransformationRepositoryObjects(boolean includeActive) {
        if (this.spoon.rep != null) {
            this.synchronizeTransformations(includeActive, transMeta -> {
                try {
                    this.spoon.rep.readTransSharedObjects(transMeta);
                }
                catch (KettleException e) {
                    this.logError(e);
                }
            });
        }
    }

    public synchronized void reloadJobRepositoryObjects(boolean includeActive) {
        if (this.spoon.rep != null) {
            this.synchronizeJobs(includeActive, jobMeta -> {
                try {
                    this.spoon.rep.readJobMetaSharedObjects(jobMeta);
                }
                catch (KettleException e) {
                    this.logError(e);
                }
            });
        }
    }

    public synchronized void reloadSharedObjects() {
        this.synchronizeAll(false, meta -> {
            try {
                meta.setSharedObjects(meta.readSharedObjects());
            }
            catch (KettleException e) {
                this.logError(e);
            }
        });
    }

    private synchronized void synchronizeJobs(boolean includeActive, Consumer<JobMeta> synchronizeAction) {
        JobMeta current = this.spoon.getActiveJob();
        for (JobMeta job : this.spoonDelegates.jobs.getLoadedJobs()) {
            if (!includeActive && job == current) continue;
            synchronizeAction.accept(job);
        }
    }

    private synchronized void synchronizeTransformations(boolean includeActive, Consumer<TransMeta> synchronizeAction) {
        TransMeta current = this.spoon.getActiveTransformation();
        for (TransMeta trans : this.spoonDelegates.trans.getLoadedTransformations()) {
            if (!includeActive && trans == current) continue;
            synchronizeAction.accept(trans);
        }
    }

    private synchronized void synchronizeAll(boolean includeActive, Consumer<AbstractMeta> synchronizeAction) {
        EngineMetaInterface current = this.spoon.getActiveMeta();
        for (TransMeta transMeta : this.spoonDelegates.trans.getLoadedTransformations()) {
            if (!includeActive && transMeta == current) continue;
            synchronizeAction.accept((AbstractMeta)transMeta);
        }
        for (TransMeta transMeta : this.spoonDelegates.jobs.getLoadedJobs()) {
            if (!includeActive && transMeta == current) continue;
            synchronizeAction.accept((AbstractMeta)transMeta);
        }
    }

    public synchronized void synchronizeClusterSchemas(ClusterSchema clusterSchema) {
        this.synchronizeClusterSchemas(clusterSchema, clusterSchema.getName());
    }

    public synchronized void synchronizeClusterSchemas(ClusterSchema clusterSchema, String originalName) {
        if (clusterSchema.isShared()) {
            this.synchronizeTransformations(clusterSchema, this.clusterSchemaSynchronizationHandler, originalName);
        }
        if (clusterSchema.getObjectId() != null) {
            this.updateRepositoryObjects(clusterSchema, this.clusterSchemaSynchronizationHandler);
        }
    }

    public synchronized void synchronizePartitionSchemas(PartitionSchema partitionSchema) {
        this.synchronizePartitionSchemas(partitionSchema, partitionSchema.getName());
    }

    public synchronized void synchronizePartitionSchemas(PartitionSchema partitionSchema, String originalName) {
        if (partitionSchema.isShared()) {
            this.synchronizeTransformations(partitionSchema, this.partitionSchemaSynchronizationHandler, originalName);
        }
        if (partitionSchema.getObjectId() != null) {
            this.updateRepositoryObjects(partitionSchema, this.partitionSchemaSynchronizationHandler);
        }
    }

    public synchronized void synchronizeSteps(StepMeta step) {
        this.synchronizeSteps(step, step.getName());
    }

    public synchronized void synchronizeSteps(StepMeta step, String originalName) {
        if (!step.isShared()) {
            return;
        }
        this.synchronizeTransformations(step, this.stepMetaSynchronizationHandler, step.getName());
    }

    private void logError(KettleException e) {
        if (this.spoon.getLog() != null) {
            this.spoon.getLog().logError(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    private <T extends SharedObjectInterface> void synchronizeJobs(T sourceObject, SynchronizationHandler<T> handler, String originalName) {
        for (JobMeta currentJob : this.spoonDelegates.jobs.getLoadedJobs()) {
            List<T> objectsForSync = handler.getObjectsForSyncFromJob(currentJob);
            SharedObjectSyncUtil.synchronizeShared(sourceObject, originalName, objectsForSync, handler);
        }
    }

    private <T extends SharedObjectInterface> void synchronizeTransformations(T object, SynchronizationHandler<T> handler, String originalName) {
        for (TransMeta currentTransformation : this.spoonDelegates.trans.getLoadedTransformations()) {
            List<T> objectsForSync = handler.getObjectsForSyncFromTransformation(currentTransformation);
            SharedObjectSyncUtil.synchronizeShared(object, originalName, objectsForSync, handler);
        }
    }

    private static <T extends SharedObjectInterface> void synchronizeShared(T object, String name, List<T> objectsForSync, SynchronizationHandler<T> handler) {
        SharedObjectSyncUtil.synchronize(object, toSync -> toSync.isShared() && toSync.getName().equals(name), objectsForSync, handler);
    }

    private static <T extends SharedObjectInterface & RepositoryElementInterface> void synchronizeByObjectId(T object, List<T> objectsForSync, SynchronizationHandler<T> handler) {
        SharedObjectSyncUtil.synchronize(object, toSync -> ((RepositoryElementInterface)object).getObjectId().equals(((RepositoryElementInterface)toSync).getObjectId()), objectsForSync, handler);
    }

    private static <T extends SharedObjectInterface> void synchronize(T object, Predicate<T> pred, List<T> objectsForSync, SynchronizationHandler<T> handler) {
        for (SharedObjectInterface objectToSync : objectsForSync) {
            if (!pred.test(objectToSync) || object == objectToSync) continue;
            handler.doSynchronization(object, objectToSync);
        }
    }

    private static class StepMetaSynchronizationHandler
    implements SynchronizationHandler<StepMeta> {
        private StepMetaSynchronizationHandler() {
        }

        @Override
        public List<StepMeta> getObjectsForSyncFromJob(JobMeta job) {
            return Collections.emptyList();
        }

        @Override
        public List<StepMeta> getObjectsForSyncFromTransformation(TransMeta transformation) {
            return transformation.getSteps();
        }

        @Override
        public void doSynchronization(StepMeta source, StepMeta target) {
            target.replaceMeta(source);
        }
    }

    private static class PartitionSchemaSynchronizationHandler
    implements SynchronizationHandler<PartitionSchema> {
        private PartitionSchemaSynchronizationHandler() {
        }

        @Override
        public List<PartitionSchema> getObjectsForSyncFromJob(JobMeta job) {
            return Collections.emptyList();
        }

        @Override
        public List<PartitionSchema> getObjectsForSyncFromTransformation(TransMeta transformation) {
            return transformation.getPartitionSchemas();
        }

        @Override
        public void doSynchronization(PartitionSchema source, PartitionSchema target) {
            target.replaceMeta(source);
        }
    }

    private static class ClusterSchemaSynchronizationHandler
    implements SynchronizationHandler<ClusterSchema> {
        private ClusterSchemaSynchronizationHandler() {
        }

        @Override
        public List<ClusterSchema> getObjectsForSyncFromJob(JobMeta job) {
            return Collections.emptyList();
        }

        @Override
        public List<ClusterSchema> getObjectsForSyncFromTransformation(TransMeta transformation) {
            return transformation.getClusterSchemas();
        }

        @Override
        public void doSynchronization(ClusterSchema source, ClusterSchema target) {
            target.replaceMeta(source);
        }
    }

    private static class SlaveServerSynchronizationHandler
    implements SynchronizationHandler<SlaveServer> {
        private SlaveServerSynchronizationHandler() {
        }

        @Override
        public List<SlaveServer> getObjectsForSyncFromJob(JobMeta job) {
            return job.getSlaveServers();
        }

        @Override
        public List<SlaveServer> getObjectsForSyncFromTransformation(TransMeta transformation) {
            return transformation.getSlaveServers();
        }

        @Override
        public void doSynchronization(SlaveServer source, SlaveServer target) {
            target.replaceMeta(source);
        }
    }

    private static class ConnectionSynchronizationHandler
    implements SynchronizationHandler<DatabaseMeta> {
        private ConnectionSynchronizationHandler() {
        }

        @Override
        public List<DatabaseMeta> getObjectsForSyncFromJob(JobMeta job) {
            return job.getDatabases();
        }

        @Override
        public List<DatabaseMeta> getObjectsForSyncFromTransformation(TransMeta transformation) {
            return transformation.getDatabases();
        }

        @Override
        public void doSynchronization(DatabaseMeta source, DatabaseMeta target) {
            target.replaceMeta(source);
        }
    }

    protected static interface SynchronizationHandler<T extends SharedObjectInterface> {
        public List<T> getObjectsForSyncFromJob(JobMeta var1);

        public List<T> getObjectsForSyncFromTransformation(TransMeta var1);

        public void doSynchronization(T var1, T var2);
    }
}

