/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.repository.repositoryexplorer.model;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryDirectory;
import org.pentaho.di.repository.RepositoryElementMetaInterface;
import org.pentaho.di.repository.RepositoryObjectInterface;
import org.pentaho.di.repository.RepositoryObjectType;
import org.pentaho.di.ui.repository.repositoryexplorer.model.UIRepositoryDirectory;
import org.pentaho.di.ui.repository.repositoryexplorer.model.UIRepositoryObject;

public abstract class UIRepositoryContent
extends UIRepositoryObject {
    private static final long serialVersionUID = -1376494760112305976L;
    protected RepositoryElementMetaInterface rc;
    protected UIRepositoryDirectory uiParent;

    public UIRepositoryContent() {
    }

    public UIRepositoryContent(RepositoryElementMetaInterface rc, UIRepositoryDirectory parent, Repository rep) {
        super((RepositoryObjectInterface)rc, rep);
        this.rc = rc;
        this.uiParent = parent;
    }

    @Override
    public String getDescription() {
        return this.rc.getDescription();
    }

    @Override
    public Date getModifiedDate() {
        return this.rc.getModifiedDate();
    }

    @Override
    public String getModifiedUser() {
        return this.rc.getModifiedUser();
    }

    @Override
    public String getType() {
        return this.rc.getObjectType().name();
    }

    @Override
    public String getFormatModifiedDate() {
        Date date = this.rc.getModifiedDate();
        String str = null;
        if (date != null) {
            SimpleDateFormat sdf = new SimpleDateFormat("d MMM yyyy HH:mm:ss z");
            str = sdf.format(date);
        }
        return str;
    }

    public RepositoryDirectory getRepositoryDirectory() {
        return this.uiParent.getDirectory();
    }

    @Override
    public RepositoryObjectType getRepositoryElementType() {
        return this.rc.getObjectType();
    }

    @Override
    public void setName(String name) throws Exception {
        if (this.rc.getName().equalsIgnoreCase(name)) {
            return;
        }
        this.rc.setName(name);
    }

    @Override
    public String getImage() {
        return "";
    }

    @Override
    public void delete() throws Exception {
    }

    @Override
    public void move(UIRepositoryDirectory newParentDir) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getCategory() {
        return 20;
    }

    @Override
    public UIRepositoryDirectory getParent() {
        return this.uiParent;
    }
}

