/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.repository.dialog;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.IUser;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositorySecurityManager;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.core.gui.WindowProperty;
import org.pentaho.di.ui.repository.dialog.RepositoryDialogInterface;
import org.pentaho.di.ui.trans.step.BaseStepDialog;

public class UserDialog
extends Dialog {
    private static Class<?> PKG = RepositoryDialogInterface.class;
    private Shell shell;
    private Label wlLogin;
    private Label wlPassword;
    private Label wlUsername;
    private Label wlDescription;
    private Text wLogin;
    private Text wPassword;
    private Text wUsername;
    private Text wDescription;
    private Button wOK;
    private Button wCancel;
    private PropsUI props;
    private IUser userinfo;
    private boolean newUser = false;
    private RepositorySecurityManager securityManager;

    public UserDialog(Shell parent, int style, Repository repository, IUser userInfo) {
        super(parent, style);
        this.securityManager = repository.getSecurityManager();
        this.userinfo = userInfo;
        this.props = PropsUI.getInstance();
    }

    public IUser open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.shell.setImage(GUIResource.getInstance().getImageUser());
        int middle = this.props.getMiddlePct();
        int margin = 4;
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setText(BaseMessages.getString(PKG, (String)"UserDialog.Dialog.Main.Title", (String[])new String[0]));
        this.shell.setLayout((Layout)formLayout);
        this.wlLogin = new Label((Composite)this.shell, 131072);
        this.wlLogin.setText(BaseMessages.getString(PKG, (String)"UserDialog.Label.Login", (String[])new String[0]));
        this.props.setLook((Control)this.wlLogin);
        FormData fdlLogin = new FormData();
        fdlLogin.left = new FormAttachment(0, 0);
        fdlLogin.right = new FormAttachment(middle, -margin);
        fdlLogin.top = new FormAttachment(0, margin);
        this.wlLogin.setLayoutData((Object)fdlLogin);
        this.wLogin = new Text((Composite)this.shell, 18436);
        this.props.setLook((Control)this.wLogin);
        FormData fdLogin = new FormData();
        fdLogin.left = new FormAttachment(middle, 0);
        fdLogin.right = new FormAttachment(100, 0);
        fdLogin.top = new FormAttachment(0, margin);
        this.wLogin.setLayoutData((Object)fdLogin);
        this.wlPassword = new Label((Composite)this.shell, 131072);
        this.wlPassword.setText(BaseMessages.getString(PKG, (String)"UserDialog.Label.Password", (String[])new String[0]));
        this.props.setLook((Control)this.wlPassword);
        FormData fdlPassword = new FormData();
        fdlPassword.left = new FormAttachment(0, 0);
        fdlPassword.right = new FormAttachment(middle, -margin);
        fdlPassword.top = new FormAttachment((Control)this.wLogin, margin);
        this.wlPassword.setLayoutData((Object)fdlPassword);
        this.wPassword = new Text((Composite)this.shell, 0x404804);
        this.props.setLook((Control)this.wPassword);
        FormData fdPassword = new FormData();
        fdPassword.left = new FormAttachment(middle, 0);
        fdPassword.right = new FormAttachment(100, 0);
        fdPassword.top = new FormAttachment((Control)this.wLogin, margin);
        this.wPassword.setLayoutData((Object)fdPassword);
        this.wlUsername = new Label((Composite)this.shell, 131072);
        this.wlUsername.setText(BaseMessages.getString(PKG, (String)"UserDialog.Label.FullName", (String[])new String[0]));
        this.props.setLook((Control)this.wlUsername);
        FormData fdlUsername = new FormData();
        fdlUsername.left = new FormAttachment(0, 0);
        fdlUsername.right = new FormAttachment(middle, -margin);
        fdlUsername.top = new FormAttachment((Control)this.wPassword, margin);
        this.wlUsername.setLayoutData((Object)fdlUsername);
        this.wUsername = new Text((Composite)this.shell, 18436);
        this.props.setLook((Control)this.wUsername);
        FormData fdUsername = new FormData();
        fdUsername.left = new FormAttachment(middle, 0);
        fdUsername.right = new FormAttachment(100, 0);
        fdUsername.top = new FormAttachment((Control)this.wPassword, margin);
        this.wUsername.setLayoutData((Object)fdUsername);
        this.wlDescription = new Label((Composite)this.shell, 131072);
        this.wlDescription.setText(BaseMessages.getString(PKG, (String)"UserDialog.Label.Description", (String[])new String[0]));
        this.props.setLook((Control)this.wlDescription);
        FormData fdlDescription = new FormData();
        fdlDescription.left = new FormAttachment(0, 0);
        fdlDescription.right = new FormAttachment(middle, -margin);
        fdlDescription.top = new FormAttachment((Control)this.wUsername, margin);
        this.wlDescription.setLayoutData((Object)fdlDescription);
        this.wDescription = new Text((Composite)this.shell, 18436);
        this.props.setLook((Control)this.wDescription);
        FormData fdDescription = new FormData();
        fdDescription.left = new FormAttachment(middle, 0);
        fdDescription.right = new FormAttachment(100, 0);
        fdDescription.top = new FormAttachment((Control)this.wUsername, margin);
        this.wDescription.setLayoutData((Object)fdDescription);
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        FormData fdOK = new FormData();
        FormData fdCancel = new FormData();
        fdOK.left = new FormAttachment(45, 0);
        fdOK.top = new FormAttachment((Control)this.wDescription, 30);
        this.wOK.setLayoutData((Object)fdOK);
        fdCancel.left = new FormAttachment((Control)this.wOK, margin);
        fdCancel.top = new FormAttachment((Control)this.wDescription, 30);
        this.wCancel.setLayoutData((Object)fdCancel);
        this.wCancel.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                UserDialog.this.cancel();
            }
        });
        this.wOK.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                UserDialog.this.handleOK();
            }
        });
        SelectionAdapter selAdapter = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                UserDialog.this.handleOK();
            }
        };
        this.wLogin.addSelectionListener((SelectionListener)selAdapter);
        this.wPassword.addSelectionListener((SelectionListener)selAdapter);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                UserDialog.this.cancel();
            }
        });
        this.getData();
        BaseStepDialog.setSize(this.shell);
        if (this.userinfo.getObjectId() == null) {
            this.setNewUser(true);
        }
        this.shell.open();
        Display display = parent.getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.userinfo;
    }

    public void dispose() {
        this.props.setScreen(new WindowProperty(this.shell));
        this.shell.dispose();
    }

    public void getData() {
        if (this.userinfo.getLogin() != null) {
            this.wLogin.setText(this.userinfo.getLogin());
        }
        if (this.userinfo.getPassword() != null) {
            this.wPassword.setText(this.userinfo.getPassword());
        }
        if (this.userinfo.getUsername() != null) {
            this.wUsername.setText(this.userinfo.getUsername());
        }
        if (this.userinfo.getDescription() != null) {
            this.wDescription.setText(this.userinfo.getDescription());
        }
    }

    private void cancel() {
        this.userinfo = null;
        this.dispose();
    }

    public void handleOK() {
        try {
            ObjectId id;
            String login = this.wLogin.getText();
            if (login == null || login.length() == 0) {
                MessageBox mb = new MessageBox(this.shell, 33);
                mb.setMessage(BaseMessages.getString(PKG, (String)"UserDialog.Dialog.User.New.EmptyLogin.Message", (String[])new String[0]));
                mb.setText(BaseMessages.getString(PKG, (String)"UserDialog.Dialog.User.New.EmptyLogin.Title", (String[])new String[0]));
                mb.open();
                return;
            }
            if (this.isNewUser() && (id = this.securityManager.getUserID(login)) != null) {
                MessageBox mb = new MessageBox(this.shell, 33);
                mb.setMessage(BaseMessages.getString(PKG, (String)"UserDialog.Dialog.User.New.AlreadyExists.Message", (String[])new String[0]));
                mb.setText(BaseMessages.getString(PKG, (String)"UserDialog.Dialog.User.New.AlreadyExists.Title", (String[])new String[0]));
                mb.open();
                return;
            }
            this.userinfo.setLogin(login);
            this.userinfo.setPassword(this.wPassword.getText());
            this.userinfo.setUsername(this.wUsername.getText());
            this.userinfo.setDescription(this.wDescription.getText());
            this.securityManager.saveUserInfo(this.userinfo);
            this.dispose();
        }
        catch (KettleException e) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setMessage(BaseMessages.getString(PKG, (String)"UserDialog.Dialog.UnexpectedError.Message", (String[])new String[0]) + e.getMessage());
            mb.setText(BaseMessages.getString(PKG, (String)"UserDialog.Dialog.UnexpectedError.Title", (String[])new String[0]));
            mb.open();
        }
    }

    private void setNewUser(boolean flag) {
        this.newUser = flag;
    }

    private boolean isNewUser() {
        return this.newUser;
    }
}

