/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.repository;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.widgets.Shell;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleSecurityException;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.plugins.PluginInterface;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.RepositoryPluginType;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.RepositoriesMeta;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryMeta;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.core.dialog.EnterSelectionDialog;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.repository.dialog.RepositoryDialogInterface;
import org.pentaho.di.ui.repository.model.RepositoriesModel;
import org.pentaho.ui.xul.XulComponent;
import org.pentaho.ui.xul.components.XulConfirmBox;
import org.pentaho.ui.xul.dom.Document;
import org.pentaho.ui.xul.util.XulDialogCallback;

public class RepositoriesHelper {
    private static Class<?> PKG = RepositoriesHelper.class;
    private Shell shell;
    private PropsUI props = PropsUI.getInstance();
    private RepositoriesMeta input = new RepositoriesMeta();
    private Repository repository = null;
    private String prefRepositoryName;
    private RepositoriesModel model;
    private Document document;
    private LogChannel log;

    public RepositoriesHelper(RepositoriesModel model, Document document, Shell shell) {
        this.model = model;
        this.document = document;
        this.shell = shell;
        this.log = new LogChannel((Object)"RepositoriesHelper");
        try {
            try {
                this.input.readData();
                if (this.input.getErrorMessage() != null && this.input.getErrorMessage().length() > 0) {
                    throw new KettleException(this.input.getErrorMessage());
                }
            }
            catch (KettleException e) {
                this.log.logDetailed(BaseMessages.getString(PKG, (String)"RepositoryLogin.ErrorReadingRepositoryDefinitions", (String[])new String[]{e.getLocalizedMessage()}));
                new ErrorDialog(shell, BaseMessages.getString(PKG, (String)"Dialog.Error", (String[])new String[0]), BaseMessages.getString(PKG, (String)"RepositoryLogin.ErrorReadingRepositoryDefinitions", (String[])new String[]{e.getLocalizedMessage()}), (Exception)((Object)e));
            }
            ArrayList<RepositoryMeta> repositoryList = new ArrayList<RepositoryMeta>();
            for (int i = 0; i < this.input.nrRepositories(); ++i) {
                repositoryList.add(this.input.getRepository(i));
            }
            model.setAvailableRepositories(repositoryList);
        }
        catch (Exception e) {
            this.log.logDetailed(BaseMessages.getString(PKG, (String)"RepositoryLogin.ErrorReadingRepositoryDefinitions", (String[])new String[0]));
            new ErrorDialog(shell, BaseMessages.getString(PKG, (String)"Dialog.Error", (String[])new String[0]), BaseMessages.getString(PKG, (String)"RepositoryLogin.ErrorReadingRepositoryDefinitions", (String[])new String[0]), e);
        }
    }

    public void newRepository() {
        PluginRegistry registry = PluginRegistry.getInstance();
        Class<RepositoryPluginType> pluginType = RepositoryPluginType.class;
        List plugins = registry.getPlugins(pluginType);
        String[] names = new String[plugins.size()];
        for (int i = 0; i < names.length; ++i) {
            PluginInterface plugin = (PluginInterface)plugins.get(i);
            names[i] = plugin.getName() + " - " + plugin.getDescription();
        }
        EnterSelectionDialog selectRepositoryType = new EnterSelectionDialog(this.shell, names, BaseMessages.getString(PKG, (String)"RepositoryLogin.SelectRepositoryType", (String[])new String[0]), BaseMessages.getString(PKG, (String)"RepositoryLogin.SelectRepositoryTypeCreate", (String[])new String[0]));
        String choice = selectRepositoryType.openRepoDialog();
        if (choice != null) {
            int index = selectRepositoryType.getSelectionNr();
            PluginInterface plugin = (PluginInterface)plugins.get(index);
            String id = plugin.getIds()[0];
            try {
                RepositoryMeta repositoryMeta = (RepositoryMeta)PluginRegistry.getInstance().loadClass(RepositoryPluginType.class, id, RepositoryMeta.class);
                RepositoryDialogInterface dialog = this.getRepositoryDialog(plugin, repositoryMeta, this.input, this.shell);
                RepositoryMeta meta = dialog.open(RepositoryDialogInterface.MODE.ADD);
                if (meta != null && meta.getName() != null) {
                    this.input.addRepository(meta);
                    this.fillRepositories();
                    this.model.setSelectedRepository(meta);
                    this.writeData();
                }
            }
            catch (Exception e) {
                this.log.logDetailed(BaseMessages.getString(PKG, (String)"RepositoryLogin.ErrorCreatingRepository", (String[])new String[]{e.getLocalizedMessage()}));
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"Dialog.Error", (String[])new String[0]), BaseMessages.getString(PKG, (String)"RepositoryLogin.ErrorCreatingRepository", (String[])new String[]{e.getLocalizedMessage()}), e);
            }
        }
    }

    public void editRepository() {
        try {
            PluginInterface plugin = null;
            RepositoryMeta ri = this.input.searchRepository(this.model.getSelectedRepository().getName());
            if (ri != null && (plugin = PluginRegistry.getInstance().getPlugin(RepositoryPluginType.class, ri.getId())) == null) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"RepositoryLogin.ErrorFindingPlugin", (String[])new String[]{ri.getId()}));
            }
            RepositoryDialogInterface dd = this.getRepositoryDialog(plugin, ri, this.input, this.shell);
            if (dd.open(RepositoryDialogInterface.MODE.EDIT) != null) {
                this.fillRepositories();
                int idx = this.input.indexOfRepository(ri);
                this.model.setSelectedRepository(this.input.getRepository(idx));
                this.writeData();
            }
        }
        catch (Exception e) {
            this.log.logDetailed(BaseMessages.getString(PKG, (String)"RepositoryLogin.ErrorEditingRepository", (String[])new String[]{e.getLocalizedMessage()}));
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"Dialog.Error", (String[])new String[0]), BaseMessages.getString(PKG, (String)"RepositoryLogin.ErrorEditingRepository", (String[])new String[]{e.getLocalizedMessage()}), e);
        }
    }

    public void deleteRepository() {
        try {
            XulConfirmBox confirmBox = (XulConfirmBox)this.document.createElement("confirmbox");
            final RepositoryMeta repositoryMeta = this.input.searchRepository(this.model.getSelectedRepository().getName());
            if (repositoryMeta != null) {
                confirmBox.setTitle(BaseMessages.getString(PKG, (String)"RepositoryLogin.ConfirmDeleteRepositoryDialog.Title", (String[])new String[0]));
                confirmBox.setMessage(BaseMessages.getString(PKG, (String)"RepositoryLogin.ConfirmDeleteRepositoryDialog.Message", (String[])new String[0]));
                confirmBox.setAcceptLabel(BaseMessages.getString(PKG, (String)"Dialog.Ok", (String[])new String[0]));
                confirmBox.setCancelLabel(BaseMessages.getString(PKG, (String)"Dialog.Cancel", (String[])new String[0]));
                confirmBox.addDialogCallback((XulDialogCallback)new XulDialogCallback<Object>(){

                    public void onClose(XulComponent sender, XulDialogCallback.Status returnCode, Object retVal) {
                        if (returnCode == XulDialogCallback.Status.ACCEPT) {
                            int idx = RepositoriesHelper.this.input.indexOfRepository(repositoryMeta);
                            RepositoriesHelper.this.input.removeRepository(idx);
                            RepositoriesHelper.this.fillRepositories();
                            RepositoriesHelper.this.writeData();
                        }
                    }

                    public void onError(XulComponent sender, Throwable t) {
                        RepositoriesHelper.this.log.logDetailed(BaseMessages.getString((Class)PKG, (String)"RepositoryLogin.UnableToDeleteRepository", (String[])new String[]{t.getLocalizedMessage()}));
                        new ErrorDialog(RepositoriesHelper.this.shell, BaseMessages.getString((Class)PKG, (String)"Dialog.Error", (String[])new String[0]), BaseMessages.getString((Class)PKG, (String)"RepositoryLogin.UnableToDeleteRepository", (String[])new String[]{t.getLocalizedMessage()}), t);
                    }
                });
                confirmBox.open();
            }
        }
        catch (Exception e) {
            this.log.logDetailed(BaseMessages.getString(PKG, (String)"RepositoryLogin.UnableToDeleteRepository", (String[])new String[]{e.getLocalizedMessage()}));
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"Dialog.Error", (String[])new String[0]), BaseMessages.getString(PKG, (String)"RepositoryLogin.UnableToDeleteRepository", (String[])new String[]{e.getLocalizedMessage()}), e);
        }
    }

    protected RepositoryDialogInterface getRepositoryDialog(PluginInterface plugin, RepositoryMeta repositoryMeta, RepositoriesMeta input2, Shell shell) throws Exception {
        String className = repositoryMeta.getDialogClassName();
        Class dialogClass = (Class)PluginRegistry.getInstance().getClass(plugin, className);
        Constructor constructor = dialogClass.getConstructor(Shell.class, Integer.TYPE, RepositoryMeta.class, RepositoriesMeta.class);
        return (RepositoryDialogInterface)constructor.newInstance(shell, 0, repositoryMeta, this.input);
    }

    public void getMetaData() {
        this.fillRepositories();
        String repname = this.props.getLastRepository();
        if (repname != null) {
            this.model.setSelectedRepositoryUsingName(repname);
            String username = this.props.getLastRepositoryLogin();
            if (username != null) {
                this.model.setUsername(username);
            }
        }
        if (this.prefRepositoryName != null) {
            this.model.setSelectedRepositoryUsingName(this.prefRepositoryName);
        }
        this.model.setShowDialogAtStartup(this.props.showRepositoriesDialogAtStartup());
    }

    public void fillRepositories() {
        this.model.getAvailableRepositories().clear();
        if (this.input.nrRepositories() == 0) {
            this.model.addToAvailableRepositories(null);
        } else {
            for (int i = 0; i < this.input.nrRepositories(); ++i) {
                this.model.addToAvailableRepositories(this.input.getRepository(i));
            }
        }
    }

    public Repository getConnectedRepository() {
        return this.repository;
    }

    public void setPreferredRepositoryName(String repname) {
        this.prefRepositoryName = repname;
    }

    public void loginToRepository() throws KettleException, KettleSecurityException {
        if (this.model == null || this.model.getSelectedRepository() == null) {
            this.log.logDetailed(BaseMessages.getString(PKG, (String)"RepositoryLogin.ErrorLoginToRepository", (String[])new String[0]));
            throw new KettleException(BaseMessages.getString(PKG, (String)"RepositoryLogin.ErrorLoginToRepository", (String[])new String[0]));
        }
        RepositoryMeta repositoryMeta = this.input.getRepository(this.model.getRepositoryIndex(this.model.getSelectedRepository()));
        this.repository = (Repository)PluginRegistry.getInstance().loadClass(RepositoryPluginType.class, repositoryMeta.getId(), Repository.class);
        this.repository.init(repositoryMeta);
        this.repository.connect(this.model.getUsername(), this.model.getPassword());
        this.props.setLastRepository(repositoryMeta.getName());
        this.props.setLastRepositoryLogin(this.model.getUsername());
    }

    public void updateShowDialogOnStartup(boolean value) {
        this.props.setRepositoriesDialogAtStartupShown(value);
    }

    private void writeData() {
        try {
            this.input.writeData();
        }
        catch (Exception e) {
            this.log.logDetailed(BaseMessages.getString(PKG, (String)"RepositoryLogin.ErrorSavingRepositoryDefinition", (String[])new String[]{e.getLocalizedMessage()}));
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"Dialog.Error", (String[])new String[0]), BaseMessages.getString(PKG, (String)"RepositoryLogin.ErrorSavingRepositoryDefinition", (String[])new String[]{e.getLocalizedMessage()}), e);
        }
    }
}

