/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.job.entries.snmptrap;

import java.net.InetAddress;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entries.snmptrap.JobEntrySNMPTrap;
import org.pentaho.di.job.entry.JobEntryDialogInterface;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.ui.core.gui.WindowProperty;
import org.pentaho.di.ui.core.widget.LabelText;
import org.pentaho.di.ui.core.widget.LabelTextVar;
import org.pentaho.di.ui.core.widget.StyledTextComp;
import org.pentaho.di.ui.job.dialog.JobDialog;
import org.pentaho.di.ui.job.entry.JobEntryDialog;
import org.pentaho.di.ui.trans.step.BaseStepDialog;
import org.snmp4j.UserTarget;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.UdpAddress;

public class JobEntrySNMPTrapDialog
extends JobEntryDialog
implements JobEntryDialogInterface {
    private static Class<?> PKG = JobEntrySNMPTrap.class;
    private LabelText wName;
    private FormData fdName;
    private LabelTextVar wServerName;
    private FormData fdServerName;
    private LabelTextVar wTimeout;
    private FormData fdTimeout;
    private LabelTextVar wComString;
    private FormData fdComString;
    private LabelTextVar wUser;
    private FormData fdUser;
    private LabelTextVar wPassphrase;
    private FormData fdPassphrase;
    private LabelTextVar wEngineID;
    private FormData fdEngineID;
    private LabelTextVar wRetry;
    private FormData fdRetry;
    private Button wOK;
    private Button wCancel;
    private Listener lsOK;
    private Listener lsCancel;
    private JobEntrySNMPTrap jobEntry;
    private Shell shell;
    private SelectionAdapter lsDef;
    private boolean changed;
    private Group wServerSettings;
    private FormData fdServerSettings;
    private CTabFolder wTabFolder;
    private Composite wGeneralComp;
    private CTabItem wGeneralTab;
    private FormData fdGeneralComp;
    private FormData fdTabFolder;
    private FormData fdPort;
    private LabelTextVar wPort;
    private FormData fdOID;
    private LabelTextVar wOID;
    private Button wTest;
    private FormData fdTest;
    private Listener lsTest;
    private Group wAdvancedSettings;
    private FormData fdAdvancedSettings;
    private Group wMessageGroup;
    private FormData fdMessageGroup;
    private Label wlMessage;
    private StyledTextComp wMessage;
    private FormData fdlMessage;
    private FormData fdMessage;
    private Label wlTargetType;
    private CCombo wTargetType;
    private FormData fdlTargetType;
    private FormData fdTargetType;

    public JobEntrySNMPTrapDialog(Shell parent, JobEntryInterface jobEntryInt, Repository rep, JobMeta jobMeta) {
        super(parent, jobEntryInt, rep, jobMeta);
        this.jobEntry = (JobEntrySNMPTrap)jobEntryInt;
        if (this.jobEntry.getName() == null) {
            this.jobEntry.setName(BaseMessages.getString(PKG, (String)"JobSNMPTrap.Name.Default", (String[])new String[0]));
        }
    }

    public JobEntryInterface open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, this.props.getJobsDialogStyle());
        this.props.setLook((Control)this.shell);
        JobDialog.setShellImage(this.shell, (JobEntryInterface)this.jobEntry);
        ModifyListener lsMod = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JobEntrySNMPTrapDialog.this.jobEntry.setChanged();
            }
        };
        this.changed = this.jobEntry.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"JobSNMPTrap.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = 4;
        this.wName = new LabelText((Composite)this.shell, BaseMessages.getString(PKG, (String)"JobSNMPTrap.Name.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobSNMPTrap.Name.Tooltip", (String[])new String[0]));
        this.wName.addModifyListener(lsMod);
        this.fdName = new FormData();
        this.fdName.top = new FormAttachment(0, 0);
        this.fdName.left = new FormAttachment(0, 0);
        this.fdName.right = new FormAttachment(100, 0);
        this.wName.setLayoutData(this.fdName);
        this.wTabFolder = new CTabFolder((Composite)this.shell, 2048);
        this.props.setLook((Control)this.wTabFolder, 5);
        this.wGeneralTab = new CTabItem(this.wTabFolder, 0);
        this.wGeneralTab.setText(BaseMessages.getString(PKG, (String)"JobSNMPTrap.Tab.General.Label", (String[])new String[0]));
        this.wGeneralComp = new Composite((Composite)this.wTabFolder, 0);
        this.props.setLook((Control)this.wGeneralComp);
        FormLayout generalLayout = new FormLayout();
        generalLayout.marginWidth = 3;
        generalLayout.marginHeight = 3;
        this.wGeneralComp.setLayout((Layout)generalLayout);
        this.wServerSettings = new Group(this.wGeneralComp, 32);
        this.props.setLook((Control)this.wServerSettings);
        this.wServerSettings.setText(BaseMessages.getString(PKG, (String)"JobSNMPTrap.ServerSettings.Group.Label", (String[])new String[0]));
        FormLayout ServerSettingsgroupLayout = new FormLayout();
        ServerSettingsgroupLayout.marginWidth = 10;
        ServerSettingsgroupLayout.marginHeight = 10;
        this.wServerSettings.setLayout((Layout)ServerSettingsgroupLayout);
        this.wServerName = new LabelTextVar((VariableSpace)this.jobMeta, (Composite)this.wServerSettings, BaseMessages.getString(PKG, (String)"JobSNMPTrap.Server.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobSNMPTrap.Server.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wServerName);
        this.wServerName.addModifyListener(lsMod);
        this.fdServerName = new FormData();
        this.fdServerName.left = new FormAttachment(0, 0);
        this.fdServerName.top = new FormAttachment((Control)this.wName, margin);
        this.fdServerName.right = new FormAttachment(100, 0);
        this.wServerName.setLayoutData(this.fdServerName);
        this.wPort = new LabelTextVar((VariableSpace)this.jobMeta, (Composite)this.wServerSettings, BaseMessages.getString(PKG, (String)"JobSNMPTrap.Port.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobSNMPTrap.Port.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wPort);
        this.wPort.addModifyListener(lsMod);
        this.fdPort = new FormData();
        this.fdPort.left = new FormAttachment(0, 0);
        this.fdPort.top = new FormAttachment((Control)this.wServerName, margin);
        this.fdPort.right = new FormAttachment(100, 0);
        this.wPort.setLayoutData(this.fdPort);
        this.wOID = new LabelTextVar((VariableSpace)this.jobMeta, (Composite)this.wServerSettings, BaseMessages.getString(PKG, (String)"JobSNMPTrap.OID.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobSNMPTrap.OID.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wOID);
        this.wOID.addModifyListener(lsMod);
        this.fdOID = new FormData();
        this.fdOID.left = new FormAttachment(0, 0);
        this.fdOID.top = new FormAttachment((Control)this.wPort, margin);
        this.fdOID.right = new FormAttachment(100, 0);
        this.wOID.setLayoutData(this.fdOID);
        this.wTest = new Button((Composite)this.wServerSettings, 8);
        this.wTest.setText(BaseMessages.getString(PKG, (String)"JobSNMPTrap.TestConnection.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wTest);
        this.fdTest = new FormData();
        this.wTest.setToolTipText(BaseMessages.getString(PKG, (String)"JobSNMPTrap.TestConnection.Tooltip", (String[])new String[0]));
        this.fdTest.top = new FormAttachment((Control)this.wOID, margin);
        this.fdTest.right = new FormAttachment(100, 0);
        this.wTest.setLayoutData((Object)this.fdTest);
        this.fdServerSettings = new FormData();
        this.fdServerSettings.left = new FormAttachment(0, margin);
        this.fdServerSettings.top = new FormAttachment((Control)this.wName, margin);
        this.fdServerSettings.right = new FormAttachment(100, -margin);
        this.wServerSettings.setLayoutData((Object)this.fdServerSettings);
        this.wAdvancedSettings = new Group(this.wGeneralComp, 32);
        this.props.setLook((Control)this.wAdvancedSettings);
        this.wAdvancedSettings.setText(BaseMessages.getString(PKG, (String)"JobSNMPTrap.AdvancedSettings.Group.Label", (String[])new String[0]));
        FormLayout AdvancedSettingsgroupLayout = new FormLayout();
        AdvancedSettingsgroupLayout.marginWidth = 10;
        AdvancedSettingsgroupLayout.marginHeight = 10;
        this.wAdvancedSettings.setLayout((Layout)AdvancedSettingsgroupLayout);
        this.wlTargetType = new Label((Composite)this.wAdvancedSettings, 131072);
        this.wlTargetType.setText(BaseMessages.getString(PKG, (String)"JobSNMPTrap.TargetType.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlTargetType);
        this.fdlTargetType = new FormData();
        this.fdlTargetType.left = new FormAttachment(0, margin);
        this.fdlTargetType.right = new FormAttachment(middle, -margin);
        this.fdlTargetType.top = new FormAttachment((Control)this.wServerSettings, margin);
        this.wlTargetType.setLayoutData((Object)this.fdlTargetType);
        this.wTargetType = new CCombo((Composite)this.wAdvancedSettings, 2060);
        this.wTargetType.setItems(JobEntrySNMPTrap.target_type_Desc);
        this.props.setLook((Control)this.wTargetType);
        this.fdTargetType = new FormData();
        this.fdTargetType.left = new FormAttachment(middle, margin);
        this.fdTargetType.top = new FormAttachment((Control)this.wServerSettings, margin);
        this.fdTargetType.right = new FormAttachment(100, 0);
        this.wTargetType.setLayoutData((Object)this.fdTargetType);
        this.wTargetType.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JobEntrySNMPTrapDialog.this.CheckuseUserTarget();
            }
        });
        this.wComString = new LabelTextVar((VariableSpace)this.jobMeta, (Composite)this.wAdvancedSettings, BaseMessages.getString(PKG, (String)"JobSNMPTrap.ComString.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobSNMPTrap.ComString.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wComString);
        this.wComString.addModifyListener(lsMod);
        this.fdComString = new FormData();
        this.fdComString.left = new FormAttachment(0, 0);
        this.fdComString.top = new FormAttachment((Control)this.wTargetType, margin);
        this.fdComString.right = new FormAttachment(100, 0);
        this.wComString.setLayoutData(this.fdComString);
        this.wUser = new LabelTextVar((VariableSpace)this.jobMeta, (Composite)this.wAdvancedSettings, BaseMessages.getString(PKG, (String)"JobSNMPTrap.User.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobSNMPTrap.User.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wUser);
        this.wUser.addModifyListener(lsMod);
        this.fdUser = new FormData();
        this.fdUser.left = new FormAttachment(0, 0);
        this.fdUser.top = new FormAttachment((Control)this.wComString, margin);
        this.fdUser.right = new FormAttachment(100, 0);
        this.wUser.setLayoutData(this.fdUser);
        this.wPassphrase = new LabelTextVar((VariableSpace)this.jobMeta, (Composite)this.wAdvancedSettings, BaseMessages.getString(PKG, (String)"JobSNMPTrap.Passphrase.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobSNMPTrap.Passphrase.Tooltip", (String[])new String[0]), true);
        this.props.setLook((Control)this.wPassphrase);
        this.wPassphrase.addModifyListener(lsMod);
        this.fdPassphrase = new FormData();
        this.fdPassphrase.left = new FormAttachment(0, 0);
        this.fdPassphrase.top = new FormAttachment((Control)this.wUser, margin);
        this.fdPassphrase.right = new FormAttachment(100, 0);
        this.wPassphrase.setLayoutData(this.fdPassphrase);
        this.wEngineID = new LabelTextVar((VariableSpace)this.jobMeta, (Composite)this.wAdvancedSettings, BaseMessages.getString(PKG, (String)"JobSNMPTrap.EngineID.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobSNMPTrap.EngineID.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wEngineID);
        this.wEngineID.addModifyListener(lsMod);
        this.fdEngineID = new FormData();
        this.fdEngineID.left = new FormAttachment(0, 0);
        this.fdEngineID.top = new FormAttachment((Control)this.wPassphrase, margin);
        this.fdEngineID.right = new FormAttachment(100, 0);
        this.wEngineID.setLayoutData(this.fdEngineID);
        this.wRetry = new LabelTextVar((VariableSpace)this.jobMeta, (Composite)this.wAdvancedSettings, BaseMessages.getString(PKG, (String)"JobSNMPTrap.Retry.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobSNMPTrap.Retry.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wRetry);
        this.wRetry.addModifyListener(lsMod);
        this.fdRetry = new FormData();
        this.fdRetry.left = new FormAttachment(0, 0);
        this.fdRetry.top = new FormAttachment((Control)this.wEngineID, margin);
        this.fdRetry.right = new FormAttachment(100, 0);
        this.wRetry.setLayoutData(this.fdRetry);
        this.wTimeout = new LabelTextVar((VariableSpace)this.jobMeta, (Composite)this.wAdvancedSettings, BaseMessages.getString(PKG, (String)"JobSNMPTrap.Timeout.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobSNMPTrap.Timeout.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wTimeout);
        this.wTimeout.addModifyListener(lsMod);
        this.fdTimeout = new FormData();
        this.fdTimeout.left = new FormAttachment(0, 0);
        this.fdTimeout.top = new FormAttachment((Control)this.wRetry, margin);
        this.fdTimeout.right = new FormAttachment(100, 0);
        this.wTimeout.setLayoutData(this.fdTimeout);
        this.fdAdvancedSettings = new FormData();
        this.fdAdvancedSettings.left = new FormAttachment(0, margin);
        this.fdAdvancedSettings.top = new FormAttachment((Control)this.wServerSettings, margin);
        this.fdAdvancedSettings.right = new FormAttachment(100, -margin);
        this.wAdvancedSettings.setLayoutData((Object)this.fdAdvancedSettings);
        this.wMessageGroup = new Group(this.wGeneralComp, 32);
        this.props.setLook((Control)this.wMessageGroup);
        this.wMessageGroup.setText(BaseMessages.getString(PKG, (String)"JobSNMPTrap.MessageGroup.Group.Label", (String[])new String[0]));
        FormLayout MessageGroupgroupLayout = new FormLayout();
        MessageGroupgroupLayout.marginWidth = 10;
        MessageGroupgroupLayout.marginHeight = 10;
        this.wMessageGroup.setLayout((Layout)MessageGroupgroupLayout);
        this.wlMessage = new Label((Composite)this.wMessageGroup, 131072);
        this.wlMessage.setText(BaseMessages.getString(PKG, (String)"JobSNMPTrap.Message.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlMessage);
        this.fdlMessage = new FormData();
        this.fdlMessage.left = new FormAttachment(0, 0);
        this.fdlMessage.top = new FormAttachment((Control)this.wComString, margin);
        this.fdlMessage.right = new FormAttachment(middle, -margin);
        this.wlMessage.setLayoutData((Object)this.fdlMessage);
        this.wMessage = new StyledTextComp((VariableSpace)this.jobEntry, (Composite)this.wMessageGroup, 19202, "");
        this.props.setLook((Control)this.wMessage);
        this.wMessage.addModifyListener(lsMod);
        this.fdMessage = new FormData();
        this.fdMessage.left = new FormAttachment(middle, 0);
        this.fdMessage.top = new FormAttachment((Control)this.wComString, margin);
        this.fdMessage.right = new FormAttachment(100, -2 * margin);
        this.fdMessage.bottom = new FormAttachment(100, -margin);
        this.wMessage.setLayoutData(this.fdMessage);
        this.fdMessageGroup = new FormData();
        this.fdMessageGroup.left = new FormAttachment(0, margin);
        this.fdMessageGroup.top = new FormAttachment((Control)this.wAdvancedSettings, margin);
        this.fdMessageGroup.right = new FormAttachment(100, -margin);
        this.fdMessageGroup.bottom = new FormAttachment(100, -margin);
        this.wMessageGroup.setLayoutData((Object)this.fdMessageGroup);
        this.fdGeneralComp = new FormData();
        this.fdGeneralComp.left = new FormAttachment(0, 0);
        this.fdGeneralComp.top = new FormAttachment(0, 0);
        this.fdGeneralComp.right = new FormAttachment(100, 0);
        this.fdGeneralComp.bottom = new FormAttachment(100, 0);
        this.wGeneralComp.setLayoutData((Object)this.fdGeneralComp);
        this.wGeneralComp.layout();
        this.wGeneralTab.setControl((Control)this.wGeneralComp);
        this.props.setLook((Control)this.wGeneralComp);
        this.fdTabFolder = new FormData();
        this.fdTabFolder.left = new FormAttachment(0, 0);
        this.fdTabFolder.top = new FormAttachment((Control)this.wName, margin);
        this.fdTabFolder.right = new FormAttachment(100, 0);
        this.fdTabFolder.bottom = new FormAttachment(100, -50);
        this.wTabFolder.setLayoutData((Object)this.fdTabFolder);
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        BaseStepDialog.positionBottomButtons((Composite)this.shell, new Button[]{this.wOK, this.wCancel}, margin, (Control)this.wTabFolder);
        this.lsCancel = new Listener(){

            public void handleEvent(Event e) {
                JobEntrySNMPTrapDialog.this.cancel();
            }
        };
        this.lsOK = new Listener(){

            public void handleEvent(Event e) {
                JobEntrySNMPTrapDialog.this.ok();
            }
        };
        this.lsTest = new Listener(){

            public void handleEvent(Event e) {
                JobEntrySNMPTrapDialog.this.test();
            }
        };
        this.wCancel.addListener(13, this.lsCancel);
        this.wOK.addListener(13, this.lsOK);
        this.wTest.addListener(13, this.lsTest);
        this.lsDef = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                JobEntrySNMPTrapDialog.this.ok();
            }
        };
        this.wName.addSelectionListener((SelectionListener)this.lsDef);
        this.wServerName.addSelectionListener(this.lsDef);
        this.wTimeout.addSelectionListener(this.lsDef);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                JobEntrySNMPTrapDialog.this.cancel();
            }
        });
        this.getData();
        this.CheckuseUserTarget();
        this.wTabFolder.setSelection(0);
        BaseStepDialog.setSize(this.shell);
        this.shell.open();
        this.props.setDialogSize(this.shell, "JobSNMPTrapDialogSize");
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.jobEntry;
    }

    private void CheckuseUserTarget() {
        this.wComString.setEnabled(this.wTargetType.getSelectionIndex() == 0);
        this.wUser.setEnabled(this.wTargetType.getSelectionIndex() == 1);
        this.wPassphrase.setEnabled(this.wTargetType.getSelectionIndex() == 1);
        this.wEngineID.setEnabled(this.wTargetType.getSelectionIndex() == 1);
    }

    private void test() {
        MessageBox mb;
        boolean testOK = false;
        String errMsg = null;
        String hostname = this.jobMeta.environmentSubstitute(this.wServerName.getText());
        int nrPort = Const.toInt((String)this.jobMeta.environmentSubstitute("" + this.wPort.getText()), (int)JobEntrySNMPTrap.DEFAULT_PORT);
        try {
            UdpAddress udpAddress = new UdpAddress(InetAddress.getByName(hostname), nrPort);
            UserTarget usertarget = new UserTarget();
            usertarget.setAddress((Address)udpAddress);
            testOK = usertarget.getAddress().isValid();
            if (!testOK) {
                errMsg = BaseMessages.getString(PKG, (String)"JobSNMPTrap.CanNotGetAddress", (String[])new String[]{hostname});
            }
        }
        catch (Exception e) {
            errMsg = e.getMessage();
        }
        if (testOK) {
            mb = new MessageBox(this.shell, 34);
            mb.setMessage(BaseMessages.getString(PKG, (String)"JobSNMPTrap.Connected.OK", (String[])new String[]{hostname}) + Const.CR);
            mb.setText(BaseMessages.getString(PKG, (String)"JobSNMPTrap.Connected.Title.Ok", (String[])new String[0]));
            mb.open();
        } else {
            mb = new MessageBox(this.shell, 33);
            mb.setMessage(BaseMessages.getString(PKG, (String)"JobSNMPTrap.Connected.NOK.ConnectionBad", (String[])new String[]{hostname}) + Const.CR + errMsg + Const.CR);
            mb.setText(BaseMessages.getString(PKG, (String)"JobSNMPTrap.Connected.Title.Bad", (String[])new String[0]));
            mb.open();
        }
    }

    public void dispose() {
        WindowProperty winprop = new WindowProperty(this.shell);
        this.props.setScreen(winprop);
        this.shell.dispose();
    }

    public void getData() {
        this.wName.setText(Const.nullToEmpty((String)this.jobEntry.getName()));
        this.wServerName.setText(Const.NVL((String)this.jobEntry.getServerName(), (String)""));
        this.wPort.setText(this.jobEntry.getPort());
        this.wOID.setText(Const.NVL((String)this.jobEntry.getOID(), (String)""));
        this.wTimeout.setText("" + this.jobEntry.getTimeout());
        this.wRetry.setText("" + this.jobEntry.getRetry());
        this.wComString.setText(Const.NVL((String)this.jobEntry.getComString(), (String)""));
        this.wMessage.setText(Const.NVL((String)this.jobEntry.getMessage(), (String)""));
        this.wTargetType.setText(this.jobEntry.getTargetTypeDesc(this.jobEntry.getTargetType()));
        this.wUser.setText(Const.NVL((String)this.jobEntry.getUser(), (String)""));
        this.wPassphrase.setText(Const.NVL((String)this.jobEntry.getPassPhrase(), (String)""));
        this.wEngineID.setText(Const.NVL((String)this.jobEntry.getEngineID(), (String)""));
        this.wName.selectAll();
        this.wName.setFocus();
    }

    private void cancel() {
        this.jobEntry.setChanged(this.changed);
        this.jobEntry = null;
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wName.getText())) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setText(BaseMessages.getString(PKG, (String)"System.StepJobEntryNameMissing.Title", (String[])new String[0]));
            mb.setMessage(BaseMessages.getString(PKG, (String)"System.JobEntryNameMissing.Msg", (String[])new String[0]));
            mb.open();
            return;
        }
        this.jobEntry.setName(this.wName.getText());
        this.jobEntry.setPort(this.wPort.getText());
        this.jobEntry.setServerName(this.wServerName.getText());
        this.jobEntry.setOID(this.wOID.getText());
        this.jobEntry.setTimeout(this.wTimeout.getText());
        this.jobEntry.setRetry(this.wTimeout.getText());
        this.jobEntry.setComString(this.wComString.getText());
        this.jobEntry.setMessage(this.wMessage.getText());
        this.jobEntry.setTargetType(this.wTargetType.getText());
        this.jobEntry.setUser(this.wUser.getText());
        this.jobEntry.setPassPhrase(this.wPassphrase.getText());
        this.jobEntry.setEngineID(this.wEngineID.getText());
        this.dispose();
    }

    public boolean evaluates() {
        return true;
    }

    public boolean isUnconditional() {
        return false;
    }
}

