/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.core.widget;

import com.google.common.base.Preconditions;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.ui.core.FormDataBuilder;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.core.widget.PasswordTextVar;
import org.pentaho.di.ui.core.widget.TextVar;

public class AuthComposite
extends Composite {
    private final PropsUI props;
    private final ModifyListener lsMod;
    private final TransMeta transMeta;
    private String authGroupLabel;
    private Group wAuthGroup;
    private String usernameLabel;
    private Label wlUsername;
    private TextVar wUsername;
    private String passwordLabel;
    private Label wlPassword;
    private TextVar wPassword;

    public AuthComposite(Composite composite, int style, PropsUI props, ModifyListener lsMod, TransMeta transMeta, String credentialGroupName, String usernameLabel, String passwordLabel) {
        super(composite, style);
        Preconditions.checkNotNull((Object)((Object)props));
        Preconditions.checkNotNull((Object)lsMod);
        Preconditions.checkNotNull((Object)transMeta);
        this.props = props;
        this.lsMod = lsMod;
        this.transMeta = transMeta;
        this.authGroupLabel = credentialGroupName;
        this.usernameLabel = usernameLabel;
        this.passwordLabel = passwordLabel;
        this.layoutComposite();
    }

    private void layoutComposite() {
        FormLayout flAuthComp = new FormLayout();
        this.setLayout((Layout)flAuthComp);
        this.wAuthGroup = new Group((Composite)this, 16);
        this.props.setLook((Control)this.wAuthGroup);
        this.wAuthGroup.setText(this.authGroupLabel);
        FormLayout flAuthGroup = new FormLayout();
        flAuthGroup.marginHeight = 15;
        flAuthGroup.marginWidth = 15;
        this.wAuthGroup.setLayout((Layout)flAuthGroup);
        this.wAuthGroup.setLayoutData((Object)new FormDataBuilder().fullSize().result());
        this.wlUsername = new Label((Composite)this.wAuthGroup, 16384);
        this.props.setLook((Control)this.wlUsername);
        this.wlUsername.setText(this.usernameLabel);
        this.wlUsername.setLayoutData((Object)new FormDataBuilder().left().top().result());
        this.wUsername = new TextVar((VariableSpace)this.transMeta, (Composite)this.wAuthGroup, 18436);
        this.props.setLook((Control)this.wUsername);
        this.wUsername.addModifyListener(this.lsMod);
        this.wUsername.setLayoutData(new FormDataBuilder().top((Control)this.wlUsername).left().width(350).result());
        this.wlPassword = new Label((Composite)this.wAuthGroup, 16384);
        this.props.setLook((Control)this.wlPassword);
        this.wlPassword.setText(this.passwordLabel);
        this.wlPassword.setLayoutData((Object)new FormDataBuilder().left().top((Control)this.wUsername, 10).result());
        this.wPassword = new PasswordTextVar((VariableSpace)this.transMeta, (Composite)this.wAuthGroup, 18436);
        this.props.setLook((Control)this.wPassword);
        this.wPassword.addModifyListener(this.lsMod);
        this.wPassword.setLayoutData(new FormDataBuilder().left().top((Control)this.wlPassword).width(350).result());
    }

    public String getUsername() {
        return this.wUsername.getText();
    }

    public String getPassword() {
        return this.wPassword.getText();
    }

    public void setUsername(String username) {
        this.wUsername.setText(username);
    }

    public void setPassword(String password) {
        this.wPassword.setText(password);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.wAuthGroup.setVisible(visible);
        this.wlUsername.setVisible(visible);
        this.wUsername.setVisible(visible);
        this.wlPassword.setVisible(visible);
        this.wPassword.setVisible(visible);
    }
}

