/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.exam.options;

import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.exam.MavenUtils;
import org.ops4j.pax.exam.options.MavenUrlReference;

public class MavenArtifactUrlReference
implements MavenUrlReference {
    private String groupId;
    private String artifactId;
    private String type;
    private String version;
    private String classifier;

    @Override
    public MavenArtifactUrlReference groupId(String _groupId) {
        NullArgumentException.validateNotEmpty((String)_groupId, (boolean)true, (String)"Group");
        this.groupId = _groupId;
        return this;
    }

    @Override
    public MavenArtifactUrlReference artifactId(String _artifactId) {
        NullArgumentException.validateNotEmpty((String)_artifactId, (boolean)true, (String)"Artifact");
        this.artifactId = _artifactId;
        return this;
    }

    @Override
    public MavenArtifactUrlReference type(String _type) {
        NullArgumentException.validateNotEmpty((String)_type, (boolean)true, (String)"Type");
        this.type = _type;
        return this;
    }

    @Override
    public MavenUrlReference classifier(String _classifier) {
        NullArgumentException.validateNotEmpty((String)_classifier, (boolean)true, (String)"Classifier");
        this.classifier = _classifier;
        return this;
    }

    @Override
    public MavenArtifactUrlReference version(String _version) {
        NullArgumentException.validateNotEmpty((String)_version, (boolean)true, (String)"Version");
        this.version = _version;
        return this;
    }

    @Override
    public MavenArtifactUrlReference version(MavenUrlReference.VersionResolver _resolver) {
        NullArgumentException.validateNotNull((Object)_resolver, (String)"Version resolver");
        return this.version(_resolver.getVersion(this.groupId, this.artifactId));
    }

    @Override
    public MavenArtifactUrlReference versionAsInProject() {
        return this.version(MavenUtils.asInProject());
    }

    @Override
    public Boolean isSnapshot() {
        return this.version == null ? null : Boolean.valueOf(this.version.endsWith("SNAPSHOT"));
    }

    @Override
    public String getURL() {
        NullArgumentException.validateNotEmpty((String)this.groupId, (boolean)true, (String)"Group");
        NullArgumentException.validateNotEmpty((String)this.artifactId, (boolean)true, (String)"Artifact");
        StringBuilder url = new StringBuilder();
        url.append("mvn:").append(this.groupId).append("/").append(this.artifactId);
        if (this.version != null || this.type != null || this.classifier != null) {
            url.append("/");
        }
        if (this.version != null) {
            url.append(this.version);
        }
        if (this.type != null || this.classifier != null) {
            url.append("/");
        }
        if (this.type != null) {
            url.append(this.type);
        }
        if (this.classifier != null) {
            url.append("/").append(this.classifier);
        }
        return url.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append("{groupId='").append(this.groupId).append('\'');
        sb.append(", artifactId='").append(this.artifactId).append('\'');
        sb.append(", version='").append(this.version).append('\'');
        sb.append(", type='").append(this.type).append('\'');
        sb.append('}');
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.artifactId == null ? 0 : this.artifactId.hashCode());
        result = 31 * result + (this.classifier == null ? 0 : this.classifier.hashCode());
        result = 31 * result + (this.groupId == null ? 0 : this.groupId.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MavenArtifactUrlReference other = (MavenArtifactUrlReference)obj;
        if (this.artifactId == null ? other.artifactId != null : !this.artifactId.equals(other.artifactId)) {
            return false;
        }
        if (this.classifier == null ? other.classifier != null : !this.classifier.equals(other.classifier)) {
            return false;
        }
        if (this.groupId == null ? other.groupId != null : !this.groupId.equals(other.groupId)) {
            return false;
        }
        if (this.type == null ? other.type != null : !this.type.equals(other.type)) {
            return false;
        }
        return !(this.version == null ? other.version != null : !this.version.equals(other.version));
    }
}

