/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.getxmldata;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.steps.getxmldata.GetXMLDataField;
import org.pentaho.di.trans.steps.getxmldata.GetXMLDataMeta;
import org.pentaho.metaverse.api.IAnalysisContext;
import org.pentaho.metaverse.api.IMetaverseNode;
import org.pentaho.metaverse.api.IMetaverseObjectFactory;
import org.pentaho.metaverse.api.MetaverseAnalyzerException;
import org.pentaho.metaverse.api.MetaverseException;
import org.pentaho.metaverse.api.StepField;
import org.pentaho.metaverse.api.analyzer.kettle.ComponentDerivationRecord;
import org.pentaho.metaverse.api.analyzer.kettle.step.ExternalResourceStepAnalyzer;
import org.pentaho.metaverse.api.model.IExternalResourceInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetXMLDataStepAnalyzer
extends ExternalResourceStepAnalyzer<GetXMLDataMeta> {
    private Logger log = LoggerFactory.getLogger(GetXMLDataStepAnalyzer.class);

    protected Set<StepField> getUsedFields(GetXMLDataMeta meta) {
        HashSet<StepField> usedFields = new HashSet<StepField>();
        if (meta.isInFields()) {
            Set stepFields = this.createStepFields(meta.getXMLField(), this.getInputs());
            usedFields.addAll(stepFields);
        }
        return usedFields;
    }

    public Set<Class<? extends BaseStepMeta>> getSupportedSteps() {
        return new HashSet<Class<? extends BaseStepMeta>>(){
            {
                this.add(GetXMLDataMeta.class);
            }
        };
    }

    protected IMetaverseNode createOutputFieldNode(IAnalysisContext context, ValueMetaInterface fieldMeta, String targetStepName, String nodeType) {
        GetXMLDataField[] fields;
        IMetaverseNode fieldNode = super.createOutputFieldNode(context, fieldMeta, targetStepName, nodeType);
        for (GetXMLDataField field : fields = ((GetXMLDataMeta)this.baseStepMeta).getInputFields()) {
            if (!fieldMeta.getName().equals(field.getName())) continue;
            fieldNode.setProperty("xpath", (Object)Const.NVL((String)field.getXPath(), (String)""));
            fieldNode.setProperty("element", (Object)Const.NVL((String)field.getElementTypeCode(), (String)""));
            fieldNode.setProperty("resultType", (Object)Const.NVL((String)field.getResultTypeCode(), (String)""));
            fieldNode.setProperty("repeat", (Object)field.isRepeated());
            break;
        }
        return fieldNode;
    }

    protected Map<String, RowMetaInterface> getInputRowMetaInterfaces(GetXMLDataMeta meta) {
        HashMap<String, RowMetaInterface> inputRows = this.getInputFields(meta);
        if (inputRows == null) {
            inputRows = new HashMap<String, RowMetaInterface>();
        }
        boolean isInFields = meta.isInFields();
        boolean isAFile = meta.getIsAFile();
        boolean isAUrl = meta.isReadUrl();
        if (!isInFields || isAFile || isAUrl) {
            RowMetaInterface stepFields = this.getOutputFields(meta);
            RowMetaInterface clone = stepFields.clone();
            for (RowMetaInterface rowMetaInterface : inputRows.values()) {
                for (ValueMetaInterface valueMetaInterface : rowMetaInterface.getValueMetaList()) {
                    try {
                        clone.removeValueMeta(valueMetaInterface.getName());
                    }
                    catch (KettleValueException kettleValueException) {}
                }
            }
            inputRows.put("_resource_", clone);
        }
        return inputRows;
    }

    public Set<ComponentDerivationRecord> getChangeRecords(GetXMLDataMeta meta) throws MetaverseAnalyzerException {
        HashSet<ComponentDerivationRecord> changes = new HashSet<ComponentDerivationRecord>();
        boolean isInFields = meta.isInFields();
        boolean isAFile = meta.getIsAFile();
        boolean isAUrl = meta.isReadUrl();
        if (isInFields && !isAFile && !isAUrl) {
            GetXMLDataField[] fields = ((GetXMLDataMeta)this.baseStepMeta).getInputFields();
            if (this.getInputs() != null) {
                Set inputFields = this.getInputs().getFieldNames();
                for (StepField inputField : inputFields) {
                    if (!inputField.getFieldName().equals(meta.getXMLField())) continue;
                    for (GetXMLDataField field : fields) {
                        ComponentDerivationRecord change = new ComponentDerivationRecord(meta.getXMLField(), field.getName());
                        changes.add(change);
                    }
                }
            }
        }
        return changes;
    }

    protected void customAnalyze(GetXMLDataMeta meta, IMetaverseNode node) throws MetaverseAnalyzerException {
        super.customAnalyze((BaseStepMeta)meta, node);
        node.setProperty("loopXPath", (Object)meta.getLoopXPath());
    }

    public IMetaverseNode createResourceNode(IExternalResourceInfo resource) throws MetaverseException {
        return this.createFileNode(resource.getName(), this.descriptor);
    }

    public String getResourceInputNodeType() {
        return "File Field";
    }

    public String getResourceOutputNodeType() {
        return null;
    }

    public boolean isOutput() {
        return false;
    }

    public boolean isInput() {
        return true;
    }

    protected void setObjectFactory(IMetaverseObjectFactory factory) {
        this.metaverseObjectFactory = factory;
    }

    protected void setRootNode(IMetaverseNode node) {
        this.rootNode = node;
    }

    protected void setBaseStepMeta(GetXMLDataMeta meta) {
        this.baseStepMeta = meta;
    }

    protected void setParentTransMeta(TransMeta tm) {
        this.parentTransMeta = tm;
    }

    protected void setParentStepMeta(StepMeta sm) {
        this.parentStepMeta = sm;
    }
}

