/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.web.servlet;

import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.pentaho.platform.api.engine.ILogger;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.util.StringUtil;
import org.pentaho.platform.util.logging.Logger;

public abstract class ServletBase
extends HttpServlet
implements ILogger {
    public static final boolean debug = true;
    static String ORIGIN_HEADER = "origin";
    static String CORS_ALLOW_ORIGIN_HEADER = "Access-Control-Allow-Origin";
    static String CORS_ALLOW_CREDENTIALS_HEADER = "Access-Control-Allow-Credentials";
    private int loggingLevel = 5;

    protected IPentahoSession getPentahoSession(HttpServletRequest request) {
        return PentahoSessionHolder.getSession();
    }

    public abstract Log getLogger();

    public String getObjectName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public int getLoggingLevel() {
        return this.loggingLevel;
    }

    public void setLoggingLevel(int logLevel) {
        this.loggingLevel = logLevel;
    }

    public void trace(String message) {
        if (this.loggingLevel <= 1) {
            this.getLogger().trace((Object)message);
        }
    }

    public void debug(String message) {
        if (this.loggingLevel <= 2) {
            this.getLogger().debug((Object)message);
        }
    }

    public void info(String message) {
        if (this.loggingLevel <= 3) {
            this.getLogger().info((Object)message);
        }
    }

    public void warn(String message) {
        if (this.loggingLevel <= 4) {
            this.getLogger().warn((Object)message);
        }
    }

    public void error(String message) {
        if (this.loggingLevel <= 5) {
            this.getLogger().error((Object)message);
        }
    }

    public void fatal(String message) {
        if (this.loggingLevel <= 6) {
            this.getLogger().fatal((Object)message);
        }
    }

    public void trace(String message, Throwable error) {
        if (this.loggingLevel <= 1) {
            this.getLogger().trace((Object)message, error);
            Logger.addException((Throwable)error);
        }
    }

    public void debug(String message, Throwable error) {
        if (this.loggingLevel <= 2) {
            this.getLogger().debug((Object)message, error);
            Logger.addException((Throwable)error);
        }
    }

    public void info(String message, Throwable error) {
        if (this.loggingLevel <= 3) {
            this.getLogger().info((Object)message, error);
            Logger.addException((Throwable)error);
        }
    }

    public void warn(String message, Throwable error) {
        if (this.loggingLevel <= 4) {
            this.getLogger().warn((Object)message, error);
            Logger.addException((Throwable)error);
        }
    }

    public void error(String message, Throwable error) {
        if (this.loggingLevel <= 5) {
            this.getLogger().error((Object)message, error);
            Logger.addException((Throwable)error);
        }
    }

    public void fatal(String message, Throwable error) {
        if (this.loggingLevel <= 6) {
            this.getLogger().fatal((Object)message, error);
            Logger.addException((Throwable)error);
        }
    }

    public void setCorsHeaders(HttpServletRequest request, HttpServletResponse response) {
        if (!this.isCorsRequestsAllowed()) {
            return;
        }
        String origin = request.getHeader(ORIGIN_HEADER);
        if (this.isCorsRequestOriginAllowed(origin)) {
            response.setHeader(CORS_ALLOW_ORIGIN_HEADER, origin);
            response.setHeader(CORS_ALLOW_CREDENTIALS_HEADER, "true");
        }
    }

    private boolean isCorsRequestsAllowed() {
        String isCorsAllowed = this.getCorsRequestsAllowedSystemProperty();
        return "true".equals(isCorsAllowed);
    }

    private List<String> getCorsRequestsAllowedDomains() {
        String allowedDomains = this.getCorsAllowedDomainsSystemProperty();
        boolean hasDomains = !StringUtil.isEmpty((String)allowedDomains);
        return hasDomains ? Arrays.asList(allowedDomains.split("\\s*,\\s*")) : null;
    }

    private boolean isCorsRequestOriginAllowed(String domain) {
        List<String> allowedDomains = this.getCorsRequestsAllowedDomains();
        return allowedDomains != null && allowedDomains.contains(domain);
    }

    String getCorsRequestsAllowedSystemProperty() {
        return PentahoSystem.getSystemSetting((String)"cors-requests-allowed", (String)"false");
    }

    String getCorsAllowedDomainsSystemProperty() {
        return PentahoSystem.getSystemSetting((String)"cors-requests-allowed-domains", null);
    }
}

