/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.web.servlet;

import com.google.common.annotations.VisibleForTesting;
import com.sun.jersey.api.container.ContainerException;
import com.sun.jersey.api.container.MappableContainerException;
import com.sun.jersey.api.core.ResourceConfig;
import com.sun.jersey.server.impl.ThreadLocalInvoker;
import com.sun.jersey.server.probes.UriRuleProbeProvider;
import com.sun.jersey.spi.MessageBodyWorkers;
import com.sun.jersey.spi.container.ContainerRequest;
import com.sun.jersey.spi.container.ContainerResponse;
import com.sun.jersey.spi.container.ContainerResponseWriter;
import com.sun.jersey.spi.container.WebApplication;
import com.sun.jersey.spi.container.servlet.ServletContainer;
import com.sun.jersey.spi.container.servlet.WebComponent;
import com.sun.jersey.spi.container.servlet.WebConfig;
import com.sun.jersey.spi.container.servlet.WebServletConfig;
import com.sun.jersey.spi.spring.container.servlet.SpringServlet;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.security.Principal;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.core.system.objfac.spring.PentahoBeanScopeValidatorPostProcessor;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.core.AuthenticationException;
import org.springframework.web.context.support.XmlWebApplicationContext;

public class JAXRSServlet
extends SpringServlet {
    private static final long serialVersionUID = 457538570048660945L;
    private static final Log logger = LogFactory.getLog(JAXRSServlet.class);
    public static final String MIME_TYPE = "mime-type";
    public static final String GET_HEADERS = "getHeaders";
    public static final String SET_STATUS = "setStatus";
    public static final String ACCEPT = "accept";
    public static final String GET = "GET";
    protected boolean SendEmptyEntityForServicesFlag;

    protected ConfigurableApplicationContext getContext() {
        return (ConfigurableApplicationContext)this.getAppContext();
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String mimeType;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("servicing request for resource " + request.getPathInfo()));
        }
        if (request.getMethod().equals(GET) && (mimeType = request.getParameter(MIME_TYPE)) != null) {
            final HttpServletRequest originalRequest = request;
            request = (HttpServletRequest)Proxy.newProxyInstance(((Object)((Object)this)).getClass().getClassLoader(), new Class[]{HttpServletRequest.class}, new InvocationHandler(){

                @Override
                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    if (method.getName().equals(JAXRSServlet.GET_HEADERS) && args.length > 0 && args[0].equals(JAXRSServlet.ACCEPT)) {
                        return new Enumeration(){
                            boolean hasMore = true;

                            @Override
                            public boolean hasMoreElements() {
                                return this.hasMore;
                            }

                            public Object nextElement() {
                                this.hasMore = false;
                                return mimeType;
                            }
                        };
                    }
                    return method.invoke((Object)originalRequest, args);
                }
            });
        }
        super.service(request, response);
    }

    public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
        super.service(req, res);
    }

    protected void initiate(ResourceConfig rc, WebApplication wa) {
        if (logger.isDebugEnabled()) {
            rc.getFeatures().put("com.sun.jersey.config.feature.Trace", true);
            rc.getFeatures().put("com.sun.jersey.config.feature.TracePerRequest", true);
        }
        this.callSuperInitiate(rc, wa);
        if (logger.isDebugEnabled()) {
            MessageBodyWorkers messageBodyWorkers = wa.getMessageBodyWorkers();
            Map writers = messageBodyWorkers == null ? null : messageBodyWorkers.getWriters(MediaType.WILDCARD_TYPE);
            logger.debug((Object)("Writers: " + writers));
        }
    }

    @VisibleForTesting
    protected void callSuperInitiate(ResourceConfig rc, WebApplication wa) {
        super.initiate(rc, wa);
    }

    @VisibleForTesting
    protected ApplicationContext getAppContext() {
        XmlWebApplicationContext wac = new XmlWebApplicationContext(){

            protected Resource getResourceByPath(String path) {
                return new FileSystemResource(new File(path));
            }
        };
        wac.setServletContext(this.getServletContext());
        wac.setServletConfig(this.getServletConfig());
        wac.setNamespace(this.getServletName());
        String springFile = PentahoSystem.getApplicationContext().getSolutionPath("system" + File.separator + "pentahoServices.spring.xml");
        wac.setConfigLocations(new String[]{springFile});
        wac.addBeanFactoryPostProcessor((BeanFactoryPostProcessor)new PentahoBeanScopeValidatorPostProcessor());
        wac.refresh();
        return wac;
    }

    public void init() throws ServletException {
        this.SendEmptyEntityForServicesFlag = Boolean.parseBoolean(PentahoSystem.getSystemSetting((String)"pentaho.xml", (String)"set-empty-entity-rest-services", (String)"true"));
        Application app = (Application)JAXRSServlet.getPrivate("app", ServletContainer.class, (Object)this);
        InternalWebComponent component = app == null ? new InternalWebComponent() : new InternalWebComponent(app);
        JAXRSServlet.setPrivate("webComponent", ServletContainer.class, (Object)this, (Object)component, false);
        WebServletConfig webConfig = this.createWebConfig((ServletContainer)this);
        component.init((WebConfig)webConfig);
    }

    @VisibleForTesting
    protected WebServletConfig createWebConfig(ServletContainer container) {
        return new WebServletConfig(container);
    }

    private static Object getPrivate(String nameField, Class classOfField, Object fromObj) throws ServletException {
        Field field = null;
        try {
            field = classOfField.getDeclaredField(nameField);
            field.setAccessible(true);
            return field.get(fromObj);
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    private static void setPrivate(String nameField, Class classOfField, Object fromObj, Object value, boolean finalFlag) throws ServletException {
        Field field = null;
        try {
            field = classOfField.getDeclaredField(nameField);
            field.setAccessible(true);
            if (finalFlag) {
                Field modifiersField = Field.class.getDeclaredField("modifiers");
                modifiersField.setAccessible(true);
                modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
            }
            field.set(fromObj, value);
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    private static void runPrivate(String methodName, Class classOfField, Class<?>[] parameterTypes, Object fromObj, Object ... args) throws ServletException {
        try {
            Method m = classOfField.getDeclaredMethod(methodName, parameterTypes);
            m.setAccessible(true);
            m.invoke(fromObj, args);
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    private class BackwardCompatibleWriter
    extends OutputStream
    implements ContainerResponseWriter {
        final HttpServletResponse response;
        ContainerResponse cResponse;
        long contentLength;
        OutputStream out;
        boolean statusAndHeadersWritten = false;

        BackwardCompatibleWriter(HttpServletResponse response) {
            this.response = response;
        }

        public OutputStream writeStatusAndHeaders(long contentLength, ContainerResponse cResponse) throws IOException {
            this.contentLength = contentLength;
            this.cResponse = cResponse;
            this.statusAndHeadersWritten = false;
            return this;
        }

        public void finish() throws IOException {
            if (this.statusAndHeadersWritten) {
                return;
            }
            this.writeHeaders();
            this.writeStatus();
        }

        private void writeStatus() throws IOException {
            Response.StatusType statusType = this.cResponse.getStatusType();
            String reasonPhrase = statusType.getReasonPhrase();
            if (!JAXRSServlet.this.SendEmptyEntityForServicesFlag && (statusType.getFamily().equals((Object)Response.Status.Family.CLIENT_ERROR) || statusType.getFamily().equals((Object)Response.Status.Family.SERVER_ERROR))) {
                if (reasonPhrase == null || reasonPhrase.isEmpty()) {
                    this.response.sendError(this.cResponse.getStatus());
                } else {
                    this.response.sendError(this.cResponse.getStatus(), reasonPhrase);
                }
            } else if (reasonPhrase != null) {
                this.response.setStatus(statusType.getStatusCode(), reasonPhrase);
            } else {
                this.response.setStatus(statusType.getStatusCode());
            }
        }

        @Override
        public void write(int b) throws IOException {
            this.initiate();
            this.out.write(b);
        }

        @Override
        public void write(byte[] b) throws IOException {
            if (b.length > 0) {
                this.initiate();
                this.out.write(b);
            }
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            if (len > 0) {
                this.initiate();
                this.out.write(b, off, len);
            }
        }

        @Override
        public void flush() throws IOException {
            this.writeStatusAndHeaders();
            if (this.out != null) {
                this.out.flush();
            }
        }

        @Override
        public void close() throws IOException {
            this.initiate();
            this.out.close();
        }

        void initiate() throws IOException {
            if (this.out == null) {
                this.writeStatusAndHeaders();
                this.out = this.response.getOutputStream();
            }
        }

        void writeStatusAndHeaders() throws IOException {
            if (this.statusAndHeadersWritten) {
                return;
            }
            this.writeHeaders();
            this.writeStatus();
            this.statusAndHeadersWritten = true;
        }

        void writeHeaders() {
            if (this.contentLength != -1L && this.contentLength < Integer.MAX_VALUE) {
                this.response.setContentLength((int)this.contentLength);
            }
            MultivaluedMap headers = this.cResponse.getHttpHeaders();
            for (Map.Entry e : headers.entrySet()) {
                for (Object v : (List)e.getValue()) {
                    this.response.addHeader((String)e.getKey(), ContainerResponse.getHeaderValue(v));
                }
            }
        }
    }

    class InternalWebComponent
    extends WebComponent {
        InternalWebComponent() {
        }

        InternalWebComponent(Application app) {
            super(app);
        }

        protected WebApplication create() {
            return JAXRSServlet.this.create();
        }

        protected void configure(WebConfig wc, ResourceConfig rc, WebApplication wa) {
            super.configure(wc, rc, wa);
            JAXRSServlet.this.configure(wc, rc, wa);
        }

        protected void initiate(ResourceConfig rc, WebApplication wa) {
            JAXRSServlet.this.initiate(rc, wa);
        }

        protected ResourceConfig getDefaultResourceConfig(Map<String, Object> props, WebConfig wc) throws ServletException {
            return JAXRSServlet.this.getDefaultResourceConfig(props, wc);
        }

        public int service(URI baseUri, URI requestUri, final HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            WebApplication _application = (WebApplication)JAXRSServlet.getPrivate("application", WebComponent.class, (Object)this);
            ContainerRequest cRequest = this.createRequest(_application, request, baseUri, requestUri);
            cRequest.setSecurityContext(new SecurityContext(){

                public Principal getUserPrincipal() {
                    return request.getUserPrincipal();
                }

                public boolean isUserInRole(String role) {
                    return request.isUserInRole(role);
                }

                public boolean isSecure() {
                    return request.isSecure();
                }

                public String getAuthenticationScheme() {
                    return request.getAuthType();
                }
            });
            try {
                this.runFilterFormParameters(request, cRequest);
                UriRuleProbeProvider.requestStart((URI)requestUri);
                this.runRequestInvokerSet(request);
                this.runResponseInvokerSet(response);
                BackwardCompatibleWriter w = new BackwardCompatibleWriter(response);
                _application.handleRequest(cRequest, (ContainerResponseWriter)w);
                int n = w.cResponse.getStatus();
                return n;
            }
            catch (WebApplicationException ex) {
                Response exResponse = ex.getResponse();
                String entity = exResponse.getEntity() != null ? exResponse.getEntity().toString() : null;
                response.sendError(exResponse.getStatus(), entity);
                int n = exResponse.getStatus();
                return n;
            }
            catch (AccessDeniedException ex) {
                response.sendError(Response.Status.FORBIDDEN.getStatusCode());
                int n = Response.Status.FORBIDDEN.getStatusCode();
                return n;
            }
            catch (AuthenticationException ex) {
                response.sendError(Response.Status.FORBIDDEN.getStatusCode());
                int n = Response.Status.FORBIDDEN.getStatusCode();
                return n;
            }
            catch (MappableContainerException ex) {
                this.runTraceOnException(cRequest, response);
                throw new ServletException(ex.getCause());
            }
            catch (ContainerException ex) {
                this.runTraceOnException(cRequest, response);
                throw new ServletException((Throwable)ex);
            }
            catch (RuntimeException ex) {
                this.runTraceOnException(cRequest, response);
                throw ex;
            }
            finally {
                UriRuleProbeProvider.requestEnd();
                this.runRequestInvokerSet(null);
                this.runResponseInvokerSet(null);
            }
        }

        private void runTraceOnException(ContainerRequest cRequest, HttpServletResponse response) throws ServletException {
            JAXRSServlet.runPrivate("traceOnException", WebComponent.class, new Class[]{ContainerRequest.class, HttpServletResponse.class}, (Object)this, new Object[]{cRequest, response});
        }

        private void runFilterFormParameters(HttpServletRequest request, ContainerRequest cRequest) throws ServletException {
            JAXRSServlet.runPrivate("filterFormParameters", WebComponent.class, new Class[]{HttpServletRequest.class, ContainerRequest.class}, (Object)this, new Object[]{request, cRequest});
        }

        private void runRequestInvokerSet(HttpServletRequest request) throws ServletException {
            ((ThreadLocalInvoker)JAXRSServlet.getPrivate("requestInvoker", WebComponent.class, (Object)this)).set((Object)request);
        }

        private void runResponseInvokerSet(HttpServletResponse response) throws ServletException {
            ((ThreadLocalInvoker)JAXRSServlet.getPrivate("responseInvoker", WebComponent.class, (Object)this)).set((Object)response);
        }
    }
}

