/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.web.http.request;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.pentaho.platform.engine.core.solution.SimpleParameterProvider;
import org.pentaho.platform.util.web.HttpUtil;

public class HttpRequestParameterProvider
extends SimpleParameterProvider {
    private HttpServletRequest request;

    public HttpRequestParameterProvider(HttpServletRequest request) {
        this.request = request;
        this.setServletRequestParameters(request.getParameterMap());
        if (request.getParameter("_PENTAHO_ADDITIONAL_PARAMS_") != null) {
            String additionalParameters = request.getParameter("_PENTAHO_ADDITIONAL_PARAMS_");
            int idx = additionalParameters.indexOf("?");
            if (idx > 0) {
                additionalParameters = additionalParameters.substring(idx + 1);
            }
            Map additionalParms = HttpUtil.parseQueryString((String)additionalParameters);
            this.setServletRequestParameters(additionalParms);
        }
    }

    private void setServletRequestParameters(Map paramMap) {
        for (Map.Entry entry : paramMap.entrySet()) {
            Object value = entry.getValue();
            if (value == null) continue;
            if (value instanceof Object[] && ((Object[])value).length == 1) {
                this.setParameter((String)entry.getKey(), String.valueOf(((Object[])value)[0]));
                continue;
            }
            this.setParameter((String)entry.getKey(), value);
        }
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }
}

