/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.web.http.filters;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRegistration;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.concurrent.ConcurrentException;
import org.apache.commons.lang3.concurrent.LazyInitializer;
import org.owasp.encoder.Encode;
import org.pentaho.platform.api.engine.IApplicationContext;
import org.pentaho.platform.api.engine.ICacheManager;
import org.pentaho.platform.api.engine.IPentahoRequestContext;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.IPluginManager;
import org.pentaho.platform.api.usersettings.IUserSettingService;
import org.pentaho.platform.engine.core.system.PentahoRequestContextHolder;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.repository2.ClientRepositoryPaths;
import org.pentaho.platform.repository2.unified.jcr.JcrRepositoryFileUtils;
import org.pentaho.platform.util.messages.LocaleHelper;
import org.pentaho.platform.web.http.ConfigurationAdminNonOsgiProxy;

public class PentahoWebContextFilter
implements Filter {
    public static final String WEB_CONTEXT_JS = "webcontext.js";
    public static final String PARAM_SSO_ENABLED = "ssoEnabled";
    private static final String REQUIREJS_LOCATION = "content/common-ui/resources/web/require.js";
    private static final String REQUIREJS_CONFIG_LOCATION = "content/common-ui/resources/web/require-cfg.js";
    private static final String REQUIREJS_INIT_LOCATION = "osgi/requirejs-manager/js/require-init.js";
    static final String DEFAULT_OSGI_BRIDGE = "osgi/";
    static final String DEFAULT_SERVICES_ROOT = "cxf/";
    static final String PLATFORM_OSGI_BRIDGE_ID = "proxy";
    private static final String SERVICES_PERSISTENCE_ID = "org.apache.cxf.osgi";
    private static final String SERVICES_CONTEXT_PROPERTY = "org.apache.cxf.servlet.context";
    static final String USE_FULL_URL_PARAM = "useFullyQualifiedUrl";
    static final String FILTER_APPLIED = "__pentaho_web_context_filter_applied";
    static final String initialComment = "/** webcontext.js is created by a PentahoWebContextFilter. This filter searches for an incoming URI having \"webcontext.js\" in it. If it finds that, it write CONTEXT_PATH and FULLY_QUALIFIED_SERVER_URL and it values from the servlet request to this js **/ \n\n\n";
    static final byte[] initialCommentBytes = "/** webcontext.js is created by a PentahoWebContextFilter. This filter searches for an incoming URI having \"webcontext.js\" in it. If it finds that, it write CONTEXT_PATH and FULLY_QUALIFIED_SERVER_URL and it values from the servlet request to this js **/ \n\n\n".getBytes();
    private static final String JS = ".js";
    private static final String CSS = ".css";
    private static final String CONTEXT = "context";
    private static final String APPLICATION = "application";
    private static final String GLOBAL = "global";
    private static final String REQUIRE_JS = "requirejs";
    private String ssoEnabled = null;
    private static final ThreadLocal<byte[]> THREAD_LOCAL_REQUIRE_SCRIPT = new ThreadLocal();
    protected static ICacheManager cache = PentahoSystem.getCacheManager(null);
    private LazyInitializer<String> lazyServicesPath;
    private ConfigurationAdminNonOsgiProxy configurationAdminProxy;

    public void init(FilterConfig filterConfig) throws ServletException {
        this.configurationAdminProxy = new ConfigurationAdminNonOsgiProxy();
        this.lazyServicesPath = new LazyInitializer<String>(){

            protected String initialize() throws ConcurrentException {
                return PentahoWebContextFilter.this.initializeServicesPath();
            }
        };
        this.setSsoEnabled(filterConfig.getInitParameter(PARAM_SSO_ENABLED));
    }

    public void destroy() {
    }

    protected void close(OutputStream out) {
        try {
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        boolean isWebContextJSRequest;
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        String requestStr = httpRequest.getRequestURI();
        boolean bl = isWebContextJSRequest = requestStr != null && requestStr.endsWith(WEB_CONTEXT_JS);
        if (isWebContextJSRequest && httpRequest.getAttribute(FILTER_APPLIED) == null) {
            httpRequest.setAttribute(FILTER_APPLIED, (Object)Boolean.TRUE);
            try {
                boolean requireJsOnly;
                response.setContentType("text/javascript");
                ServletOutputStream out = response.getOutputStream();
                HashMap<String, String> webContextVariables = this.getWebContextVariables(httpRequest);
                out.write(initialCommentBytes);
                this.printWebContextVar((OutputStream)out, webContextVariables, "CONTEXT_PATH");
                this.printWebContextVar((OutputStream)out, webContextVariables, "FULL_QUALIFIED_URL");
                this.printWebContextVar((OutputStream)out, webContextVariables, "SERVER_PROTOCOL");
                this.printWebContextVar((OutputStream)out, webContextVariables, "PENTAHO_CONTEXT_NAME");
                this.printWebContextVar((OutputStream)out, webContextVariables, "active_theme");
                this.printWebContextVar((OutputStream)out, webContextVariables, "requireCfg", false, false);
                if (this.getSsoEnabled() != null) {
                    this.printWebContextVar((OutputStream)out, webContextVariables, PARAM_SSO_ENABLED, false, false);
                }
                this.printPentahoEnvironmentConfig((OutputStream)out, webContextVariables);
                this.printResourcesForContext(REQUIRE_JS, (OutputStream)out, httpRequest, false);
                byte[] requireScriptBytes = THREAD_LOCAL_REQUIRE_SCRIPT.get();
                if (requireScriptBytes == null) {
                    this.printDocumentWrite((OutputStream)out, REQUIREJS_LOCATION);
                    this.printDocumentWrite((OutputStream)out, REQUIREJS_CONFIG_LOCATION);
                } else {
                    out.write(requireScriptBytes);
                }
                this.printWebContextVar((OutputStream)out, webContextVariables, "SESSION_NAME");
                this.printWebContextVar((OutputStream)out, webContextVariables, "SESSION_LOCALE");
                this.printLocaleModule((OutputStream)out, webContextVariables);
                this.printWebContextVar((OutputStream)out, webContextVariables, "HOME_FOLDER");
                this.printWebContextVar((OutputStream)out, webContextVariables, "RESERVED_CHARS");
                this.printWebContextVar((OutputStream)out, webContextVariables, "RESERVED_CHARS_DISPLAY");
                this.printWebContextVar((OutputStream)out, webContextVariables, "RESERVED_CHARS_REGEX_PATTERN", true, false);
                boolean noOsgiRequireConfig = "true".equals(request.getParameter("noOsgiRequireConfig"));
                if (!noOsgiRequireConfig && !"anonymousUser".equals(this.getSession().getName())) {
                    String useFullyQualifiedUrlParameter = httpRequest.getParameter(USE_FULL_URL_PARAM);
                    String requireInitSrc = "osgi/requirejs-manager/js/require-init.js?requirejs=false" + (useFullyQualifiedUrlParameter != null ? "&useFullyQualifiedUrl=" + useFullyQualifiedUrlParameter : "");
                    this.printDocumentWrite((OutputStream)out, requireInitSrc);
                }
                if (!(requireJsOnly = "true".equals(request.getParameter("requireJsOnly")))) {
                    this.printResourcesForContext(GLOBAL, (OutputStream)out, httpRequest, false);
                    boolean cssOnly = "true".equals(request.getParameter("cssOnly"));
                    String contextName = this.getContextNameVar(httpRequest);
                    if (StringUtils.isNotEmpty((String)contextName)) {
                        this.printResourcesForContext(contextName, (OutputStream)out, httpRequest, cssOnly);
                    }
                }
                this.addCustomInfo((OutputStream)out);
                out.close();
                return;
            }
            finally {
                httpRequest.removeAttribute(FILTER_APPLIED);
            }
        }
        chain.doFilter((ServletRequest)httpRequest, (ServletResponse)httpResponse);
    }

    Integer getRequireWaitTime() {
        Integer waitTime = null;
        if (cache != null) {
            waitTime = (Integer)cache.getFromGlobalCache((Object)"waitSeconds");
        }
        if (waitTime == null) {
            try {
                waitTime = Integer.valueOf(PentahoSystem.getSystemSetting((String)"waitSeconds", (String)"30"));
            }
            catch (NumberFormatException e) {
                waitTime = 30;
            }
            if (cache != null) {
                cache.putInGlobalCache((Object)"waitSeconds", (Object)waitTime);
            }
        }
        return waitTime;
    }

    private String getActiveThemeVar(HttpServletRequest request) {
        IPentahoSession session = this.getSession();
        String activeTheme = (String)session.getAttribute("pentaho-user-theme");
        String ua = request.getHeader("User-Agent");
        if (StringUtils.isNotEmpty((String)ua) && ua.matches(".*(?i)(iPad|iPod|iPhone|Android).*")) {
            activeTheme = PentahoSystem.getSystemSetting((String)"default-theme", (String)"ruby");
        }
        if (activeTheme == null) {
            IUserSettingService settingsService = this.getUserSettingsService();
            try {
                activeTheme = settingsService.getUserSetting("pentaho-user-theme", null).getSettingValue();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (activeTheme == null) {
                activeTheme = PentahoSystem.getSystemSetting((String)"default-theme", (String)"ruby");
            }
        }
        return activeTheme;
    }

    HashMap<String, String> getWebContextVariables(HttpServletRequest request) throws IOException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("requireCfg", this.getRequireCfgVar());
        map.put(PARAM_SSO_ENABLED, this.getSsoEnabled());
        map.put(APPLICATION, this.getApplicationVar(request));
        map.put("PENTAHO_CONTEXT_NAME", this.getContextNameVar(request));
        map.put("FULL_QUALIFIED_URL", this.getFullyQualifiedServerUrlVar());
        map.put("CONTEXT_PATH", this.getContextPathVar(request));
        map.put("SERVER_PROTOCOL", this.getServerProtocolVar());
        map.put("active_theme", this.getActiveThemeVar(request));
        map.put("SESSION_LOCALE", this.getLocaleVar(request));
        map.put("SESSION_NAME", this.getSessionNameVar());
        map.put("HOME_FOLDER", this.getHomeFolderVar());
        map.put("RESERVED_CHARS", this.getReservedCharsVar());
        map.put("RESERVED_CHARS_DISPLAY", this.getReservedCharsDisplayVar());
        map.put("RESERVED_CHARS_REGEX_PATTERN", this.getReservedRegexPatternVar());
        map.put(PLATFORM_OSGI_BRIDGE_ID, this.getOsgiBridgePath(request));
        map.put(SERVICES_CONTEXT_PROPERTY, this.getServicesPath());
        return map;
    }

    private String getLocaleVar(HttpServletRequest request) {
        String requestLocale = request.getParameter("locale");
        boolean hasLocaleParam = StringUtils.isNotEmpty((String)requestLocale);
        return hasLocaleParam ? requestLocale : LocaleHelper.getLocale().toString();
    }

    private String getSessionNameVar() {
        if (this.getSession() == null) {
            return null;
        }
        return this.getSession().getName();
    }

    private String getHomeFolderVar() {
        if (this.getSession() == null) {
            return null;
        }
        String sessionName = this.getSession().getName();
        return ClientRepositoryPaths.getUserHomeFolderPath((String)sessionName);
    }

    private String getReservedCharsVar() {
        StringBuilder sb = new StringBuilder();
        for (char c : this.getRepositoryReservedChars()) {
            sb.append(c);
        }
        return sb.toString();
    }

    private String getReservedCharsDisplayVar() {
        List reservedCharacters = JcrRepositoryFileUtils.getReservedChars();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < reservedCharacters.size(); ++i) {
            if (((Character)reservedCharacters.get(i)).charValue() >= '\u0007' && ((Character)reservedCharacters.get(i)).charValue() <= '\r') {
                sb.append(StringEscapeUtils.escapeJava((String)("" + reservedCharacters.get(i))));
            } else {
                sb.append(reservedCharacters.get(i));
            }
            if (i + 1 >= reservedCharacters.size()) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    private String getReservedRegexPatternVar() {
        return "/" + PentahoWebContextFilter.makeReservedCharPattern() + "/";
    }

    private String getContextNameVar(HttpServletRequest request) {
        return request.getParameter(CONTEXT);
    }

    private String getApplicationVar(HttpServletRequest request) {
        return request.getParameter(APPLICATION);
    }

    private String getFullyQualifiedServerUrlVar() {
        String fullyQualifiedServerURL = this.getApplicationContext().getFullyQualifiedServerURL();
        if (!fullyQualifiedServerURL.endsWith("/")) {
            fullyQualifiedServerURL = fullyQualifiedServerURL + "/";
        }
        return fullyQualifiedServerURL;
    }

    private String getContextPathVar(HttpServletRequest request) {
        IPentahoRequestContext requestContext = this.getRequestContext();
        String contextPath = requestContext.getContextPath();
        boolean shouldUseFullyQualifiedUrl = this.shouldUseFullyQualifiedUrl(request);
        if (shouldUseFullyQualifiedUrl) {
            contextPath = this.getFullyQualifiedServerUrlVar();
        }
        return contextPath;
    }

    private String getServerProtocolVar() {
        String fullyQualifiedServerURL = this.getFullyQualifiedServerUrlVar();
        if (fullyQualifiedServerURL.startsWith("http")) {
            return fullyQualifiedServerURL.substring(0, fullyQualifiedServerURL.indexOf(":"));
        }
        return "http";
    }

    private String getRequireCfgVar() {
        StringBuilder requireCfg = new StringBuilder();
        requireCfg.append("{").append("\n  waitSeconds: ").append(this.getRequireWaitTime()).append(",").append("\n  paths: {},").append("\n  shim: {},").append("\n  map: {\"*\": {}},").append("\n  bundles: {},").append("\n  config: {\"pentaho/modules\": {}},").append("\n  packages: []").append("\n}");
        return requireCfg.toString();
    }

    private void printResourcesForContext(String contextName, OutputStream out, HttpServletRequest request, boolean printCssOnly) throws IOException {
        IPluginManager pluginManager = this.getPluginManager();
        String reqStr = "";
        Map paramMap = request.getParameterMap();
        if (paramMap.size() > 0) {
            StringBuilder sb = new StringBuilder();
            Map.Entry me2 = null;
            int sep = 63;
            for (Map.Entry me2 : paramMap.entrySet()) {
                for (int i = 0; i < ((String[])me2.getValue()).length; ++i) {
                    sb.append((char)sep).append(Encode.forJavaScript((String)((String)me2.getKey()).toString())).append("=").append(Encode.forJavaScript((String)((String[])me2.getValue())[i]));
                }
                if (sep != 63) continue;
                sep = 38;
            }
            reqStr = sb.toString();
        }
        List externalResources = pluginManager.getExternalResourcesForContext(contextName);
        out.write(("\n<!-- Injecting web resources defined in by plugins as external-resources for: " + Encode.forHtml((String)contextName) + "-->").getBytes());
        if (externalResources != null) {
            for (String res : externalResources) {
                if (res == null) continue;
                if (res.endsWith(JS) && !printCssOnly) {
                    out.write(("\ndocument.write(\"<script language='javascript' type='text/javascript' src='\" + CONTEXT_PATH + \"" + res.trim() + reqStr + "'></scr\"+\"ipt>\");").getBytes());
                    continue;
                }
                if (!res.endsWith(CSS)) continue;
                out.write(("\ndocument.write(\"<link rel='stylesheet' type='text/css' href='\" + CONTEXT_PATH + \"" + res.trim() + reqStr + "'/>\");").getBytes());
            }
        }
    }

    private void printWebContextVar(OutputStream out, HashMap<String, String> webContextVariables, String variable) throws IOException {
        this.printWebContextVar(out, webContextVariables, variable, true, true);
    }

    private void printWebContextVar(OutputStream out, HashMap<String, String> webContextVariables, String variable, boolean deprecated, boolean escapeValue) throws IOException {
        String value = webContextVariables.get(variable);
        if (escapeValue) {
            value = this.escapeEnvironmentVar(value);
        }
        String deprecatedComment = deprecated ? "\n/** @deprecated - use 'pentaho/environment' module's variable instead */" : "";
        StringBuilder environmentVariable = new StringBuilder(deprecatedComment);
        environmentVariable.append("\nvar ").append(variable).append(" = ").append(value).append(";\n");
        out.write(environmentVariable.toString().getBytes("UTF-8"));
    }

    private void printLocaleModule(OutputStream out, HashMap<String, String> webContextVariables) throws IOException {
        String value = this.escapeEnvironmentVar(webContextVariables.get("SESSION_LOCALE"));
        StringBuilder localeModule = new StringBuilder("// If RequireJs is available, supply a module");
        localeModule.append("\nif (typeof(pen) !== 'undefined' && pen.define) {").append("\n  pen.define('Locale', {locale: ").append(value).append(" });").append("\n}\n");
        out.write(localeModule.toString().getBytes("UTF-8"));
    }

    private void printPentahoEnvironmentConfig(OutputStream out, HashMap<String, String> webContextVariables) throws IOException {
        String application = this.escapeEnvironmentVar(webContextVariables.get(APPLICATION));
        String theme = this.escapeEnvironmentVar(webContextVariables.get("active_theme"));
        String locale = this.escapeEnvironmentVar(webContextVariables.get("SESSION_LOCALE"));
        String userID = this.escapeEnvironmentVar(webContextVariables.get("SESSION_NAME"));
        String userHome = this.escapeEnvironmentVar(webContextVariables.get("HOME_FOLDER"));
        String reservedChars = this.escapeEnvironmentVar(webContextVariables.get("RESERVED_CHARS"));
        String serverRoot = this.escapeEnvironmentVar(this.getServerRoot(webContextVariables));
        String serverPackages = this.escapeEnvironmentVar(this.getServerPackages(webContextVariables));
        String serverServices = this.escapeEnvironmentVar(this.getServerServices(webContextVariables));
        StringBuilder environmentModule = new StringBuilder("\n// configuration for 'pentaho/environment' amd module");
        environmentModule.append("\nrequireCfg.config[\"pentaho/environment\"] = {").append("\n  application: ").append(application).append(",").append("\n  theme: ").append(theme).append(",").append("\n  locale: ").append(locale).append(",").append("\n  user: {").append("\n    id: ").append(userID).append(",").append("\n    home: ").append(userHome).append("\n  },").append("\n  reservedChars: ").append(reservedChars).append(",").append("\n  server: {").append("\n    root: ").append(serverRoot).append(",").append("\n    packages: ").append(serverPackages).append(",").append("\n    services: ").append(serverServices).append("\n  }").append("\n};\n");
        out.write(environmentModule.toString().getBytes("UTF-8"));
    }

    private void printDocumentWrite(OutputStream out, String location) throws IOException {
        String script = "\ndocument.write(\"<script type='text/javascript' src='\" + CONTEXT_PATH + \"" + location + "'></scr\"+\"ipt>\");\n";
        out.write(script.getBytes("UTF-8"));
    }

    private String getServicesPath() {
        try {
            return (String)this.lazyServicesPath.get();
        }
        catch (ConcurrentException ce) {
            return DEFAULT_SERVICES_ROOT;
        }
    }

    private String getOsgiBridgePath(HttpServletRequest request) {
        String osgiBridgeMapping = "";
        ServletContext servletContext = request.getServletContext();
        ServletRegistration osgiBridgeRegistration = servletContext.getServletRegistration(PLATFORM_OSGI_BRIDGE_ID);
        if (osgiBridgeRegistration != null) {
            boolean hasMappings;
            Collection osgiBridgeMappings = osgiBridgeRegistration.getMappings();
            boolean bl = hasMappings = osgiBridgeMappings != null && osgiBridgeMappings.size() > 0;
            if (hasMappings) {
                osgiBridgeMapping = (String)osgiBridgeMappings.toArray()[0];
            }
        }
        if (StringUtils.isEmpty((String)osgiBridgeMapping)) {
            osgiBridgeMapping = DEFAULT_OSGI_BRIDGE;
        }
        return this.normalizeURL(osgiBridgeMapping);
    }

    private String escapeEnvironmentVar(String value) {
        if (value != null) {
            value = "\"" + StringEscapeUtils.escapeJavaScript((String)value) + "\"";
        }
        return value;
    }

    private String normalizeURL(String url) {
        boolean isUrlValid = StringUtils.isNotEmpty((String)url);
        if (isUrlValid && url.startsWith("/")) {
            url = url.substring(1);
        }
        if (isUrlValid && url.endsWith("*")) {
            int urlLength = url.length();
            url = url.substring(0, urlLength - 1);
        }
        if (isUrlValid && !url.endsWith("/")) {
            url = url + "/";
        }
        return url;
    }

    String getServerRoot(HashMap<String, String> webContextVariables) {
        String root = webContextVariables.get("CONTEXT_PATH");
        if (root != null && !root.isEmpty()) {
            return root;
        }
        root = webContextVariables.get("SERVER_PROTOCOL");
        if (root != null && !root.isEmpty()) {
            return root;
        }
        return null;
    }

    String getServerPackages(HashMap<String, String> webContextVariables) {
        String root = this.getServerRoot(webContextVariables);
        String osgiPath = webContextVariables.get(PLATFORM_OSGI_BRIDGE_ID);
        return root + osgiPath;
    }

    String getServerServices(HashMap<String, String> webContextVariables) {
        String root = this.getServerRoot(webContextVariables);
        String osgiPath = webContextVariables.get(PLATFORM_OSGI_BRIDGE_ID);
        String servicesPath = webContextVariables.get(SERVICES_CONTEXT_PROPERTY);
        return root + osgiPath + servicesPath;
    }

    private boolean shouldUseFullyQualifiedUrl(HttpServletRequest httpRequest) {
        String useFullyQualifiedUrlParameter = httpRequest.getParameter(USE_FULL_URL_PARAM);
        return "true".equals(useFullyQualifiedUrlParameter);
    }

    private static String makeReservedCharPattern() {
        StringBuilder buf = new StringBuilder();
        buf.append(".*[");
        for (Character ch : JcrRepositoryFileUtils.getReservedChars()) {
            buf.append(StringEscapeUtils.escapeJavaScript((String)ch.toString()));
        }
        buf.append("]+.*");
        return buf.toString();
    }

    protected void addCustomInfo(OutputStream out) throws IOException {
    }

    List<Character> getRepositoryReservedChars() {
        return JcrRepositoryFileUtils.getReservedChars();
    }

    IApplicationContext getApplicationContext() {
        return PentahoSystem.getApplicationContext();
    }

    IPentahoRequestContext getRequestContext() {
        return PentahoRequestContextHolder.getRequestContext();
    }

    IPentahoSession getSession() {
        return PentahoSessionHolder.getSession();
    }

    IPluginManager getPluginManager() {
        return (IPluginManager)PentahoSystem.get(IPluginManager.class);
    }

    IUserSettingService getUserSettingsService() {
        return (IUserSettingService)PentahoSystem.get(IUserSettingService.class, (IPentahoSession)this.getSession());
    }

    String initializeServicesPath() {
        Dictionary<String, Object> properties = this.configurationAdminProxy.getProperties(SERVICES_PERSISTENCE_ID);
        String servicesRoot = "";
        if (properties != null) {
            servicesRoot = (String)properties.get(SERVICES_CONTEXT_PROPERTY);
        }
        if (StringUtils.isEmpty((String)servicesRoot)) {
            servicesRoot = DEFAULT_SERVICES_ROOT;
        }
        return this.normalizeURL(servicesRoot);
    }

    public String getSsoEnabled() {
        return this.ssoEnabled;
    }

    public void setSsoEnabled(String ssoEnabled) {
        this.ssoEnabled = ssoEnabled;
    }
}

