/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.web.http.filters;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.util.ITempFileDeleter;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.core.system.StandaloneSession;
import org.pentaho.platform.util.messages.LocaleHelper;
import org.pentaho.platform.web.http.session.PentahoHttpSession;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.security.authentication.AuthenticationProvider;

public class HttpSessionPentahoSessionIntegrationFilter
implements Filter,
InitializingBean {
    private static final Log logger = LogFactory.getLog(HttpSessionPentahoSessionIntegrationFilter.class);
    static final String FILTER_APPLIED = "__pentaho_session_integration_filter_applied";
    private boolean allowSessionCreation = true;
    private boolean forceEagerSessionCreation = false;
    private static String anonymousUser;
    protected boolean callSetAuthenticatedForAnonymousUsers = true;
    private boolean ssoEnabled = false;

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }

    public void afterPropertiesSet() throws Exception {
        if (this.forceEagerSessionCreation && !this.allowSessionCreation) {
            throw new IllegalArgumentException("If using forceEagerSessionCreation, you must set allowSessionCreation to also be true");
        }
    }

    protected IPentahoSession generatePentahoSession(HttpServletRequest httpRequest) {
        ITempFileDeleter deleter;
        HttpSession httpSession = httpRequest.getSession(false);
        Object pentahoSession = null;
        pentahoSession = httpSession != null ? new PentahoHttpSession(null, httpSession, httpRequest.getLocale(), null) : new NoDestroyStandaloneSession(null);
        if (this.callSetAuthenticatedForAnonymousUsers) {
            pentahoSession.setAuthenticated(this.getAnonymousUser());
        }
        if ((deleter = (ITempFileDeleter)PentahoSystem.get(ITempFileDeleter.class, (IPentahoSession)pentahoSession)) != null) {
            pentahoSession.setAttribute("PENTAHO_TMP_DELETER", deleter);
        }
        return pentahoSession;
    }

    protected void localeLeftovers(HttpServletRequest httpRequest) {
        HttpSession httpSession = httpRequest.getSession(false);
        if (httpSession != null) {
            String localeOverride = (String)httpSession.getAttribute("locale_override");
            if (!StringUtils.isEmpty((String)localeOverride)) {
                LocaleHelper.parseAndSetLocaleOverride((String)localeOverride);
            } else {
                LocaleHelper.setLocaleOverride(null);
            }
        }
        LocaleHelper.setLocale((Locale)httpRequest.getLocale());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!(request instanceof HttpServletRequest)) {
            throw new ServletException("Can only process HttpServletRequest");
        }
        if (!(response instanceof HttpServletResponse)) {
            throw new ServletException("Can only process HttpServletResponse");
        }
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        if (httpRequest.getAttribute(FILTER_APPLIED) != null) {
            chain.doFilter((ServletRequest)httpRequest, (ServletResponse)httpResponse);
            return;
        }
        HttpSession httpSession = this.safeGetSession(httpRequest, this.forceEagerSessionCreation);
        boolean httpSessionExistedAtStartOfRequest = httpSession != null;
        IPentahoSession pentahoSessionBeforeChainExecution = this.readPentahoSessionFromHttpSession(httpSession);
        if (httpSessionExistedAtStartOfRequest) {
            this.setSessionExpirationCookies(httpSession, pentahoSessionBeforeChainExecution, httpResponse);
        }
        httpSession = null;
        this.localeLeftovers(httpRequest);
        if (pentahoSessionBeforeChainExecution == null) {
            pentahoSessionBeforeChainExecution = this.generatePentahoSession(httpRequest);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Found no IPentahoSession in HTTP session; created new IPentahoSession");
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)("Obtained a valid IPentahoSession from HTTP session to associate with PentahoSessionHolder: '" + pentahoSessionBeforeChainExecution + "'"));
        }
        httpRequest.setAttribute(FILTER_APPLIED, (Object)Boolean.TRUE);
        OnRedirectUpdateSessionResponseWrapper responseWrapper = new OnRedirectUpdateSessionResponseWrapper(httpResponse, httpRequest, httpSessionExistedAtStartOfRequest);
        try {
            PentahoSessionHolder.setSession((IPentahoSession)pentahoSessionBeforeChainExecution);
            chain.doFilter((ServletRequest)httpRequest, (ServletResponse)responseWrapper);
        }
        finally {
            IPentahoSession pentahoSessionAfterChainExecution = PentahoSessionHolder.getSession();
            PentahoSessionHolder.removeSession();
            httpRequest.removeAttribute(FILTER_APPLIED);
            if (!responseWrapper.isSessionUpdateDone()) {
                this.storePentahoSessionInHttpSession(pentahoSessionAfterChainExecution, httpRequest, httpSessionExistedAtStartOfRequest);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"PentahoSessionHolder now cleared, as request processing completed");
            }
        }
    }

    private IPentahoSession readPentahoSessionFromHttpSession(HttpSession httpSession) {
        if (httpSession == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"No HttpSession currently exists");
            }
            return null;
        }
        IPentahoSession pentahoSessionFromHttpSession = (IPentahoSession)httpSession.getAttribute("pentaho-session-context");
        if (pentahoSessionFromHttpSession == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"HttpSession returned null object for pentaho-session-context");
            }
            return null;
        }
        return pentahoSessionFromHttpSession;
    }

    private void storePentahoSessionInHttpSession(IPentahoSession pentahoSession, HttpServletRequest request, boolean httpSessionExistedAtStartOfRequest) {
        HttpSession httpSession = this.safeGetSession(request, false);
        if (httpSession == null) {
            if (httpSessionExistedAtStartOfRequest) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"HttpSession is now null, but was not null at start of request; session was invalidated, so do not create a new session");
                }
            } else if (!this.allowSessionCreation) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("The HttpSession is currently null, and the " + this.getClass().getSimpleName() + " is prohibited from creating an HttpSession (because the allowSessionCreation property is false) - Pentaho session thus not stored for next request"));
                }
            } else if (pentahoSession != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"HttpSession being created as Pentaho session is non-null");
                }
                httpSession = this.safeGetSession(request, true);
            } else if (logger.isDebugEnabled()) {
                logger.debug((Object)"HttpSession is null, and Pentaho session is null; not creating HttpSession or storing SecurityContextHolder contents");
            }
        }
        if (httpSession != null) {
            httpSession.setAttribute("pentaho-session-context", (Object)pentahoSession);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Pentaho session stored to HttpSession: '" + pentahoSession + "'"));
            }
        }
    }

    @VisibleForTesting
    void setSessionExpirationCookies(HttpSession httpSession, IPentahoSession pentahoSession, HttpServletResponse httpServletResponse) {
        if (null == httpSession || null == pentahoSession) {
            return;
        }
        String showDialog = PentahoSystem.getSystemSetting((String)"session-expired-dialog", (String)"true");
        if ("true".equals(showDialog)) {
            List authenticationProviders = PentahoSystem.getAll(AuthenticationProvider.class, (IPentahoSession)pentahoSession);
            if (null == authenticationProviders || authenticationProviders.isEmpty()) {
                return;
            }
            if (this.isSsoEnabled()) {
                return;
            }
            long serverTime = System.currentTimeMillis();
            long expiryTime = serverTime + (long)(httpSession.getMaxInactiveInterval() * 1000);
            Cookie sessionExpirationCookie = new Cookie("session-expiry", String.valueOf(expiryTime));
            sessionExpirationCookie.setPath("/");
            Cookie serverTimeCookie = new Cookie("server-time", String.valueOf(serverTime));
            serverTimeCookie.setPath("/");
            httpServletResponse.addCookie(sessionExpirationCookie);
            httpServletResponse.addCookie(serverTimeCookie);
        }
    }

    private HttpSession safeGetSession(HttpServletRequest request, boolean allowCreate) {
        try {
            return request.getSession(allowCreate);
        }
        catch (IllegalStateException ignored) {
            return null;
        }
    }

    public boolean isAllowSessionCreation() {
        return this.allowSessionCreation;
    }

    public void setAllowSessionCreation(boolean allowSessionCreation) {
        this.allowSessionCreation = allowSessionCreation;
    }

    public boolean isForceEagerSessionCreation() {
        return this.forceEagerSessionCreation;
    }

    public void setForceEagerSessionCreation(boolean forceEagerSessionCreation) {
        this.forceEagerSessionCreation = forceEagerSessionCreation;
    }

    public void setCallSetAuthenticatedForAnonymousUsers(boolean callSetAuthenticatedForAnonymousUsers) {
        this.callSetAuthenticatedForAnonymousUsers = callSetAuthenticatedForAnonymousUsers;
    }

    protected String getAnonymousUser() {
        if (anonymousUser == null) {
            anonymousUser = PentahoSystem.getSystemSetting((String)"anonymous-authentication/anonymous-user", (String)"anonymousUser");
        }
        return anonymousUser;
    }

    public boolean isSsoEnabled() {
        return this.ssoEnabled;
    }

    public void setSsoEnabled(boolean ssoEnabled) {
        this.ssoEnabled = ssoEnabled;
    }

    private static class NoDestroyStandaloneSession
    extends StandaloneSession {
        private static final long serialVersionUID = -2402127216157794843L;

        public NoDestroyStandaloneSession(String name) {
            super(name);
        }

        public void destroy() {
        }
    }

    private class OnRedirectUpdateSessionResponseWrapper
    extends HttpServletResponseWrapper {
        HttpServletRequest request;
        boolean httpSessionExistedAtStartOfRequest;
        boolean sessionUpdateDone;

        public OnRedirectUpdateSessionResponseWrapper(HttpServletResponse response, HttpServletRequest request, boolean httpSessionExistedAtStartOfRequest) {
            super(response);
            this.sessionUpdateDone = false;
            this.request = request;
            this.httpSessionExistedAtStartOfRequest = httpSessionExistedAtStartOfRequest;
        }

        public void sendError(int sc) throws IOException {
            this.doSessionUpdate();
            super.sendError(sc);
        }

        public void sendError(int sc, String msg) throws IOException {
            this.doSessionUpdate();
            super.sendError(sc, msg);
        }

        public void sendRedirect(String location) throws IOException {
            this.doSessionUpdate();
            super.sendRedirect(location);
        }

        private void doSessionUpdate() {
            if (this.sessionUpdateDone) {
                return;
            }
            IPentahoSession pentahoSession = PentahoSessionHolder.getSession();
            HttpSessionPentahoSessionIntegrationFilter.this.storePentahoSessionInHttpSession(pentahoSession, this.request, this.httpSessionExistedAtStartOfRequest);
            this.sessionUpdateDone = true;
        }

        public boolean isSessionUpdateDone() {
            return this.sessionUpdateDone;
        }
    }
}

