/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.web.http.api.resources;

import java.util.ArrayList;
import java.util.Comparator;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.codehaus.enunciate.jaxrs.ResponseCode;
import org.codehaus.enunciate.jaxrs.StatusCodes;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.security.DefaultRoleComparator;
import org.pentaho.platform.engine.security.DefaultUsernameComparator;
import org.pentaho.platform.web.http.api.resources.AbstractJaxRSResource;
import org.pentaho.platform.web.http.api.resources.RoleListWrapper;
import org.pentaho.platform.web.http.api.resources.RolesWrapper;
import org.pentaho.platform.web.http.api.resources.UserListWrapper;
import org.pentaho.platform.web.http.api.resources.UsersWrapper;
import org.pentaho.platform.web.http.api.resources.services.UserRoleListService;

@Path(value="/userrolelist/")
public class UserRoleListResource
extends AbstractJaxRSResource {
    private ArrayList<String> systemRoles;
    protected String adminRole;
    private String anonymousRole;
    private ArrayList<String> extraRoles;
    protected static UserRoleListService userRoleListService;

    public UserRoleListResource() {
        this((ArrayList)PentahoSystem.get(ArrayList.class, (String)"singleTenantSystemAuthorities", (IPentahoSession)PentahoSessionHolder.getSession()), (String)PentahoSystem.get(String.class, (String)"singleTenantAdminAuthorityName", (IPentahoSession)PentahoSessionHolder.getSession()), (String)PentahoSystem.get(String.class, (String)"singleTenantAnonymousAuthorityName", (IPentahoSession)PentahoSessionHolder.getSession()), (ArrayList)PentahoSystem.get(ArrayList.class, (String)"extraSystemAuthorities", (IPentahoSession)PentahoSessionHolder.getSession()));
    }

    public UserRoleListResource(ArrayList<String> systemRoles, String adminRole, ArrayList<String> extraRoles) {
        this(systemRoles, adminRole, (String)PentahoSystem.get(String.class, (String)"singleTenantAnonymousAuthorityName", (IPentahoSession)PentahoSessionHolder.getSession()), extraRoles);
    }

    public UserRoleListResource(ArrayList<String> systemRoles, String adminRole, String anonymousRole, ArrayList<String> extraRoles) {
        this.systemRoles = systemRoles;
        this.adminRole = adminRole;
        this.anonymousRole = anonymousRole;
        this.extraRoles = extraRoles;
        userRoleListService = new UserRoleListService();
        userRoleListService.setExtraRoles(extraRoles);
        userRoleListService.setSystemRoles(systemRoles);
        userRoleListService.setRoleComparator((Comparator<String>)new DefaultRoleComparator());
        userRoleListService.setUserComparator((Comparator<String>)new DefaultUsernameComparator());
    }

    @GET
    @Path(value="/permission-users")
    @Produces(value={"application/xml", "application/json"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Successfully retrieved the list of User objects."), @ResponseCode(code=500, condition="Unable to retrieve User objects.")})
    public UserListWrapper getPermissionUsers() throws Exception {
        return this.getUsers();
    }

    @GET
    @Path(value="/permission-roles")
    @Produces(value={"application/xml", "application/json"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Successfully retrieved the list of permission roles.")})
    public RoleListWrapper getPermissionRoles() throws Exception {
        return userRoleListService.getPermissionRoles(this.adminRole);
    }

    @GET
    @Path(value="/users")
    @Produces(value={"application/xml", "application/json"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Successfully retrieved the list of User objects."), @ResponseCode(code=500, condition="Unable to retrieve User objects.")})
    public UserListWrapper getUsers() throws Exception {
        return userRoleListService.getUsers();
    }

    @GET
    @Path(value="/roles")
    @Produces(value={"application/xml", "application/json"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Successfully retrieved the list of Role objects.")})
    public RoleListWrapper getRoles(@QueryParam(value="addExtraRoles") String addExtraRoles) {
        boolean includeExtraRoles = true;
        if (addExtraRoles != null && addExtraRoles.length() > 0) {
            includeExtraRoles = Boolean.parseBoolean(addExtraRoles);
        }
        return userRoleListService.getRoles(includeExtraRoles);
    }

    @GET
    @Path(value="/allRoles")
    @Produces(value={"application/xml", "application/json"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Successfully retrieved the list of Role objects.")})
    public RoleListWrapper getAllRoles() throws Exception {
        return userRoleListService.getAllRoles();
    }

    @GET
    @Path(value="/systemRoles")
    @Produces(value={"application/xml", "application/json"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Successfully returns system role list.")})
    public RoleListWrapper getSystemRoles() {
        return userRoleListService.getSystemRoles();
    }

    @GET
    @Path(value="/extraRoles")
    @Produces(value={"application/xml", "application/json"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Successfully returns extra role list.")})
    public RoleListWrapper getExtraRoles() {
        return userRoleListService.getExtraRolesList();
    }

    @GET
    @Path(value="/getRolesForUser")
    @Produces(value={"application/xml", "application/json"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Successfully retrieved the list of Role objects."), @ResponseCode(code=500, condition="Invalid user parameter.")})
    public RolesWrapper getRolesForUser(@QueryParam(value="user") String user) throws Exception {
        return new RolesWrapper(userRoleListService.doGetRolesForUser(user));
    }

    @GET
    @Path(value="/getUsersInRole")
    @Produces(value={"application/xml", "application/json"})
    @StatusCodes(value={@ResponseCode(code=200, condition="Successfully retrieved the list of User objects."), @ResponseCode(code=500, condition="Missing the role parameter.")})
    public UsersWrapper getUsersInRole(@QueryParam(value="role") String role) throws Exception {
        return new UsersWrapper(userRoleListService.doGetUsersInRole(role));
    }
}

