/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.services.security.userrole;

import java.util.ArrayList;
import java.util.List;
import org.pentaho.platform.api.engine.ICacheManager;
import org.pentaho.platform.api.engine.IUserRoleListService;
import org.pentaho.platform.api.mt.ITenant;
import org.pentaho.platform.engine.core.system.PentahoSystem;

public class CachingUserRoleListServiceDecorator
implements IUserRoleListService {
    private IUserRoleListService delegate;
    private ICacheManager cacheManager = PentahoSystem.getCacheManager(null);
    private static final String REGION = "userRoleListCache";
    private static final String ALL_USERS = "all users";
    private static final String ALL_ROLES = "all roles";
    private static final String SYSTEM_ROLES = "system roles";
    private static final String ROLES_BY_USER = "roles by user";
    private final DelegateOperation ALL_ROLES_OPERATION = new DelegateOperation(){

        @Override
        public List<String> perform() {
            return CachingUserRoleListServiceDecorator.this.delegate.getAllRoles();
        }
    };
    private final DelegateOperation SYSTEM_ROLES_OPERATION = new DelegateOperation(){

        @Override
        public List<String> perform() {
            return CachingUserRoleListServiceDecorator.this.delegate.getSystemRoles();
        }
    };
    private final DelegateOperation ALL_USERS_OPERATION = new DelegateOperation(){

        @Override
        public List<String> perform() {
            return CachingUserRoleListServiceDecorator.this.delegate.getAllUsers();
        }
    };

    public CachingUserRoleListServiceDecorator(IUserRoleListService delegate) {
        if (delegate == null) {
            throw new IllegalArgumentException("Decorated IUserRoleListService cannot be null");
        }
        this.delegate = delegate;
        if (!this.cacheManager.cacheEnabled(REGION)) {
            this.cacheManager.addCacheRegion(REGION);
        }
    }

    private List<String> performOperation(String cacheEntry, DelegateOperation operation) {
        List<String> results = null;
        Object fromRegionCache = this.cacheManager.getFromRegionCache(REGION, (Object)cacheEntry);
        if (fromRegionCache instanceof List) {
            results = (List<String>)fromRegionCache;
        } else {
            results = operation.perform();
            this.cacheManager.putInRegionCache(REGION, (Object)cacheEntry, results);
        }
        return new ArrayList<String>(results);
    }

    public List<String> getAllRoles() {
        return this.performOperation(ALL_ROLES, this.ALL_ROLES_OPERATION);
    }

    public List<String> getSystemRoles() {
        return this.performOperation(SYSTEM_ROLES, this.SYSTEM_ROLES_OPERATION);
    }

    public List<String> getRolesForUser(final ITenant tenant, final String username) {
        return this.performOperation(ROLES_BY_USER + this.getTenantKey(tenant) + username, new DelegateOperation(){

            @Override
            public List<String> perform() {
                return CachingUserRoleListServiceDecorator.this.delegate.getRolesForUser(tenant, username);
            }
        });
    }

    private String getTenantKey(ITenant tenant) {
        return tenant != null ? tenant.getId() : "_";
    }

    public List<String> getAllUsers(final ITenant tenant) {
        return this.performOperation(ALL_USERS + this.getTenantKey(tenant), new DelegateOperation(){

            @Override
            public List<String> perform() {
                return CachingUserRoleListServiceDecorator.this.delegate.getAllUsers(tenant);
            }
        });
    }

    public List<String> getAllRoles(final ITenant tenant) {
        return this.performOperation(ALL_ROLES + this.getTenantKey(tenant), new DelegateOperation(){

            @Override
            public List<String> perform() {
                return CachingUserRoleListServiceDecorator.this.delegate.getAllRoles(tenant);
            }
        });
    }

    public List<String> getUsersInRole(final ITenant tenant, final String role) {
        return this.performOperation(ALL_USERS + this.getTenantKey(tenant) + role, new DelegateOperation(){

            @Override
            public List<String> perform() {
                return CachingUserRoleListServiceDecorator.this.delegate.getUsersInRole(tenant, role);
            }
        });
    }

    public List<String> getAllUsers() {
        return this.performOperation(ALL_USERS, this.ALL_USERS_OPERATION);
    }

    private static interface DelegateOperation {
        public List<String> perform();
    }
}

