/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.services.connections.sql;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.commons.connection.AbstractPentahoMetaData;

public class SQLMetaData
extends AbstractPentahoMetaData {
    protected static final Log logger = LogFactory.getLog(SQLMetaData.class);
    ResultSetMetaData nativeMetaData = null;
    private Object[][] columnHeaders;

    public SQLMetaData(ResultSetMetaData nativeMetaData) {
        this.nativeMetaData = nativeMetaData;
    }

    public int[] getJDBCColumnTypes() throws SQLException {
        if (this.nativeMetaData != null) {
            int colCount = this.nativeMetaData.getColumnCount();
            if (colCount > 0) {
                int[] rtn = new int[colCount];
                for (int i = 0; i < colCount; ++i) {
                    rtn[i] = this.nativeMetaData.getColumnType(i + 1);
                }
                return rtn;
            }
            return new int[0];
        }
        throw new IllegalStateException();
    }

    public Object[][] getColumnHeaders() {
        if (this.columnHeaders == null) {
            try {
                int rowCount = 1;
                int columnCount = this.nativeMetaData.getColumnCount();
                Object[][] result = new Object[rowCount][columnCount];
                for (int column = 0; column < columnCount; ++column) {
                    result[0][column] = this.nativeMetaData.getColumnLabel(column + 1);
                }
                this.columnHeaders = result;
            }
            catch (SQLException e) {
                logger.error(null, (Throwable)e);
            }
        }
        return this.columnHeaders;
    }

    public int getColumnCount() {
        try {
            return this.nativeMetaData.getColumnCount();
        }
        catch (SQLException ex) {
            logger.error(null, (Throwable)ex);
            return -1;
        }
    }

    public Object[][] getRowHeaders() {
        return null;
    }
}

