/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.action.hql;

import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.pentaho.actionsequence.dom.ActionInputConstant;
import org.pentaho.actionsequence.dom.IActionOutput;
import org.pentaho.actionsequence.dom.IActionResource;
import org.pentaho.actionsequence.dom.actions.HQLConnectionAction;
import org.pentaho.actionsequence.dom.actions.HQLQueryAction;
import org.pentaho.commons.connection.IPentahoConnection;
import org.pentaho.commons.connection.IPentahoResultSet;
import org.pentaho.platform.api.data.IPreparedComponent;
import org.pentaho.platform.api.engine.IActionSequenceResource;
import org.pentaho.platform.api.engine.ILogger;
import org.pentaho.platform.api.engine.IParameterResolver;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.IRuntimeContext;
import org.pentaho.platform.engine.services.connection.PentahoConnectionFactory;
import org.pentaho.platform.engine.services.runtime.MapParameterResolver;
import org.pentaho.platform.engine.services.runtime.TemplateUtil;
import org.pentaho.platform.engine.services.solution.ComponentBase;
import org.pentaho.platform.plugin.action.messages.Messages;
import org.pentaho.platform.plugin.services.connections.hql.HQLConnection;

public abstract class HQLBaseComponent
extends ComponentBase
implements IPreparedComponent {
    private static final long serialVersionUID = 5949258346877934670L;
    private IPentahoResultSet rSet;
    private IPentahoConnection connection;
    private boolean connectionOwner = true;
    private String preparedQuery = null;

    public abstract boolean validateSystemSettings();

    public abstract String getResultOutputName();

    public abstract Log getLogger();

    public IPentahoResultSet getResultSet() {
        return this.rSet;
    }

    protected boolean validateAction() {
        HQLConnectionAction connAction = null;
        HQLQueryAction queryAction = null;
        boolean actionValidated = true;
        try {
            if (this.getActionDefinition() instanceof HQLQueryAction) {
                queryAction = (HQLQueryAction)this.getActionDefinition();
                actionValidated = this.isConnectionInfoSpecified((HQLConnectionAction)queryAction);
                if (actionValidated && queryAction.getQuery() == ActionInputConstant.NULL_INPUT) {
                    actionValidated = false;
                    this.error(Messages.getInstance().getErrorString("HQLBaseComponent.ERROR_0004_QUERY_NOT_SPECIFIED", new Object[]{this.getActionName()}));
                }
                if (actionValidated && queryAction.getOutputResultSetName() == null && queryAction.getOutputPreparedStatementName() == null) {
                    actionValidated = false;
                    this.error(Messages.getInstance().getErrorString("HQLBaseComponent.ERROR_0005_OUTPUT_NOT_SPECIFIED", new Object[]{this.getActionName()}));
                }
            } else if (this.getActionDefinition() instanceof HQLConnectionAction) {
                connAction = (HQLConnectionAction)this.getActionDefinition();
                actionValidated = this.isConnectionInfoSpecified(connAction);
            } else {
                actionValidated = false;
                this.error(Messages.getInstance().getErrorString("ComponentBase.ERROR_0001_UNKNOWN_ACTION_TYPE", new Object[]{this.getActionDefinition().getElement().asXML()}));
            }
        }
        catch (Exception e) {
            actionValidated = false;
            this.error(Messages.getInstance().getErrorString("HQLBaseComponent.ERROR_0006_VALIDATION_FAILED", new Object[]{this.getActionName()}), e);
        }
        return actionValidated;
    }

    private boolean isConnectionInfoSpecified(HQLConnectionAction connAction) {
        boolean value = true;
        if (connAction instanceof HQLQueryAction) {
            if (((HQLQueryAction)connAction).getInputSharedConnection() == ActionInputConstant.NULL_INPUT && !this.isBasicConnectionInfoSpecified(connAction)) {
                value = false;
                this.error(Messages.getInstance().getErrorString("HQLBaseComponent.ERROR_0003_CONNECTION_INFO_NOT_SPECIFIED", new Object[]{this.getActionName()}));
            }
        } else if (!this.isBasicConnectionInfoSpecified(connAction)) {
            value = false;
            this.error(Messages.getInstance().getErrorString("HQLBaseComponent.ERROR_0003_CONNECTION_INFO_NOT_SPECIFIED", new Object[]{this.getActionName()}));
        }
        return value;
    }

    private boolean isBasicConnectionInfoSpecified(HQLConnectionAction connAction) {
        boolean value = true;
        if (connAction.getClassNames() == ActionInputConstant.NULL_INPUT) {
            value = false;
            this.error(Messages.getInstance().getErrorString("HQLBaseComponent.ERROR_0001_CLASS_NAMES_INFO_NOT_SPECIFIED", new Object[]{this.getActionName()}));
        }
        if (connAction.getHibernateConfigResource() == null) {
            value = false;
            this.error(Messages.getInstance().getErrorString("HQLBaseComponent.ERROR_0002_HIBERNATE_CONFIG_INFO_NOT_SPECIFIED", new Object[]{this.getActionName()}));
        }
        return value;
    }

    public void done() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean executeAction() {
        boolean returnValue = true;
        try {
            if (this.getActionDefinition() instanceof HQLQueryAction) {
                HQLQueryAction queryAction = (HQLQueryAction)this.getActionDefinition();
                String[] classNames = null;
                String query = queryAction.getQuery().getStringValue();
                if (queryAction.getInputSharedConnection() != ActionInputConstant.NULL_INPUT) {
                    this.connectionOwner = false;
                    IPreparedComponent component = (IPreparedComponent)queryAction.getInputSharedConnection().getValue();
                    IPentahoConnection conn = component.shareConnection();
                    if ("HQL".equals(conn.getDatasourceType())) {
                        this.connection = conn;
                    } else {
                        this.connection = null;
                        returnValue = false;
                        this.error(Messages.getInstance().getErrorString("IPreparedComponent.ERROR_0001_INVALID_CONNECTION_TYPE", new Object[]{this.getActionName()}));
                    }
                } else {
                    this.createBasicConnection((HQLConnectionAction)queryAction, classNames);
                }
                if (this.connection == null) return returnValue;
                IActionOutput actionOutput = queryAction.getOutputPreparedStatementParam();
                if (actionOutput == null) return this.runQuery(this.connection, classNames, query);
                this.prepareQuery(query);
                actionOutput.setValue((Object)this);
                return returnValue;
            } else if (this.getActionDefinition() instanceof HQLConnectionAction) {
                IActionOutput outputConnection;
                HQLConnectionAction connAction = (HQLConnectionAction)this.getActionDefinition();
                String[] classNames = null;
                this.createBasicConnection(connAction, classNames);
                if (this.connection == null || (outputConnection = connAction.getOutputConnectionParam()) == null) return returnValue;
                outputConnection.setValue((Object)this);
                return returnValue;
            } else {
                returnValue = false;
                this.error(Messages.getInstance().getErrorString("HQLBaseComponent.ERROR_00011_INVALID_HQL_COMPONENT", new Object[]{this.getActionName()}));
            }
            return returnValue;
        }
        catch (Exception e) {
            returnValue = false;
            this.error(Messages.getInstance().getErrorString("HQLBaseComponent.ERROR_00012_EXECUTE_FAILED", new Object[]{this.getActionName()}), e);
        }
        return returnValue;
    }

    private void createBasicConnection(HQLConnectionAction connAction, String[] classNames) {
        boolean proceed = true;
        String catalog = null;
        if (connAction.getClassNames() != ActionInputConstant.NULL_INPUT) {
            classNames = this.getClassNames(connAction);
        } else {
            proceed = false;
            this.error(Messages.getInstance().getErrorString("HQLBaseComponent.ERROR_0001_CLASS_NAMES_INFO_NOT_SPECIFIED", new Object[]{this.getActionName()}));
        }
        if (proceed && (null == (catalog = this.getCatalog()) || catalog.trim().length() <= 0)) {
            proceed = false;
            this.error(Messages.getInstance().getErrorString("HQLBaseComponent.ERROR_00010_CATALOG_INFO_NOT_SPECIFIED", new Object[]{this.getActionName()}));
        }
        if (proceed) {
            this.connection = this.getConnection(new File(catalog), classNames);
            if (this.connection == null) {
                this.error(Messages.getInstance().getErrorString("HQLBaseComponent.ERROR_0009_COULD_NOT_ESTABLISH_CONNECTION", new Object[]{this.getActionName()}));
            }
        }
    }

    private String[] getClassNames(HQLConnectionAction connAction) {
        ArrayList<String> classNamesList = new ArrayList<String>();
        String[] classNames = null;
        try {
            String classes = connAction.getClassNames().getStringValue();
            StringTokenizer st = new StringTokenizer(classes, ",");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                classNamesList.add(token.trim());
            }
            classNames = classNamesList.toArray(new String[0]);
        }
        catch (Exception e) {
            this.error(Messages.getInstance().getErrorString("HQLBaseComponent.ERROR_0008_COULD_NOT_RETRIEVE_CLASS_NAMES", new Object[]{this.getActionName()}), e);
        }
        return classNames;
    }

    private String getCatalog() {
        String resName;
        IActionSequenceResource resource;
        IActionResource hibernateConfigRes = ((HQLConnectionAction)this.getActionDefinition()).getHibernateConfigResource();
        String catalog = null;
        String resAddress = null;
        if (hibernateConfigRes != null && (resAddress = (resource = this.getResource(resName = this.applyInputsToFormat(hibernateConfigRes.getName()))).getAddress()) != null) {
            catalog = this.applyInputsToFormat(resAddress);
        }
        return catalog;
    }

    protected boolean prepareQuery(String rawQuery) {
        try {
            if (this.connection == null) {
                this.error(Messages.getInstance().getErrorString("HQLBaseComponent.ERROR_00013_NO_CONNECTION"));
                return false;
            }
            if (!this.connection.initialized()) {
                this.error(Messages.getInstance().getErrorString("HQLBaseComponent.ERROR_00013_NO_CONNECTION"));
                return false;
            }
            if (rawQuery != null) {
                this.preparedQuery = this.applyInputsToFormat(rawQuery);
            }
            return true;
        }
        catch (Exception e) {
            this.error(Messages.getInstance().getErrorString("HQLBaseComponent.ERROR_00014_COULD_NOT_PREPARE_QUERY", new Object[]{this.getActionName()}), e);
            return false;
        }
    }

    public IPentahoResultSet executePrepared(Map preparedParams) {
        try {
            IPentahoResultSet resultSet;
            if (this.connection == null) {
                this.error(Messages.getInstance().getErrorString("HQLBaseComponent.ERROR_0009_COULD_NOT_ESTABLISH_CONNECTION"));
                return null;
            }
            if (!this.connection.initialized()) {
                this.error(Messages.getInstance().getErrorString("HQLBaseComponent.ERROR_0009_COULD_NOT_ESTABLISH_CONNECTION"));
                return null;
            }
            if (this.preparedQuery == null) {
                this.error(Messages.getInstance().getErrorString("HQLBaseComponent.ERROR_00016_QUERY_NOT_SPECIFIED"));
                return null;
            }
            String query = TemplateUtil.applyTemplate((String)this.preparedQuery, (IRuntimeContext)this.getRuntimeContext(), (IParameterResolver)new MapParameterResolver(preparedParams, "PREPARELATER", this.getRuntimeContext()));
            this.debug(Messages.getInstance().getString("HQLBaseComponent.DEBUG_RUNNING_QUERY", new Object[]{query}));
            this.rSet = resultSet = this.connection.executeQuery(query);
            return resultSet;
        }
        catch (Exception e) {
            this.error(Messages.getInstance().getErrorString("HQLBaseComponent.ERROR_00012_EXECUTE_FAILED", new Object[]{this.getActionName()}), e);
            return null;
        }
    }

    protected boolean runQuery(IPentahoConnection conn, String[] classNames, String query) {
        try {
            if (conn == null) {
                return false;
            }
            this.rSet = ((HQLConnection)conn).executeQuery(query);
            IActionOutput actionOutput = ((HQLQueryAction)this.getActionDefinition()).getOutputResultSetParam();
            if (actionOutput != null) {
                actionOutput.setValue((Object)this.rSet);
            }
            return true;
        }
        catch (Exception e) {
            this.error(Messages.getInstance().getErrorString("HQLBaseComponent.ERROR_0007_QUERY_EXECUTION_FAILED", new Object[]{this.getActionName()}), e);
            return false;
        }
    }

    public void dispose() {
        if (this.connectionOwner && this.connection != null) {
            this.connection.close();
        }
        this.connection = null;
    }

    protected IPentahoConnection getConnection(File hbmCfgFile, String[] classNames) {
        HQLConnection conn = null;
        try {
            HQLConnection hconn = conn = (HQLConnection)PentahoConnectionFactory.getConnection((String)"HQL", (IPentahoSession)this.getSession(), (ILogger)this);
            hconn.setConfigFile(hbmCfgFile);
            hconn.setClassNames(classNames);
            return conn;
        }
        catch (Exception e) {
            this.error(Messages.getInstance().getErrorString("HQLBaseComponent.ERROR_0009_COULD_NOT_ESTABLISH_CONNECTION", new Object[]{this.getActionName()}), e);
            return null;
        }
    }

    public IPentahoConnection shareConnection() {
        return this.connection;
    }

    public boolean init() {
        return true;
    }
}

