/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.action.datatransforms;

import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.commons.connection.IPentahoResultSet;
import org.pentaho.commons.connection.PentahoDataTransmuter;
import org.pentaho.platform.engine.services.solution.ComponentBase;
import org.pentaho.platform.plugin.action.messages.Messages;

public class ResultSetFlattenerComponent
extends ComponentBase {
    private static final String RESULT_SET = "result-set";
    private static final String FLATTEN_COLUMN = "flatten-column";
    private static final long serialVersionUID = 5969716585776621813L;

    public Log getLogger() {
        return LogFactory.getLog(ResultSetFlattenerComponent.class);
    }

    public boolean init() {
        return true;
    }

    protected boolean validateSystemSettings() {
        return true;
    }

    protected boolean validateAction() {
        if (!this.isDefinedInput(RESULT_SET)) {
            this.error(Messages.getInstance().getString("ResultSetFlattenerComponent.ERROR_0001_DATA_INPUT_INVALID_OBJECT"));
            return false;
        }
        if (this.getResultOutputName() == null) {
            this.error(Messages.getInstance().getString("ResultSetFlattenerComponent.ERROR_0002_INVALID_OUTPUT"));
            return false;
        }
        if (!this.isDefinedInput(FLATTEN_COLUMN)) {
            this.error(Messages.getInstance().getString("ResultSetFlattenerComponent.ERROR_0003_INVALID_FLATTEN_COLUMN"));
            return false;
        }
        return true;
    }

    protected boolean executeAction() {
        Object resultSetObject = this.getInputValue(RESULT_SET);
        if (resultSetObject instanceof IPentahoResultSet) {
            IPentahoResultSet resultset = (IPentahoResultSet)resultSetObject;
            int column = (int)this.getInputLongValue(FLATTEN_COLUMN, 0L);
            --column;
            if (this.getResultOutputName() != null) {
                this.setOutputValue(this.getResultOutputName(), PentahoDataTransmuter.flattenResultSet((IPentahoResultSet)resultset, (int)column));
            }
        }
        return true;
    }

    public void done() {
    }

    public String getResultOutputName() {
        Set outputs = this.getOutputNames();
        if (outputs == null || outputs.size() == 0) {
            this.error(Messages.getInstance().getString("Template.ERROR_0002_OUTPUT_COUNT_WRONG"));
            return null;
        }
        String outputName = null;
        try {
            outputName = this.getInputStringValue("output-name");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (outputName == null) {
            outputName = (String)outputs.iterator().next();
        }
        return outputName;
    }
}

