/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.action.chartbeans;

import java.util.regex.Matcher;
import org.pentaho.chart.IChartLinkGenerator;

public class ChartLinkGenerator
implements IChartLinkGenerator {
    private String urlTemplate;

    public ChartLinkGenerator(String urlTemplate) {
        this.urlTemplate = urlTemplate;
    }

    public String generateLink(String seriesName, String domainName, Number rangeValue) {
        seriesName = Matcher.quoteReplacement(seriesName);
        domainName = Matcher.quoteReplacement(domainName);
        seriesName = this.resolveEscapeCharacters(seriesName);
        domainName = this.resolveEscapeCharacters(domainName);
        return this.urlTemplate.replaceAll("\\{series\\}", seriesName == null ? "" : seriesName).replaceAll("\\{domain\\}", domainName == null ? "" : domainName).replaceAll("\\{range\\}", rangeValue == null ? "" : rangeValue.toString());
    }

    private String resolveEscapeCharacters(String s) {
        if (this.urlTemplate.startsWith("javascript:") && s.indexOf("'") >= 0) {
            s = s.replaceAll("'", "\\\\\\\\'");
        }
        return s;
    }

    public String generateLink(String seriesName, Number domainValue, Number rangeValue) {
        return this.urlTemplate.replaceAll("\\{series\\}", (seriesName = this.resolveEscapeCharacters(seriesName)) == null ? "" : seriesName).replaceAll("\\{domain\\}", domainValue == null ? "" : domainValue.toString()).replaceAll("\\{range\\}", rangeValue == null ? "" : rangeValue.toString());
    }
}

