/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.action.builtin;

import java.io.OutputStream;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.actionsequence.dom.actions.TemplateMsgAction;
import org.pentaho.platform.api.engine.IActionParameter;
import org.pentaho.platform.api.engine.IActionSequenceResource;
import org.pentaho.platform.api.repository.IContentItem;
import org.pentaho.platform.engine.services.solution.ComponentBase;
import org.pentaho.platform.plugin.action.messages.Messages;
import org.pentaho.platform.util.messages.LocaleHelper;

public class TemplateComponent
extends ComponentBase {
    private static final String TEMPLATE = "template";
    private static final long serialVersionUID = 4383466190328580251L;

    public Log getLogger() {
        return LogFactory.getLog(TemplateComponent.class);
    }

    protected boolean validateAction() {
        TemplateMsgAction actionDefinition = (TemplateMsgAction)this.getActionDefinition();
        boolean templateOk = false;
        if (null != actionDefinition.getTemplate()) {
            templateOk = true;
        } else if (this.isDefinedResource(TEMPLATE)) {
            templateOk = true;
        }
        if (!templateOk) {
            this.error(Messages.getInstance().getString("Template.ERROR_0001_TEMPLATE_NOT_DEFINED"));
            return false;
        }
        Set outputs = this.getOutputNames();
        if (outputs == null || outputs.size() == 0 || outputs.size() > 1) {
            this.error(Messages.getInstance().getString("Template.ERROR_0002_OUTPUT_COUNT_WRONG"));
            return false;
        }
        return true;
    }

    protected boolean validateSystemSettings() {
        return true;
    }

    public void done() {
    }

    protected boolean executeAction() {
        try {
            String outputName;
            IActionParameter outputParam;
            TemplateMsgAction actionDefinition = (TemplateMsgAction)this.getActionDefinition();
            String template = null;
            template = actionDefinition.getTemplate().getStringValue();
            if (null == template && this.isDefinedResource(TEMPLATE)) {
                IActionSequenceResource resource = this.getResource(TEMPLATE);
                template = this.getResourceAsString(resource);
            }
            if ((outputParam = this.getOutputItem(outputName = (String)this.getOutputNames().iterator().next())).getType().equals("content")) {
                String mimeType = actionDefinition.getMimeType().getStringValue();
                String extension = actionDefinition.getExtension().getStringValue();
                if (mimeType == null) {
                    mimeType = "";
                }
                if (extension == null) {
                    extension = "";
                }
                IContentItem outputItem = this.getOutputContentItem(outputName, mimeType);
                OutputStream outputStream = outputItem.getOutputStream(this.getActionName());
                outputStream.write(this.applyInputsToFormat(template).getBytes(LocaleHelper.getSystemEncoding()));
                outputItem.closeOutputStream();
                return true;
            }
            this.setOutputValue(outputName, this.applyInputsToFormat(template));
            return true;
        }
        catch (Exception e) {
            this.error(Messages.getInstance().getString("Template.ERROR_0004_COULD_NOT_FORMAT_TEMPLATE"), e);
            return false;
        }
    }

    public boolean init() {
        return true;
    }
}

