/*
 * Decompiled with CFR 0.152.
 */
package com.pentaho.googlecloudstorage.vfs;

import com.google.cloud.storage.Blob;
import com.google.cloud.storage.BlobInfo;
import com.google.cloud.storage.Bucket;
import com.google.cloud.storage.Storage;
import com.pentaho.googlecloudstorage.vfs.GoogleCloudStorageFileSystem;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.NameScope;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.apache.commons.vfs2.provider.AbstractFileObject;
import org.apache.commons.vfs2.provider.AbstractFileSystem;
import org.apache.commons.vfs2.provider.URLFileName;

public class GoogleCloudStorageFileObject
extends AbstractFileObject<GoogleCloudStorageFileSystem> {
    public static final String DELIMITER = "/";
    private Storage storage;

    public GoogleCloudStorageFileObject(AbstractFileName name, GoogleCloudStorageFileSystem fs, Storage storage) {
        super(name, (AbstractFileSystem)fs);
        this.storage = storage;
    }

    protected long doGetContentSize() throws Exception {
        Blob blob = this.getBlob();
        return blob != null ? blob.getSize() : 0L;
    }

    protected FileType doGetType() throws Exception {
        if (this.getName().getPath().equals(DELIMITER) || this.getName().getPath().endsWith(DELIMITER) || this.getName().getPath().equals("")) {
            return FileType.FOLDER;
        }
        Blob blob = this.getBlob();
        if (blob != null) {
            if (blob.getName().endsWith(DELIMITER)) {
                return FileType.FOLDER;
            }
            return FileType.FILE;
        }
        return FileType.IMAGINARY;
    }

    protected String[] doListChildren() throws Exception {
        List<Object> items = new ArrayList();
        HashMap folders = new HashMap();
        Bucket bucket = this.storage.get(this.getBucketName(), new Storage.BucketGetOption[0]);
        if (bucket != null && bucket.exists(new Bucket.BucketSourceOption[0])) {
            folders.put("", new ArrayList());
            for (Blob blob : bucket.list(new Storage.BlobListOption[0]).iterateAll()) {
                String path = blob.getName();
                boolean isDirectory = path.endsWith(DELIMITER);
                String parent = "";
                if (path.contains(DELIMITER)) {
                    parent = path.substring(0, path.lastIndexOf(DELIMITER));
                }
                String[] parts = path.split(DELIMITER);
                String name = parts[parts.length - 1];
                if (isDirectory) {
                    folders.put(this.fixSlashes(path, false), new ArrayList());
                    name = name.concat(DELIMITER);
                    parent = path.substring(0, path.lastIndexOf(DELIMITER));
                    parent = parent.contains(DELIMITER) ? parent.substring(0, parent.lastIndexOf(DELIMITER)) : "";
                }
                List folderList = folders.getOrDefault(this.fixSlashes(parent, true), new ArrayList());
                folderList.add(name);
                folders.put(this.fixSlashes(parent, true), folderList);
            }
            items = folders.getOrDefault(this.fixSlashes(this.getName().getPath(), true), Collections.emptyList());
        }
        return items.toArray(new String[items.size()]);
    }

    private String fixSlashes(String value, boolean isDirectory) {
        if (!value.startsWith(DELIMITER)) {
            value = DELIMITER.concat(value);
        }
        if (isDirectory && !value.endsWith(DELIMITER)) {
            value = value.concat(DELIMITER);
        }
        return value;
    }

    protected long doGetLastModifiedTime() throws Exception {
        return this.getBlob().getUpdateTime();
    }

    public String getBucketName() {
        return ((URLFileName)this.getName()).getHostName();
    }

    public Blob getBlob() {
        URLFileName urlFileName = (URLFileName)this.getName();
        Bucket bucket = this.storage.get(urlFileName.getHostName(), new Storage.BucketGetOption[0]);
        if (urlFileName.getPath().equals(DELIMITER)) {
            return null;
        }
        String stripped = urlFileName.getPath().substring(1, urlFileName.getPath().length());
        Blob blob = bucket.get(stripped, new Storage.BlobGetOption[0]);
        if (blob == null) {
            blob = bucket.get(stripped.concat(DELIMITER), new Storage.BlobGetOption[0]);
        }
        return blob;
    }

    public BlobInfo getBlobInfo(String name) {
        return BlobInfo.newBuilder((String)this.getBucketName(), (String)name).build();
    }

    protected OutputStream doGetOutputStream(boolean bAppend) throws FileSystemException {
        BlobInfo blobInfo = BlobInfo.newBuilder((String)this.getBucketName(), (String)this.getPath()).build();
        Blob blob = this.storage.create(blobInfo, new Storage.BlobTargetOption[0]);
        return Channels.newOutputStream((WritableByteChannel)blob.writer(new Storage.BlobWriteOption[0]));
    }

    protected InputStream doGetInputStream() throws Exception {
        return Channels.newInputStream((ReadableByteChannel)this.getBlob().reader(new Blob.BlobSourceOption[0]));
    }

    protected void doDelete() throws Exception {
        this.getBlob().delete(new Blob.BlobSourceOption[0]);
    }

    protected void doRename(FileObject newFile) throws Exception {
        BlobInfo blobInfo = BlobInfo.newBuilder((String)((GoogleCloudStorageFileObject)newFile).getBucketName(), (String)((GoogleCloudStorageFileObject)newFile).getPath()).build();
        Blob newBlob = this.storage.create(blobInfo, new Storage.BlobTargetOption[0]);
        this.getBlob().copyTo(newBlob.getBlobId(), new Blob.BlobSourceOption[0]);
        this.getBlob().delete(new Blob.BlobSourceOption[0]);
    }

    public boolean exists() throws FileSystemException {
        return this.getBlob() != null || this.getName().getPath().equals(DELIMITER);
    }

    private String getPath() {
        return this.getName().getPath().substring(1, this.getName().getPath().length());
    }

    protected void doCreateFolder() throws Exception {
        BlobInfo blobInfo = this.getBlobInfo(this.getPath().concat(DELIMITER));
        this.storage.create(blobInfo, new Storage.BlobTargetOption[0]);
    }

    public FileObject resolveFile(String path) throws FileSystemException {
        return super.resolveFile(path);
    }

    public FileObject resolveFile(String name, NameScope scope) throws FileSystemException {
        return super.resolveFile(name, scope);
    }
}

