/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ldap.repository.support;

import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Predicate;
import java.util.List;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.querydsl.QueryDslPredicateExecutor;
import org.springframework.ldap.core.LdapOperations;
import org.springframework.ldap.odm.core.ObjectDirectoryMapper;
import org.springframework.ldap.repository.support.QueryDslLdapQuery;
import org.springframework.ldap.repository.support.SimpleLdapRepository;

public class QueryDslLdapRepository<T>
extends SimpleLdapRepository<T>
implements QueryDslPredicateExecutor<T> {
    public QueryDslLdapRepository(LdapOperations ldapOperations, ObjectDirectoryMapper odm, Class<T> clazz) {
        super(ldapOperations, odm, clazz);
    }

    public T findOne(Predicate predicate) {
        return this.queryFor(predicate).uniqueResult();
    }

    public List<T> findAll(Predicate predicate) {
        return this.queryFor(predicate).list();
    }

    public long count(Predicate predicate) {
        return this.findAll(predicate).size();
    }

    public boolean exists(Predicate predicate) {
        return this.count(predicate) > 0L;
    }

    public Iterable<T> findAll(Predicate predicate, Sort sort) {
        throw new UnsupportedOperationException();
    }

    private QueryDslLdapQuery<T> queryFor(Predicate predicate) {
        return new QueryDslLdapQuery(this.getLdapOperations(), this.getClazz()).where(new Predicate[]{predicate});
    }

    public Iterable<T> findAll(OrderSpecifier<?> ... orders) {
        throw new UnsupportedOperationException();
    }

    public Iterable<T> findAll(Predicate predicate, OrderSpecifier<?> ... orders) {
        throw new UnsupportedOperationException();
    }

    public Page<T> findAll(Predicate predicate, Pageable pageable) {
        throw new UnsupportedOperationException();
    }
}

