/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ldap.repository.support;

import com.querydsl.core.types.Constant;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.FactoryExpression;
import com.querydsl.core.types.Operation;
import com.querydsl.core.types.Operator;
import com.querydsl.core.types.Ops;
import com.querydsl.core.types.ParamExpression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.SubQueryExpression;
import com.querydsl.core.types.TemplateExpression;
import com.querydsl.core.types.Visitor;
import org.springframework.ldap.filter.AndFilter;
import org.springframework.ldap.filter.EqualsFilter;
import org.springframework.ldap.filter.Filter;
import org.springframework.ldap.filter.GreaterThanOrEqualsFilter;
import org.springframework.ldap.filter.LessThanOrEqualsFilter;
import org.springframework.ldap.filter.LikeFilter;
import org.springframework.ldap.filter.NotFilter;
import org.springframework.ldap.filter.OrFilter;
import org.springframework.ldap.filter.PresentFilter;
import org.springframework.ldap.odm.core.ObjectDirectoryMapper;

class LdapSerializer
implements Visitor<Object, Void> {
    private final ObjectDirectoryMapper odm;
    private final Class<?> clazz;

    public LdapSerializer(ObjectDirectoryMapper odm, Class<?> clazz) {
        this.odm = odm;
        this.clazz = clazz;
    }

    public Filter handle(Expression<?> expression) {
        return (Filter)expression.accept((Visitor)this, null);
    }

    public Object visit(Constant<?> expr, Void context) {
        return expr.getConstant().toString();
    }

    public Object visit(FactoryExpression<?> expr, Void context) {
        throw new UnsupportedOperationException();
    }

    public Object visit(Operation<?> expr, Void context) {
        Operator operator = expr.getOperator();
        if (operator == Ops.EQ) {
            return new EqualsFilter(this.attribute(expr), this.value(expr));
        }
        if (operator == Ops.AND) {
            return new AndFilter().and(this.handle(expr.getArg(0))).and(this.handle(expr.getArg(1)));
        }
        if (operator == Ops.OR) {
            return new OrFilter().or(this.handle(expr.getArg(0))).or(this.handle(expr.getArg(1)));
        }
        if (operator == Ops.NOT) {
            return new NotFilter(this.handle(expr.getArg(0)));
        }
        if (operator == Ops.LIKE) {
            return new LikeFilter(this.attribute(expr), this.value(expr));
        }
        if (operator == Ops.STARTS_WITH || operator == Ops.STARTS_WITH_IC) {
            return new LikeFilter(this.attribute(expr), this.value(expr) + "*");
        }
        if (operator == Ops.ENDS_WITH || operator == Ops.ENDS_WITH_IC) {
            return new LikeFilter(this.attribute(expr), "*" + this.value(expr));
        }
        if (operator == Ops.STRING_CONTAINS || operator == Ops.STRING_CONTAINS_IC) {
            return new LikeFilter(this.attribute(expr), "*" + this.value(expr) + "*");
        }
        if (operator == Ops.IS_NOT_NULL) {
            return new PresentFilter(this.attribute(expr));
        }
        if (operator == Ops.IS_NULL) {
            return new NotFilter(new PresentFilter(this.attribute(expr)));
        }
        if (operator == Ops.GOE) {
            return new GreaterThanOrEqualsFilter(this.attribute(expr), this.value(expr));
        }
        if (operator == Ops.LOE) {
            return new LessThanOrEqualsFilter(this.attribute(expr), this.value(expr));
        }
        throw new UnsupportedOperationException("Unsupported operator " + operator.toString());
    }

    private String value(Operation<?> expr) {
        return (String)expr.getArg(1).accept((Visitor)this, null);
    }

    private String attribute(Operation<?> expr) {
        return this.odm.attributeFor(this.clazz, (String)expr.getArg(0).accept((Visitor)this, null));
    }

    public Object visit(ParamExpression<?> expr, Void context) {
        throw new UnsupportedOperationException();
    }

    public Object visit(Path<?> expr, Void context) {
        return expr.getMetadata().getName();
    }

    public Object visit(SubQueryExpression<?> expr, Void context) {
        throw new UnsupportedOperationException();
    }

    public Object visit(TemplateExpression<?> expr, Void context) {
        throw new UnsupportedOperationException();
    }
}

