/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.ui.xul.swing.tags;

import java.awt.Component;
import javax.swing.JTabbedPane;
import org.apache.commons.lang.NotImplementedException;
import org.pentaho.ui.xul.XulComponent;
import org.pentaho.ui.xul.XulDomContainer;
import org.pentaho.ui.xul.components.XulTabpanel;
import org.pentaho.ui.xul.containers.XulTabbox;
import org.pentaho.ui.xul.containers.XulTabpanels;
import org.pentaho.ui.xul.containers.XulTabs;
import org.pentaho.ui.xul.dom.Element;
import org.pentaho.ui.xul.swing.AbstractSwingContainer;
import org.pentaho.ui.xul.swing.tags.SwingTabpanels;
import org.pentaho.ui.xul.swing.tags.SwingTabs;

public class SwingTabbox
extends AbstractSwingContainer
implements XulTabbox {
    private JTabbedPane tabpane = new JTabbedPane();
    private SwingTabpanels panels;
    private SwingTabs tabs;
    private int selectedIndex;

    public SwingTabbox(Element self, XulComponent parent, XulDomContainer domContainer, String tagName) {
        super("tabbox");
        this.setManagedObject(this.tabpane);
    }

    @Override
    public void addChild(Element ele) {
        super.addChild(ele);
        if (ele instanceof SwingTabs) {
            this.tabs = (SwingTabs)ele;
        } else if (ele instanceof SwingTabpanels) {
            this.panels = (SwingTabpanels)ele;
        }
    }

    public int getSelectedIndex() {
        return this.tabpane.getSelectedIndex();
    }

    public XulTabpanel getSelectedPanel() {
        return this.panels.getTabpanelByIndex(this.getSelectedIndex());
    }

    public XulTabpanels getTabpanels() {
        return this.panels;
    }

    public XulTabs getTabs() {
        return this.tabs;
    }

    public void setSelectedIndex(int index) {
        this.selectedIndex = index;
        if (this.tabpane.getTabCount() > 0) {
            this.tabpane.setSelectedIndex(this.selectedIndex);
        }
    }

    @Override
    public void layout() {
        this.tabpane.removeAll();
        for (int i = 0; i < this.tabs.getChildNodes().size(); ++i) {
            XulTabpanel panel = this.panels.getTabpanelByIndex(i);
            if (panel == null) continue;
            this.tabpane.add((Component)panel.getManagedObject(), this.tabs.getTabByIndex(i).getLabel());
            this.tabpane.setEnabledAt(i, !this.tabs.getTabByIndex(i).isDisabled());
        }
        this.tabpane.setSelectedIndex(this.selectedIndex);
        this.initialized = true;
    }

    public void setTabDisabledAt(boolean flag, int pos) {
        this.tabpane.setEnabledAt(pos, !flag);
    }

    public void removeTab(int idx) {
        if (this.tabpane.getTabCount() > idx) {
            this.tabpane.remove(idx);
        }
    }

    public void removeTabpanel(int idx) {
        if (this.tabpane.getTabCount() > idx) {
            this.tabpane.remove(idx);
        }
    }

    public void addTab(int idx) {
        throw new NotImplementedException("addTab(int) not implemented in Swing");
    }

    public void addTabpanel(int idx) {
        throw new NotImplementedException("addTabpanel(int) not implemented in Swing");
    }

    public void setClosable(boolean flag) {
        throw new NotImplementedException("not implemented in Swing");
    }

    public boolean isClosable() {
        throw new NotImplementedException("not implemented in Swing");
    }

    public void setOnclose(String command) {
        throw new NotImplementedException("not implemented in Swing");
    }
}

