/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.ui.xul.swing.tags;

import java.awt.Component;
import java.awt.Dimension;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.pentaho.ui.xul.XulComponent;
import org.pentaho.ui.xul.XulDomContainer;
import org.pentaho.ui.xul.components.XulMessageBox;
import org.pentaho.ui.xul.dom.Element;
import org.pentaho.ui.xul.swing.SwingElement;

public class SwingMessageBox
extends SwingElement
implements XulMessageBox {
    private static final String OK = "OK";
    private static final String CANCEL = "Cancel";
    private static final String YES = "Yes";
    private static final String NO = "No";
    private static final String CLOSE = "Close";
    private Component parentObject = null;
    private String message = "Default Message";
    private String title = "Message Box";
    private Object[] defaultButtons = new Object[]{"OK"};
    private Object[] buttons = this.defaultButtons;
    private Object icon = new Integer(1);
    private boolean scrollable = false;
    private XulComponent parent;
    private String acceptLabel = "OK";

    public SwingMessageBox(Element self, XulComponent parent, XulDomContainer domContainer, String tagName) {
        super("messagebox");
        this.parent = domContainer.getDocumentRoot().getRootElement();
        this.parent.addChild((Element)this);
    }

    public Object[] getButtons() {
        return this.buttons;
    }

    public Object getIcon() {
        return this.icon;
    }

    public String getMessage() {
        return this.message;
    }

    public String getTitle() {
        return this.title;
    }

    public void setButtons(Object[] buttons) {
        this.buttons = buttons == null ? this.defaultButtons : buttons;
    }

    public void setIcon(Object icon) {
        this.icon = icon;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public int open() {
        int messageType = this.icon instanceof Integer ? (Integer)this.icon : 1;
        Icon imageIcon = this.icon instanceof Icon ? (Icon)this.icon : null;
        Object msgObject = null;
        if (this.scrollable) {
            JScrollPane sp = new JScrollPane(new JTextArea(this.message));
            sp.setPreferredSize(new Dimension(this.getWidth(), this.getHeight()));
            msgObject = sp;
        } else {
            msgObject = this.message;
        }
        return JOptionPane.showOptionDialog(this.getParentObject(), msgObject, this.title, -1, messageType, imageIcon, this.buttons, this.buttons[0]);
    }

    public void setScrollable(boolean scroll) {
        this.scrollable = scroll;
    }

    public void setModalParent(Object parent) {
        this.parentObject = (Component)parent;
    }

    private Component getParentObject() {
        if (this.parentObject != null) {
            return this.parentObject;
        }
        return (Component)this.parent.getManagedObject();
    }

    public void setAcceptLabel(String label) {
        this.acceptLabel = label;
    }
}

