/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.osgi.service.notifier;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.pentaho.di.osgi.OSGIPluginTracker;
import org.pentaho.di.osgi.OSGIPluginTrackerException;
import org.pentaho.di.osgi.ServiceReferenceListener;
import org.pentaho.di.osgi.service.lifecycle.LifecycleEvent;
import org.pentaho.osgi.api.BeanFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelayedInstanceNotifier
implements Runnable {
    private final Map<Object, List<ServiceReferenceListener>> instanceListeners;
    private final ScheduledExecutorService scheduler;
    private final OSGIPluginTracker osgiPluginTracker;
    private final LifecycleEvent eventType;
    private final Object serviceObject;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public DelayedInstanceNotifier(OSGIPluginTracker osgiPluginTracker, LifecycleEvent eventType, Object serviceObject, Map<Object, List<ServiceReferenceListener>> instanceListeners, ScheduledExecutorService scheduler) {
        this.osgiPluginTracker = osgiPluginTracker;
        this.eventType = eventType;
        this.serviceObject = serviceObject;
        this.instanceListeners = instanceListeners;
        this.scheduler = scheduler;
    }

    @Override
    public void run() {
        BeanFactory factory = null;
        try {
            factory = this.osgiPluginTracker.findOrCreateBeanFactoryFor(this.serviceObject);
        }
        catch (OSGIPluginTrackerException e) {
            this.logger.error("Error getting bean factory", (Throwable)e);
        }
        if (factory == null) {
            ScheduledFuture<?> e = this.scheduler.schedule(this, 2L, TimeUnit.SECONDS);
        } else {
            List<ServiceReferenceListener> listeners = this.instanceListeners.get(this.serviceObject);
            if (listeners != null) {
                for (ServiceReferenceListener listener : listeners) {
                    listener.serviceEvent(this.eventType, this.serviceObject);
                }
            }
        }
    }
}

