/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.ee.servlet;

import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.Scheduler;
import org.quartz.impl.StdSchedulerFactory;

public class QuartzInitializerListener
implements ServletContextListener {
    public static final String QUARTZ_FACTORY_KEY = "org.quartz.impl.StdSchedulerFactory.KEY";
    private boolean performShutdown = true;
    private Scheduler scheduler = null;
    private final Log log = LogFactory.getLog(this.getClass());

    public void contextInitialized(ServletContextEvent sce) {
        this.log.info((Object)"Quartz Initializer Servlet loaded, initializing Scheduler...");
        ServletContext servletContext = sce.getServletContext();
        try {
            String configFile = servletContext.getInitParameter("config-file");
            String shutdownPref = servletContext.getInitParameter("shutdown-on-unload");
            if (shutdownPref != null) {
                this.performShutdown = Boolean.valueOf(shutdownPref);
            }
            StdSchedulerFactory factory = configFile != null ? new StdSchedulerFactory(configFile) : new StdSchedulerFactory();
            this.scheduler = factory.getScheduler();
            String startOnLoad = servletContext.getInitParameter("start-scheduler-on-load");
            int startDelay = 0;
            String startDelayS = servletContext.getInitParameter("start-delay-seconds");
            try {
                if (startDelayS != null && startDelayS.trim().length() > 0) {
                    startDelay = Integer.parseInt(startDelayS);
                }
            }
            catch (Exception e) {
                this.log.error((Object)("Cannot parse value of 'start-delay-seconds' to an integer: " + startDelayS + ", defaulting to 5 seconds."));
                startDelay = 5;
            }
            if (startOnLoad == null || Boolean.valueOf(startOnLoad).booleanValue()) {
                if (startDelay <= 0) {
                    this.scheduler.start();
                    this.log.info((Object)"Scheduler has been started...");
                } else {
                    this.scheduler.startDelayed(startDelay);
                    this.log.info((Object)("Scheduler will start in " + startDelay + " seconds."));
                }
            } else {
                this.log.info((Object)"Scheduler has not been started. Use scheduler.start()");
            }
            String factoryKey = servletContext.getInitParameter("servlet-context-factory-key");
            if (factoryKey == null) {
                factoryKey = QUARTZ_FACTORY_KEY;
            }
            this.log.info((Object)("Storing the Quartz Scheduler Factory in the servlet context at key: " + factoryKey));
            servletContext.setAttribute(factoryKey, (Object)factory);
        }
        catch (Exception e) {
            this.log.error((Object)("Quartz Scheduler failed to initialize: " + e.toString()));
            e.printStackTrace();
        }
    }

    public void contextDestroyed(ServletContextEvent sce) {
        if (!this.performShutdown) {
            return;
        }
        try {
            if (this.scheduler != null) {
                this.scheduler.shutdown();
            }
        }
        catch (Exception e) {
            this.log.error((Object)("Quartz Scheduler failed to shutdown cleanly: " + e.toString()));
            e.printStackTrace();
        }
        this.log.info((Object)"Quartz Scheduler successful shutdown.");
    }
}

