/*
 * Decompiled with CFR 0.152.
 */
package co.cask.tephra;

import co.cask.tephra.TransactionType;
import java.util.Arrays;

public class Transaction {
    private final long readPointer;
    private final long txId;
    private final long writePointer;
    private final long[] invalids;
    private final long[] inProgress;
    private final long firstShortInProgress;
    private final TransactionType type;
    private final long[] checkpointWritePointers;
    private VisibilityLevel visibilityLevel = VisibilityLevel.SNAPSHOT;
    private static final long[] NO_EXCLUDES = new long[0];
    public static final long NO_TX_IN_PROGRESS = Long.MAX_VALUE;
    public static final Transaction ALL_VISIBLE_LATEST = new Transaction(Long.MAX_VALUE, Long.MAX_VALUE, NO_EXCLUDES, NO_EXCLUDES, Long.MAX_VALUE, TransactionType.SHORT);

    public Transaction(long readPointer, long txId, long[] invalids, long[] inProgress, long firstShortInProgress) {
        this(readPointer, txId, invalids, inProgress, firstShortInProgress, TransactionType.SHORT);
    }

    public Transaction(long readPointer, long txId, long[] invalids, long[] inProgress, long firstShortInProgress, TransactionType type) {
        this(readPointer, txId, txId, invalids, inProgress, firstShortInProgress, type, new long[0], VisibilityLevel.SNAPSHOT);
    }

    public Transaction(long readPointer, long txId, long writePointer, long[] invalids, long[] inProgress, long firstShortInProgress, TransactionType type, long[] checkpointPointers, VisibilityLevel visibilityLevel) {
        this.readPointer = readPointer;
        this.txId = txId;
        this.writePointer = writePointer;
        this.invalids = invalids;
        this.inProgress = inProgress;
        this.firstShortInProgress = firstShortInProgress;
        this.type = type;
        this.checkpointWritePointers = checkpointPointers;
        this.visibilityLevel = visibilityLevel;
    }

    public Transaction(Transaction toCopy, long writePointer, long[] checkpointPointers) {
        this(toCopy.getReadPointer(), toCopy.getTransactionId(), writePointer, toCopy.getInvalids(), toCopy.getInProgress(), toCopy.getFirstShortInProgress(), toCopy.getType(), checkpointPointers, toCopy.getVisibilityLevel());
    }

    public long getReadPointer() {
        return this.readPointer;
    }

    public long getTransactionId() {
        return this.txId;
    }

    public long getWritePointer() {
        return this.writePointer;
    }

    public long[] getInvalids() {
        return this.invalids;
    }

    public long[] getInProgress() {
        return this.inProgress;
    }

    public long getFirstInProgress() {
        return this.inProgress.length == 0 ? Long.MAX_VALUE : this.inProgress[0];
    }

    public TransactionType getType() {
        return this.type;
    }

    public long getVisibilityUpperBound() {
        return this.inProgress.length == 0 ? Math.min(this.txId - 1L, this.readPointer) : this.inProgress[0] - 1L;
    }

    public long getFirstShortInProgress() {
        return this.firstShortInProgress;
    }

    public boolean isInProgress(long version) {
        return Arrays.binarySearch(this.inProgress, version) >= 0;
    }

    public boolean isExcluded(long version) {
        return Arrays.binarySearch(this.inProgress, version) >= 0 || Arrays.binarySearch(this.invalids, version) >= 0;
    }

    public boolean isCheckpoint(long version) {
        return Arrays.binarySearch(this.checkpointWritePointers, version) >= 0;
    }

    public boolean isVisible(long version) {
        return version <= this.getReadPointer() && !this.isExcluded(version) || (this.txId == version || this.isCheckpoint(version)) && (this.visibilityLevel == VisibilityLevel.SNAPSHOT || this.writePointer != version);
    }

    public void setVisibility(VisibilityLevel level) {
        this.visibilityLevel = level;
    }

    public VisibilityLevel getVisibilityLevel() {
        return this.visibilityLevel;
    }

    public boolean hasExcludes() {
        return this.invalids.length > 0 || this.inProgress.length > 0;
    }

    public int excludesSize() {
        return this.invalids.length + this.inProgress.length;
    }

    public long[] getCheckpointWritePointers() {
        return this.checkpointWritePointers;
    }

    public String toString() {
        return new StringBuilder(100).append(Transaction.class.getSimpleName()).append('{').append("readPointer: ").append(this.readPointer).append(", transactionId: ").append(this.txId).append(", writePointer: ").append(this.writePointer).append(", invalids: ").append(Arrays.toString(this.invalids)).append(", inProgress: ").append(Arrays.toString(this.inProgress)).append(", firstShortInProgress: ").append(this.firstShortInProgress).append(", type: ").append((Object)this.type).append(", checkpointWritePointers: ").append(Arrays.toString(this.checkpointWritePointers)).append(", visibilityLevel: ").append((Object)this.visibilityLevel).append('}').toString();
    }

    public static enum VisibilityLevel {
        SNAPSHOT,
        SNAPSHOT_EXCLUDE_CURRENT;

    }
}

