/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlSpecialOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.SqlValidatorScope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlWith
extends SqlCall {
    public final SqlNodeList withList;
    public final SqlNode body;

    public SqlWith(SqlParserPos pos, SqlNodeList withList, SqlNode body) {
        super(pos);
        this.withList = withList;
        this.body = body;
    }

    @Override
    public SqlKind getKind() {
        return SqlKind.WITH;
    }

    @Override
    public SqlOperator getOperator() {
        return SqlWithOperator.INSTANCE;
    }

    @Override
    public List<SqlNode> getOperandList() {
        return ImmutableList.of((Object)this.withList, (Object)this.body);
    }

    @Override
    public void validate(SqlValidator validator, SqlValidatorScope scope) {
        validator.validateWith(this, scope);
    }

    private static class SqlWithOperator
    extends SqlSpecialOperator {
        private static final SqlWithOperator INSTANCE = new SqlWithOperator();

        private SqlWithOperator() {
            super("WITH", SqlKind.WITH, 2);
        }

        public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
            SqlWith with = (SqlWith)call;
            SqlWriter.Frame frame = writer.startList(SqlWriter.FrameTypeEnum.WITH, "WITH", "");
            SqlWriter.Frame frame1 = writer.startList("", "");
            for (SqlNode node : with.withList) {
                writer.sep(",");
                node.unparse(writer, 0, 0);
            }
            writer.endList(frame1);
            with.body.unparse(writer, 0, 0);
            writer.endList(frame);
        }

        public SqlCall createCall(SqlLiteral functionQualifier, SqlParserPos pos, SqlNode ... operands) {
            return new SqlWith(pos, (SqlNodeList)operands[0], operands[1]);
        }

        public void validateCall(SqlCall call, SqlValidator validator, SqlValidatorScope scope, SqlValidatorScope operandScope) {
            validator.validateWith((SqlWith)call, scope);
        }
    }
}

