/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.schema.impl;

import com.google.common.collect.ImmutableList;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.schema.Function;
import org.apache.calcite.schema.FunctionParameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ReflectiveFunctionBase
implements Function {
    public final Method method;
    public final List<FunctionParameter> parameters;

    public ReflectiveFunctionBase(Method method) {
        this.method = method;
        this.parameters = ReflectiveFunctionBase.toFunctionParameters(method.getParameterTypes());
    }

    @Override
    public List<FunctionParameter> getParameters() {
        return this.parameters;
    }

    public static ImmutableList<FunctionParameter> toFunctionParameters(Class ... types) {
        return ReflectiveFunctionBase.toFunctionParameters(Arrays.asList(types));
    }

    public static ImmutableList<FunctionParameter> toFunctionParameters(Iterable<? extends Class> types) {
        ImmutableList.Builder res = ImmutableList.builder();
        int i = 0;
        for (final Class clazz : types) {
            final int ordinal = i++;
            res.add((Object)new FunctionParameter(){

                public int getOrdinal() {
                    return ordinal;
                }

                public String getName() {
                    return "arg" + ordinal;
                }

                public RelDataType getType(RelDataTypeFactory typeFactory) {
                    return typeFactory.createJavaType(clazz);
                }
            });
        }
        return res.build();
    }

    static boolean classHasPublicZeroArgsConstructor(Class<?> clazz) {
        for (Constructor<?> constructor : clazz.getConstructors()) {
            if (constructor.getParameterTypes().length != 0 || !Modifier.isPublic(constructor.getModifiers())) continue;
            return true;
        }
        return false;
    }

    static Method findMethod(Class<?> clazz, String name) {
        for (Method method : clazz.getMethods()) {
            if (!method.getName().equals(name)) continue;
            return method;
        }
        return null;
    }
}

