/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.plan;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptRuleOperandChildPolicy;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitPropagationVisitor;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RelOptRule {
    protected final String description;
    private final RelOptRuleOperand operand;
    public List<RelOptRuleOperand> operands;

    public RelOptRule(RelOptRuleOperand operand) {
        this(operand, null);
    }

    public RelOptRule(RelOptRuleOperand operand, String description) {
        assert (operand != null);
        this.operand = operand;
        if (description == null) {
            description = RelOptRule.guessDescription(this.getClass().getName());
        }
        if (!description.matches("[A-Za-z][-A-Za-z0-9_.():]*")) {
            throw new RuntimeException("Rule description '" + description + "' is not valid");
        }
        this.description = description;
        this.operands = this.flattenOperands(operand);
        this.assignSolveOrder();
    }

    public static <R extends RelNode> RelOptRuleOperand operand(Class<R> clazz, RelOptRuleOperandChildren operandList) {
        return new RelOptRuleOperand(clazz, null, Predicates.alwaysTrue(), operandList);
    }

    public static <R extends RelNode> RelOptRuleOperand operand(Class<R> clazz, RelTrait trait, RelOptRuleOperandChildren operandList) {
        return new RelOptRuleOperand(clazz, trait, Predicates.alwaysTrue(), operandList);
    }

    public static <R extends RelNode> RelOptRuleOperand operand(Class<R> clazz, RelTrait trait, Predicate<? super R> predicate, RelOptRuleOperandChildren operandList) {
        return new RelOptRuleOperand(clazz, trait, predicate, operandList);
    }

    public static <R extends RelNode> RelOptRuleOperand operand(Class<R> clazz, RelTrait trait, Predicate<? super R> predicate, RelOptRuleOperand first, RelOptRuleOperand ... rest) {
        return new RelOptRuleOperand(clazz, trait, predicate, RelOptRule.some(first, rest));
    }

    public static <R extends RelNode> RelOptRuleOperand operand(Class<R> clazz, RelOptRuleOperand first, RelOptRuleOperand ... rest) {
        return RelOptRule.operand(clazz, RelOptRule.some(first, rest));
    }

    public static RelOptRuleOperandChildren some(RelOptRuleOperand first, RelOptRuleOperand ... rest) {
        return new RelOptRuleOperandChildren(RelOptRuleOperandChildPolicy.SOME, (ImmutableList<RelOptRuleOperand>)ImmutableList.builder().add((Object)first).add((Object[])rest).build());
    }

    public static RelOptRuleOperandChildren unordered(RelOptRuleOperand first, RelOptRuleOperand ... rest) {
        return new RelOptRuleOperandChildren(RelOptRuleOperandChildPolicy.UNORDERED, (ImmutableList<RelOptRuleOperand>)ImmutableList.builder().add((Object)first).add((Object[])rest).build());
    }

    public static RelOptRuleOperandChildren none() {
        return RelOptRuleOperandChildren.LEAF_CHILDREN;
    }

    public static RelOptRuleOperandChildren any() {
        return RelOptRuleOperandChildren.ANY_CHILDREN;
    }

    private List<RelOptRuleOperand> flattenOperands(RelOptRuleOperand rootOperand) {
        ArrayList<RelOptRuleOperand> operandList = new ArrayList<RelOptRuleOperand>();
        rootOperand.setRule(this);
        rootOperand.setParent(null);
        rootOperand.ordinalInParent = 0;
        rootOperand.ordinalInRule = operandList.size();
        operandList.add(rootOperand);
        this.flattenRecurse(operandList, rootOperand);
        return ImmutableList.copyOf(operandList);
    }

    private void flattenRecurse(List<RelOptRuleOperand> operandList, RelOptRuleOperand parentOperand) {
        int k = 0;
        for (RelOptRuleOperand operand : parentOperand.getChildOperands()) {
            operand.setRule(this);
            operand.setParent(parentOperand);
            operand.ordinalInParent = k++;
            operand.ordinalInRule = operandList.size();
            operandList.add(operand);
            this.flattenRecurse(operandList, operand);
        }
    }

    private void assignSolveOrder() {
        for (RelOptRuleOperand operand : this.operands) {
            operand.solveOrder = new int[this.operands.size()];
            int m = 0;
            for (RelOptRuleOperand o = operand; o != null; o = o.getParent()) {
                operand.solveOrder[m++] = o.ordinalInRule;
            }
            for (int k = 0; k < this.operands.size(); ++k) {
                boolean exists = false;
                for (int n = 0; n < m; ++n) {
                    if (operand.solveOrder[n] != k) continue;
                    exists = true;
                }
                if (exists) continue;
                operand.solveOrder[m++] = k;
            }
            assert (m == this.operands.size());
        }
    }

    public RelOptRuleOperand getOperand() {
        return this.operand;
    }

    public List<RelOptRuleOperand> getOperands() {
        return ImmutableList.copyOf(this.operands);
    }

    public int hashCode() {
        return this.description.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof RelOptRule && this.equals((RelOptRule)obj);
    }

    protected boolean equals(RelOptRule that) {
        return this.description.equals(that.description) && this.getClass() == that.getClass() && this.operand.equals(that.operand);
    }

    public boolean matches(RelOptRuleCall call) {
        return true;
    }

    public abstract void onMatch(RelOptRuleCall var1);

    public Convention getOutConvention() {
        return null;
    }

    public RelTrait getOutTrait() {
        return null;
    }

    public final String toString() {
        return this.description;
    }

    public static RelNode convert(RelNode rel, RelTraitSet toTraits) {
        RelOptPlanner planner = rel.getCluster().getPlanner();
        if (rel.getTraitSet().size() < toTraits.size()) {
            new RelTraitPropagationVisitor(planner, toTraits).go(rel);
        }
        RelTraitSet outTraits = rel.getTraitSet();
        for (int i = 0; i < toTraits.size(); ++i) {
            RelTrait toTrait = toTraits.getTrait(i);
            if (toTrait == null) continue;
            outTraits = outTraits.replace(i, toTrait);
        }
        if (rel.getTraitSet().matches(outTraits)) {
            return rel;
        }
        return planner.changeTraits(rel, outTraits);
    }

    public static List<RelNode> convertList(List<RelNode> rels, final RelTrait trait) {
        return Lists.transform(rels, (Function)new Function<RelNode, RelNode>(){

            public RelNode apply(RelNode rel) {
                return RelOptRule.convert(rel, rel.getTraitSet().replace(trait));
            }
        });
    }

    static String guessDescription(String className) {
        String description = className;
        int punc = Math.max(className.lastIndexOf(46), className.lastIndexOf(36));
        if (punc >= 0) {
            description = className.substring(punc + 1);
        }
        if (description.matches("[0-9]+")) {
            throw new RuntimeException("Derived description of rule class " + className + " is an integer, not valid. " + "Supply a description manually.");
        }
        return description;
    }
}

