/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.enumerable;

import org.apache.calcite.adapter.enumerable.EnumerableConvention;
import org.apache.calcite.adapter.enumerable.EnumerableSort;
import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.convert.ConverterRule;
import org.apache.calcite.rel.core.Sort;

class EnumerableSortRule
extends ConverterRule {
    EnumerableSortRule() {
        super(Sort.class, Convention.NONE, EnumerableConvention.INSTANCE, "EnumerableSortRule");
    }

    public RelNode convert(RelNode rel) {
        Sort sort = (Sort)rel;
        if (sort.offset != null || sort.fetch != null) {
            return null;
        }
        RelTraitSet traitSet = sort.getTraitSet().replace(EnumerableConvention.INSTANCE);
        RelNode input = sort.getInput();
        return new EnumerableSort(rel.getCluster(), traitSet, EnumerableSortRule.convert(input, input.getTraitSet().replace(EnumerableConvention.INSTANCE)), sort.getCollation(), null, null);
    }
}

